/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import io.github.wouink.furnish.block.tileentity.MailboxTileEntity;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class MailboxRenderer
implements BlockEntityRenderer<MailboxTileEntity> {
    private final Camera camera;
    private final Font font;

    public MailboxRenderer(BlockEntityRendererProvider.Context ctx) {
        Minecraft minecraft = Minecraft.m_91087_();
        this.camera = minecraft.f_91063_.m_109153_();
        this.font = ctx.m_173586_();
    }

    public void render(MailboxTileEntity mailbox, float partialTicks, PoseStack ps, MultiBufferSource buffer, int light, int overlay) {
        if (this.shouldShowName(mailbox)) {
            this.renderNameTag(mailbox, ps, buffer, light);
        }
    }

    private boolean shouldShowName(MailboxTileEntity mailbox) {
        if (!mailbox.hasOwner()) {
            return false;
        }
        HitResult hitResult = this.camera.m_90592_().m_19907_(20.0, 0.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = ((BlockHitResult)hitResult).m_82425_();
            return pos.equals((Object)mailbox.m_58899_());
        }
        return false;
    }

    private void renderNameTag(MailboxTileEntity mailbox, PoseStack ms, MultiBufferSource buffer, int light) {
        if (!Minecraft.m_91404_()) {
            return;
        }
        Component content = mailbox.getOwnerDisplayName();
        if (content == null) {
            content = new TextComponent("???");
        }
        ms.m_85836_();
        ms.m_85837_(0.5, 1.0, 0.5);
        ms.m_85845_(this.camera.m_90591_());
        ms.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = ms.m_85850_().m_85861_();
        float backOpacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int alpha = (int)(backOpacity * 255.0f) << 24;
        float centerOffset = -this.font.m_92852_((FormattedText)content) / 2;
        this.font.m_92841_(content, centerOffset, 0.0f, 0x20FFFFFF, false, matrix4f, buffer, false, alpha, light);
        this.font.m_92841_(content, centerOffset, 0.0f, -1, false, matrix4f, buffer, false, 0, light);
        ms.m_85849_();
    }
}

