/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import io.github.wouink.furnish.block.Plate;
import io.github.wouink.furnish.block.tileentity.ShelfTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;

public class ShelfRenderer
implements BlockEntityRenderer<ShelfTileEntity> {
    private final ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();

    public ShelfRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(ShelfTileEntity shelf, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        ItemStack stack = shelf.getHeldItem();
        if (!stack.m_41619_()) {
            ms.m_85836_();
            BakedModel model = this.itemRenderer.m_174264_(stack, shelf.m_58904_(), null, 0);
            Direction dir = ((Direction)shelf.m_58900_().m_61143_((Property)Plate.f_54117_)).m_122424_();
            if (stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() instanceof Plate) {
                this.prepareRenderPlate(ms, dir);
            } else if (model.m_7539_()) {
                this.prepareRenderBlock(ms, dir);
            } else {
                this.prepareRenderItem(ms, dir);
            }
            this.itemRenderer.m_115143_(stack, ItemTransforms.TransformType.FIXED, true, ms, buffer, light, overlay, model);
            ms.m_85849_();
        }
    }

    public void prepareRenderItem(PoseStack ms, Direction dir) {
        switch (dir) {
            case NORTH: {
                ms.m_85837_(0.5, 0.5, 0.125);
                break;
            }
            case SOUTH: {
                ms.m_85837_(0.5, 0.5, 0.875);
                break;
            }
            case WEST: {
                ms.m_85837_(0.125, 0.5, 0.5);
                break;
            }
            default: {
                ms.m_85837_(0.875, 0.5, 0.5);
            }
        }
        float angle = -dir.m_122435_();
        ms.m_85845_(Vector3f.f_122225_.m_122240_(angle));
        ms.m_85841_(0.6f, 0.6f, 0.6f);
    }

    public void prepareRenderBlock(PoseStack ms, Direction dir) {
        switch (dir) {
            case NORTH: {
                ms.m_85837_(0.5, 0.35, 0.15);
                break;
            }
            case SOUTH: {
                ms.m_85837_(0.5, 0.35, 0.85);
                break;
            }
            case WEST: {
                ms.m_85837_(0.15, 0.35, 0.5);
                break;
            }
            default: {
                ms.m_85837_(0.85, 0.35, 0.5);
            }
        }
        float angle = -dir.m_122435_();
        ms.m_85845_(Vector3f.f_122225_.m_122240_(angle));
        ms.m_85841_(0.6f, 0.6f, 0.6f);
    }

    public void prepareRenderPlate(PoseStack ms, Direction dir) {
        switch (dir) {
            case NORTH: {
                ms.m_85837_(0.5, 0.5, 0.35);
                break;
            }
            case SOUTH: {
                ms.m_85837_(0.5, 0.5, 0.65);
                ms.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                break;
            }
            case WEST: {
                ms.m_85837_(0.35, 0.5, 0.5);
                ms.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                break;
            }
            default: {
                ms.m_85837_(0.65, 0.5, 0.5);
                ms.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
            }
        }
        ms.m_85845_(Vector3f.f_122223_.m_122240_(80.0f));
        ms.m_85841_(1.0f, 1.0f, 1.0f);
    }
}

