/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class CyclePainting {
    public static List<Motive> getSimilarSizeArt(Motive art) {
        ArrayList<Motive> similar = new ArrayList<Motive>();
        for (Motive p : ForgeRegistries.PAINTING_TYPES.getValues()) {
            if (p.m_31896_() != art.m_31896_() || p.m_31901_() != art.m_31901_()) continue;
            similar.add(p);
        }
        return similar;
    }

    @SubscribeEvent
    public static void onPaintingInteract(PlayerInteractEvent.EntityInteract event) {
        Level world = event.getWorld();
        if (world.m_5776_()) {
            return;
        }
        if (!event.getItemStack().m_41720_().equals(Items.f_42487_)) {
            return;
        }
        if (!(event.getTarget() instanceof Painting)) {
            return;
        }
        Painting target = (Painting)event.getTarget();
        Motive newArt = null;
        List<Motive> similarSizeArts = CyclePainting.getSimilarSizeArt(target.f_31902_);
        if (similarSizeArts.isEmpty() || similarSizeArts.size() < 2) {
            event.getPlayer().m_5661_((Component)new TranslatableComponent("msg.furnish.cycle_no_painting"), true);
            return;
        }
        if (event.getPlayer().m_6047_()) {
            Collections.reverse(similarSizeArts);
        }
        int index = similarSizeArts.indexOf(target.f_31902_);
        newArt = similarSizeArts.get((index + 1) % similarSizeArts.size());
        Painting newPainting = new Painting(world, target.m_31748_(), target.m_6374_());
        newPainting.f_31902_ = newArt;
        target.m_142687_(Entity.RemovalReason.DISCARDED);
        world.m_7967_((Entity)newPainting);
    }
}

