/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.libmc;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class RfEnergy {
    public static int feed(Level world, BlockPos pos, @Nullable Direction side, int rf_energy) {
        BlockEntity te = world.m_7702_(pos);
        if (te == null) {
            return 0;
        }
        IEnergyStorage es = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, side).orElse(null);
        if (es == null) {
            return 0;
        }
        return es.receiveEnergy(rf_energy, false);
    }

    public static class Battery
    implements IEnergyStorage {
        protected int capacity_;
        protected int charge_rate_;
        protected int discharge_rate_;
        protected int energy_;

        public Battery(int capacity) {
            this(capacity, capacity);
        }

        public Battery(int capacity, int transfer_rate) {
            this(capacity, transfer_rate, transfer_rate, 0);
        }

        public Battery(int capacity, int charge_rate, int discharge_rate) {
            this(capacity, charge_rate, discharge_rate, 0);
        }

        public Battery(int capacity, int charge_rate, int discharge_rate, int energy) {
            this.capacity_ = Math.max(capacity, 1);
            this.charge_rate_ = Mth.m_14045_((int)charge_rate, (int)0, (int)this.capacity_);
            this.discharge_rate_ = Mth.m_14045_((int)discharge_rate, (int)0, (int)this.capacity_);
            this.energy_ = Mth.m_14045_((int)energy, (int)0, (int)this.capacity_);
        }

        public Battery setMaxEnergyStored(int capacity) {
            this.capacity_ = Math.max(capacity, 1);
            return this;
        }

        public Battery setEnergyStored(int energy) {
            this.energy_ = Mth.m_14045_((int)energy, (int)0, (int)this.capacity_);
            return this;
        }

        public Battery setChargeRate(int in_rate) {
            this.charge_rate_ = Mth.m_14045_((int)in_rate, (int)0, (int)this.capacity_);
            return this;
        }

        public Battery setDischargeRate(int out_rate) {
            this.discharge_rate_ = Mth.m_14045_((int)out_rate, (int)0, (int)this.capacity_);
            return this;
        }

        public int getChargeRate() {
            return this.charge_rate_;
        }

        public int getDischargeRate() {
            return this.discharge_rate_;
        }

        public boolean isEmpty() {
            return this.energy_ <= 0;
        }

        public boolean isFull() {
            return this.energy_ >= this.capacity_;
        }

        public int getSOC() {
            return (int)Mth.m_14008_((double)(100.0 * (double)this.energy_ / (double)this.capacity_ + 0.5), (double)0.0, (double)100.0);
        }

        public int getComparatorOutput() {
            return (int)Mth.m_14008_((double)(15.0 * (double)this.energy_ / (double)this.capacity_ + 0.2), (double)0.0, (double)15.0);
        }

        public boolean draw(int energy) {
            if (this.energy_ < energy) {
                return false;
            }
            this.energy_ -= energy;
            return true;
        }

        public boolean feed(int energy) {
            this.energy_ = Math.min(this.energy_ + energy, this.capacity_);
            return this.energy_ >= this.capacity_;
        }

        public Battery clear() {
            this.energy_ = 0;
            return this;
        }

        public Battery load(CompoundTag nbt, String key) {
            this.setEnergyStored(nbt.m_128451_(key));
            return this;
        }

        public Battery load(CompoundTag nbt) {
            return this.load(nbt, "Energy");
        }

        public CompoundTag save(CompoundTag nbt, String key) {
            nbt.m_128405_(key, this.energy_);
            return nbt;
        }

        public CompoundTag save(CompoundTag nbt) {
            return this.save(nbt, "Energy");
        }

        public LazyOptional<IEnergyStorage> createEnergyHandler() {
            return LazyOptional.of(() -> this);
        }

        public int receiveEnergy(int feed_energy, boolean simulate) {
            if (!this.canReceive()) {
                return 0;
            }
            int e = Math.min(Math.min(this.charge_rate_, feed_energy), this.capacity_ - this.energy_);
            if (!simulate) {
                this.energy_ += e;
            }
            return e;
        }

        public int extractEnergy(int draw_energy, boolean simulate) {
            if (!this.canExtract()) {
                return 0;
            }
            int e = Math.min(Math.min(this.discharge_rate_, draw_energy), this.energy_);
            if (!simulate) {
                this.energy_ -= e;
            }
            return e;
        }

        public int getEnergyStored() {
            return this.energy_;
        }

        public int getMaxEnergyStored() {
            return this.capacity_;
        }

        public boolean canExtract() {
            return this.discharge_rate_ > 0;
        }

        public boolean canReceive() {
            return this.charge_rate_ > 0;
        }
    }
}

