/*
 * Decompiled with CFR 0.152.
 */
package com.zainjx.the_wild_update;

import com.google.common.collect.ImmutableMap;
import com.zainjx.the_wild_update.entity.ModEntityTypes;
import com.zainjx.the_wild_update.entity.render.ChestBoatRenderer;
import com.zainjx.the_wild_update.entity.render.DetectRenderer;
import com.zainjx.the_wild_update.entity.render.FrogRenderer;
import com.zainjx.the_wild_update.entity.render.ModBoatRenderer;
import com.zainjx.the_wild_update.entity.render.TadpoleRenderer;
import com.zainjx.the_wild_update.entity.render.VibrationRenderer;
import com.zainjx.the_wild_update.entity.render.WardenRenderer;
import com.zainjx.the_wild_update.events.ModEventBusEvents;
import com.zainjx.the_wild_update.gui.container.ModContainers;
import com.zainjx.the_wild_update.gui.screen.ChestBoatScreen;
import com.zainjx.the_wild_update.registry.ParticleList;
import com.zainjx.the_wild_update.registry.RegistryDeepdarkBlocks;
import com.zainjx.the_wild_update.registry.RegistryEffects;
import com.zainjx.the_wild_update.registry.RegistryItems;
import com.zainjx.the_wild_update.registry.RegistryMangrove;
import com.zainjx.the_wild_update.registry.RegistryMud;
import com.zainjx.the_wild_update.registry.RegistrySounds;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmlserverevents.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="the_wild_update")
public class TheWildUpdateMod {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "the_wild_update";

    public TheWildUpdateMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuffs);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModEventBusEvents::addEntityAttributes);
        ParticleList.PARTICLES.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.register((Object)this);
        RegistryMangrove.init();
        RegistryMud.init();
        RegistryDeepdarkBlocks.init();
        RegistryItems.init();
        RegistryEffects.init();
        RegistrySounds.init();
        ModEntityTypes.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModContainers.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private void setup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            AxeItem.f_150683_ = new ImmutableMap.Builder().putAll(AxeItem.f_150683_).put((Object)((Block)RegistryMangrove.MANGROVE_LOG.get()), (Object)((Block)RegistryMangrove.MANGROVE_STRIPPED_LOG.get())).build();
        });
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.FROG.get()), FrogRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.TADPOLE.get()), TadpoleRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.WARDEN.get()), WardenRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.VIBRATION_ENTITY.get()), VibrationRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.DETECT.get()), DetectRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.MANGROVE_BOAT.get()), ModBoatRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.MANGROVE_CHEST_BOAT.get()), ChestBoatRenderer::new);
    }

    private void doClientStuffs(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)RegistryMangrove.MANGROVE_DOOR.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)RegistryMangrove.MANGROVE_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)RegistryMangrove.MANGROVE_PROPAGULE.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)RegistryDeepdarkBlocks.SCULK_VEIN.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)RegistryDeepdarkBlocks.SCULK_SHRIEKER.get()), (RenderType)RenderType.m_110463_());
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.CHEST_BOAT_CONTAINER.get()), ChestBoatScreen::new);
        });
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)MOD_ID, (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.messageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            LOGGER.info("HELLO from Register Block");
        }
    }
}

