/*
 * Decompiled with CFR 0.152.
 */
package com.zainjx.the_wild_update.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zainjx.the_wild_update.entity.custom.WardenEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class WardenModel
extends EntityModel<WardenEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("the_wild_update", "warden"), "main");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart ears;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private final ModelPart left_leg;
    private final ModelPart right_leg;

    public WardenModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.left_arm = root.m_171324_("left_arm");
        this.right_arm = root.m_171324_("right_arm");
        this.head = root.m_171324_("head");
        this.ears = root.m_171324_("ears");
        this.left_leg = root.m_171324_("left_leg");
        this.right_leg = root.m_171324_("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171481_(-9.0f, -21.0f, -5.0f, 18.0f, 21.0f, 11.0f), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -0.0f, -5.0f, 16.0f, 16.0f, 10.0f), PartPose.m_171419_((float)0.0f, (float)-26.0f, (float)0.0f));
        PartDefinition ears = partdefinition.m_171599_("ears", CubeListBuilder.m_171558_().m_171514_(106, 36).m_171488_(-18.0f, -16.0f, 0.0f, 10.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(106, 46).m_171488_(8.0f, -16.0f, 0.0f, 10.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)-0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171481_(-6.0f, -0.0f, -4.0f, 8.0f, 28.0f, 8.0f), PartPose.m_171419_((float)-11.0f, (float)-11.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(84, 0).m_171481_(-2.0f, -0.0f, -4.0f, 8.0f, 28.0f, 8.0f), PartPose.m_171419_((float)11.0f, (float)-11.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(82, 36).m_171481_(-3.0f, 0.0f, -3.0f, 6.0f, 13.0f, 6.0f), PartPose.m_171419_((float)5.0f, (float)11.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(58, 36).m_171481_(-3.0f, 0.0f, -3.0f, 6.0f, 13.0f, 6.0f), PartPose.m_171419_((float)-5.0f, (float)11.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.head.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.left_arm.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.right_arm.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.ears.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.left_leg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.right_leg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }

    public void setupAnim(WardenEntity p_102618_, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.ears.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = -((float)Math.cos(limbSwing * 0.6662f) * 1.4f * limbSwingAmount / 4.0f + (float)Math.cos(ageInTicks / 20.0f) / 20.0f);
        this.ears.f_104203_ = -((float)Math.cos(limbSwing * 0.6662f) * 1.4f * limbSwingAmount / 4.0f + (float)Math.cos(ageInTicks / 20.0f) / 20.0f);
        this.right_leg.f_104203_ = (float)Math.cos(limbSwing * 0.6662f) * 1.4f * limbSwingAmount;
        this.left_leg.f_104203_ = (float)Math.cos(limbSwing * 0.6662f + (float)Math.PI) * 1.4f * limbSwingAmount;
        this.body.f_104203_ = (float)Math.cos(limbSwing * 0.6662f) * 1.4f * limbSwingAmount / 4.0f + (float)Math.cos(ageInTicks / 20.0f) / 20.0f;
        this.right_arm.f_104203_ = -((float)Math.cos(limbSwing * 0.6662f) * 1.4f * limbSwingAmount / 3.0f + (float)Math.cos(ageInTicks / 20.0f) / 20.0f);
        this.left_arm.f_104203_ = -((float)Math.cos(limbSwing * 0.6662f) * 1.4f * limbSwingAmount / 3.0f + (float)Math.cos(ageInTicks / 20.0f) / 20.0f);
    }

    public void prepareMobModel(WardenEntity p_102614_, float p_102615_, float p_102616_, float p_102617_) {
        int i = p_102614_.getAttackAnimationTick();
        if (i > 0) {
            this.right_arm.f_104203_ = -2.0f + 1.5f * Mth.m_14156_((float)((float)i - p_102617_), (float)10.0f);
            this.left_arm.f_104203_ = -2.0f + 1.5f * Mth.m_14156_((float)((float)i - p_102617_), (float)10.0f);
        }
    }
}

