/*
 * Decompiled with CFR 0.152.
 */
package com.zainjx.the_wild_update.world.gen;

import com.zainjx.the_wild_update.entity.ModEntityTypes;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class ModEntityGeneration {
    public static void onEntitySpawn(BiomeLoadingEvent event) {
        ModEntityGeneration.addEntityToSpecificBiomes(event, (EntityType)ModEntityTypes.FROG.get(), 40, 4, 8, Biomes.f_48207_, Biomes.f_48181_);
        ModEntityGeneration.addEntityToSpecificBiomes(event, (EntityType)ModEntityTypes.TADPOLE.get(), 70, 6, 19, Biomes.f_48207_, Biomes.f_48181_);
    }

    private static void addEntityToAllBiomesExceptThese(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount, ResourceKey<Biome> ... biomes) {
        boolean isBiomeSelected = Arrays.stream(biomes).map(ResourceKey::m_135782_).map(Object::toString).anyMatch(s -> s.equals(event.getName().toString()));
        if (!isBiomeSelected) {
            ModEntityGeneration.addEntityToAllBiomes(event.getSpawns(), type, weight, minCount, maxCount);
        }
    }

    private static void addEntityToSpecificBiomes(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount, ResourceKey<Biome> ... biomes) {
        boolean isBiomeSelected = Arrays.stream(biomes).map(ResourceKey::m_135782_).map(Object::toString).anyMatch(s -> s.equals(event.getName().toString()));
        if (isBiomeSelected) {
            ModEntityGeneration.addEntityToAllBiomes(event.getSpawns(), type, weight, minCount, maxCount);
        }
    }

    private static void addEntityToAllBiomes(MobSpawnInfoBuilder spawns, EntityType<?> type, int weight, int minCount, int maxCount) {
        List base = spawns.getSpawner(type.m_20674_());
        base.add(new MobSpawnSettings.SpawnerData(type, weight, minCount, maxCount));
    }
}

