/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.client.events;

import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.sounds.ElytraOnPlayerSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderArmEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrscauthd.beyond_earth.client.events.forge.RenderHandItemEvent;
import net.mrscauthd.beyond_earth.client.events.forge.RenderViewEvent;
import net.mrscauthd.beyond_earth.client.events.forge.SetupLivingBipedAnimEvent;
import net.mrscauthd.beyond_earth.client.sounds.SpaceSoundSystem;
import net.mrscauthd.beyond_earth.client.sounds.TickableJetSuitFlySound;
import net.mrscauthd.beyond_earth.client.sounds.TickableSpaceSoundSystem;
import net.mrscauthd.beyond_earth.client.util.ClientMethods;
import net.mrscauthd.beyond_earth.common.entities.IRocketEntity;
import net.mrscauthd.beyond_earth.common.entities.LanderEntity;
import net.mrscauthd.beyond_earth.common.util.Methods;

@Mod.EventBusSubscriber(modid="beyond_earth", value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void playSounds(PlaySoundEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        SoundInstance instance = event.getSound();
        if (instance == null || player == null) {
            return;
        }
        SoundSource source = instance.m_8070_();
        if (Methods.isLivingInJetSuit((LivingEntity)player) && instance instanceof ElytraOnPlayerSoundInstance) {
            mc.m_91106_().m_120367_((SoundInstance)new TickableJetSuitFlySound(player));
        }
        if (ClientMethods.isNotGuiSoundSource(source) && Methods.isSpaceLevelWithoutOxygen(player.f_19853_)) {
            if (instance instanceof TickableSoundInstance) {
                event.setSound((SoundInstance)new TickableSpaceSoundSystem((TickableSoundInstance)instance));
            } else {
                event.setSound((SoundInstance)new SpaceSoundSystem(event.getSound()));
            }
        }
    }

    @SubscribeEvent
    public static void itemRender(RenderHandItemEvent.Pre event) {
        if (!(event.getLivingEntity() instanceof Player)) {
            return;
        }
        LivingEntity entity = event.getLivingEntity();
        if (Methods.isRocket(entity.m_20202_())) {
            event.setCanceled(true);
        }
        if (event.getHandSide() == HumanoidArm.LEFT) {
            ItemStack itemStack = entity.m_21205_();
            if (Methods.isVehicleItem(itemStack)) {
                event.setCanceled(true);
            }
        } else {
            ItemStack itemStack = entity.m_21206_();
            if (Methods.isVehicleItem(itemStack)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void cameraPos(ViewportEvent.ComputeCameraAngles event) {
        CameraType cameraType;
        Entity riddingEntity = event.getCamera().m_90592_().m_20202_();
        if ((Methods.isRocket(riddingEntity) || riddingEntity instanceof LanderEntity) && ((cameraType = Minecraft.m_91087_().f_91066_.m_92176_()).equals((Object)CameraType.THIRD_PERSON_FRONT) || cameraType.equals((Object)CameraType.THIRD_PERSON_BACK))) {
            event.getCamera().m_90568_(-event.getCamera().m_90566_(12.0), 0.0, 0.0);
        }
    }

    @SubscribeEvent
    public static void bobViewer(RenderViewEvent event) {
        CameraType cameraType;
        Minecraft mc = Minecraft.m_91087_();
        Entity riddingEntity = mc.f_91075_.m_20202_();
        if (Methods.isRocket(riddingEntity) && ((cameraType = mc.f_91066_.m_92176_()).equals((Object)CameraType.THIRD_PERSON_FRONT) || cameraType.equals((Object)CameraType.THIRD_PERSON_BACK)) && ((Boolean)riddingEntity.m_20088_().m_135370_(IRocketEntity.ROCKET_START)).booleanValue()) {
            ClientMethods.setBobView(event.getPoseStack(), event.getTick());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderPlayerArm(RenderArmEvent event) {
        AbstractClientPlayer player = event.getPlayer();
        PlayerRenderer renderer = (PlayerRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)player);
        PlayerModel playerModel = (PlayerModel)renderer.m_7200_();
        ItemStack itemStack1 = player.m_21206_();
        ItemStack itemStack2 = player.m_21205_();
        if (Methods.isVehicleItem(itemStack1) || Methods.isVehicleItem(itemStack2)) {
            event.setCanceled(true);
            return;
        }
        event.setCanceled(ClientMethods.renderISpaceArmorArm(player, (PlayerModel<AbstractClientPlayer>)playerModel, renderer, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), event.getArm()));
    }

    @SubscribeEvent
    public static void render(RenderPlayerEvent event) {
        if (event.getEntity().m_20202_() instanceof LanderEntity) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void setupPlayerAngles(SetupLivingBipedAnimEvent.Post event) {
        LivingEntity livingEntity = event.getLivingEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        HumanoidModel<?> model = event.getModel();
        if (Methods.isRocket(player.m_20202_())) {
            model.f_102811_.f_104203_ = -0.07f;
            model.f_102812_.f_104203_ = -0.07f;
            model.f_102813_.f_104203_ = 0.0f;
            model.f_102814_.f_104203_ = 0.0f;
            model.f_102813_.f_104204_ = 0.0f;
            model.f_102814_.f_104204_ = 0.0f;
            model.f_102813_.f_104205_ = 0.0f;
            model.f_102814_.f_104205_ = 0.0f;
        } else {
            ItemStack itemStack1 = player.m_21205_();
            ItemStack itemStack2 = player.m_21206_();
            if (Methods.isVehicleItem(itemStack1) || Methods.isVehicleItem(itemStack2)) {
                model.f_102811_.f_104203_ = 10.0f;
                model.f_102812_.f_104203_ = 10.0f;
                model.f_102811_.f_104204_ = 0.0f;
                model.f_102812_.f_104204_ = 0.0f;
                model.f_102811_.f_104205_ = 0.0f;
                model.f_102812_.f_104205_ = 0.0f;
            }
        }
    }
}

