/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.client.registries;

import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrscauthd.beyond_earth.client.renderers.sky.OrbitSky;
import net.mrscauthd.beyond_earth.client.renderers.sky.PlanetSky;
import net.mrscauthd.beyond_earth.common.data.PlanetData;
import net.mrscauthd.beyond_earth.common.util.Planets;

@Mod.EventBusSubscriber(modid="beyond_earth", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class SkyRendererRegistry {
    @SubscribeEvent
    public static void register(RegisterDimensionSpecialEffectsEvent event) {
        PlanetData.loadOrGenerateDefaults();
        Planets.PLANETS_BY_PLANET.forEach((key, planet) -> {
            float clouds = planet.hasClouds ? 192.0f : Float.NaN;
            event.register(key.m_135782_(), (DimensionSpecialEffects)new PlanetSky(clouds, (Planets.Planet)planet));
        });
        Planets.PLANETS_BY_ORBIT.forEach((key, planet) -> event.register(key.m_135782_(), (DimensionSpecialEffects)new OrbitSky((Planets.Planet)planet)));
    }
}

