/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.client.renderers.entities.flag;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrscauthd.beyond_earth.client.renderers.entities.flag.FlagHeadModel;
import net.mrscauthd.beyond_earth.common.blocks.FlagBlock;
import net.mrscauthd.beyond_earth.common.blocks.entities.FlagBlockEntity;

@OnlyIn(value=Dist.CLIENT)
public class FlagHeadRenderer
implements BlockEntityRenderer<FlagBlockEntity> {
    private static final Map<FlagBlock.ISkullType, FlagHeadModel> MODELS = (Map)Util.m_137469_((Object)Maps.newHashMap(), p_209262_0_ -> {
        Minecraft minecraft = Minecraft.m_91087_();
        Map<String, ModelPart> map = Map.of("head", new FlagHeadModel((ModelPart)minecraft.m_167973_().m_171103_((ModelLayerLocation)FlagHeadModel.LAYER_LOCATION)).head);
        ModelPart modelPart = new ModelPart(Collections.emptyList(), map);
        FlagHeadModel genericheadmodel = new FlagHeadModel(modelPart);
        p_209262_0_.put(FlagBlock.Types.PLAYER, genericheadmodel);
    });
    private static final Map<FlagBlock.ISkullType, ResourceLocation> SKINS = (Map)Util.m_137469_((Object)Maps.newHashMap(), p_209263_0_ -> p_209263_0_.put(FlagBlock.Types.PLAYER, DefaultPlayerSkin.m_118626_()));

    public FlagHeadRenderer(BlockEntityRendererProvider.Context context) {
    }

    public boolean shouldRenderOffScreen(FlagBlockEntity p_112306_) {
        return true;
    }

    public int m_142163_() {
        return 256;
    }

    public boolean shouldRender(FlagBlockEntity p_173568_, Vec3 p_173569_) {
        return Vec3.m_82512_((Vec3i)p_173568_.m_58899_()).m_82542_(1.0, 0.0, 1.0).m_82509_((Position)p_173569_.m_82542_(1.0, 0.0, 1.0), (double)this.m_142163_());
    }

    public void render(FlagBlockEntity tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tileEntityIn.m_58900_().m_61143_(FlagBlock.HALF) == DoubleBlockHalf.UPPER) {
            BlockState blockstate = tileEntityIn.m_58900_();
            boolean flag = blockstate.m_60734_() instanceof FlagBlock;
            Direction direction = flag ? (Direction)blockstate.m_61143_((Property)FlagBlock.FACING) : null;
            FlagHeadRenderer.render(direction, ((Direction)blockstate.m_61143_((Property)FlagBlock.FACING)).m_122435_(), ((FlagBlock)blockstate.m_60734_()).getSkullType(), tileEntityIn.getPlayerProfile(), 0.0f, matrixStackIn, bufferIn, combinedLightIn);
        }
    }

    public static void render(@Nullable Direction directionIn, float p_228879_1_, FlagBlock.ISkullType skullType, @Nullable GameProfile gameProfileIn, float animationProgress, PoseStack matrixStackIn, MultiBufferSource buffer, int combinedLight) {
        FlagHeadModel genericheadmodel = MODELS.get(skullType);
        matrixStackIn.m_85836_();
        if (directionIn.m_122416_() == 0) {
            matrixStackIn.m_85837_(1.0, 0.031, 0.25);
        } else if (directionIn.m_122416_() == 1) {
            matrixStackIn.m_85837_(0.75, 0.031, 1.0);
        } else if (directionIn.m_122416_() == 2) {
            matrixStackIn.m_85837_(0.0, 0.031, 0.75);
        } else if (directionIn.m_122416_() == 3) {
            matrixStackIn.m_85837_(0.25, 0.031, 0.0);
        }
        matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        VertexConsumer ivertexbuilder = buffer.m_6299_(FlagHeadRenderer.getRenderType(skullType, gameProfileIn));
        genericheadmodel.m_6251_(animationProgress, p_228879_1_, 0.0f);
        genericheadmodel.m_7695_(matrixStackIn, ivertexbuilder, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        Minecraft.m_91087_().m_91269_().m_110104_().m_109911_();
        matrixStackIn.m_85849_();
    }

    private static RenderType getRenderType(FlagBlock.ISkullType skullType, @Nullable GameProfile gameProfileIn) {
        ResourceLocation resourcelocation = SKINS.get(skullType);
        if (skullType == FlagBlock.Types.PLAYER && gameProfileIn != null) {
            Minecraft minecraft = Minecraft.m_91087_();
            Map map = minecraft.m_91109_().m_118815_(gameProfileIn);
            return map.containsKey(MinecraftProfileTexture.Type.SKIN) ? RenderType.m_110473_((ResourceLocation)minecraft.m_91109_().m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN)) : RenderType.m_110458_((ResourceLocation)DefaultPlayerSkin.m_118627_((UUID)UUIDUtil.m_235875_((GameProfile)gameProfileIn)));
        }
        return RenderType.m_110464_((ResourceLocation)resourcelocation);
    }
}

