/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.client.renderers.entities.mogler;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoglerModel<T extends Mob>
extends AgeableListModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("beyond_earth", "mogler"), "main");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;
    private final ModelPart leg4;

    public MoglerModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.leg1 = root.m_171324_("leg1");
        this.leg2 = root.m_171324_("leg2");
        this.leg3 = root.m_171324_("leg3");
        this.leg4 = root.m_171324_("leg4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -15.0f, -13.0f, 16.0f, 9.0f, 32.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r1 = body.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(85, 30).m_171488_(-9.0f, -20.0f, 12.0f, 18.0f, 9.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = body.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 41).m_171488_(-10.0f, -18.0f, 5.0f, 20.0f, 9.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = body.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(58, 52).m_171488_(-11.0f, -18.0f, 2.0f, 22.0f, 9.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = body.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171488_(-12.0f, -22.0f, -4.0f, 24.0f, 11.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r5 = head.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(0, 66).m_171488_(-10.0f, -26.0f, -3.0f, 20.0f, 11.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.829f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r6 = head.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-7.5f, -8.5f, -1.75f, 15.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-11.5f, (float)-20.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r7 = head.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(62, 75).m_171488_(-9.0f, -8.5f, -1.75f, 18.0f, 13.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-11.5f, (float)-20.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition jaw2 = head.m_171599_("jaw2", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-11.5f, (float)-20.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = jaw2.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(96, 99).m_171488_(5.25f, -1.5f, -0.75f, 5.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5672f));
        PartDefinition jaw1 = head.m_171599_("jaw1", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-11.5f, (float)-20.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r9 = jaw1.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(0, 110).m_171488_(-10.25f, -1.5f, -0.75f, 5.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5672f));
        PartDefinition leg1 = partdefinition.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(64, 99).m_171488_(-3.5f, -3.5f, -4.5f, 7.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-9.5f, (float)14.5f, (float)-6.5f));
        PartDefinition leg2 = partdefinition.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(32, 90).m_171488_(-3.5f, -3.5f, -4.5f, 7.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)9.5f, (float)14.5f, (float)-6.5f));
        PartDefinition leg3 = partdefinition.m_171599_("leg3", CubeListBuilder.m_171558_().m_171514_(0, 88).m_171488_(-3.5f, -3.5f, -4.5f, 7.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)9.5f, (float)14.5f, (float)12.5f));
        PartDefinition leg4 = partdefinition.m_171599_("leg4", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, -3.5f, -4.5f, 7.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-9.5f, (float)14.5f, (float)12.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        int i = ((HoglinBase)entity).m_7575_();
        float f = 1.0f - (float)Mth.m_14040_((int)(10 - 2 * i)) / 10.0f;
        this.head.f_104203_ = Mth.m_14179_((float)f, (float)0.0f, (float)-1.1490659f);
        this.leg1.f_104203_ = Mth.m_14089_((float)limbSwing) * 1.2f * limbSwingAmount;
        this.leg2.f_104203_ = Mth.m_14089_((float)(limbSwing + (float)Math.PI)) * 1.2f * limbSwingAmount;
        this.leg3.f_104203_ = this.leg1.f_104203_;
        this.leg4.f_104203_ = this.leg2.f_104203_;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_85837_(0.0, 1.5, 0.0);
        }
        this.body.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leg1.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leg2.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leg3.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leg4.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.leg1, (Object)this.leg2, (Object)this.leg3, (Object)this.leg4);
    }
}

