/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.client.renderers.sky;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrscauthd.beyond_earth.client.renderers.sky.helper.SkyHelper;
import net.mrscauthd.beyond_earth.client.renderers.sky.helper.StarHelper;
import net.mrscauthd.beyond_earth.common.util.Planets;
import org.apache.commons.lang3.tuple.Triple;

@OnlyIn(value=Dist.CLIENT)
public class OrbitSky
extends DimensionSpecialEffects {
    private final VertexBuffer starBuffer = StarHelper.createStars(0.1f, 6000, 13000, 190, 160, -1);
    private Planets.Planet planet;

    public OrbitSky(Planets.Planet planet) {
        super(Float.NaN, false, DimensionSpecialEffects.SkyType.NONE, false, false);
        this.planet = planet;
    }

    public Vec3 m_5927_(Vec3 p_108878_, float p_108879_) {
        return p_108878_;
    }

    public boolean m_5781_(int p_108874_, int p_108875_) {
        return false;
    }

    public float[] m_7518_(float p_108872_, float p_108873_) {
        return null;
    }

    public boolean renderClouds(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, double camX, double camY, double camZ, Matrix4f projectionMatrix) {
        return true;
    }

    public boolean tickRain(ClientLevel level, int ticks, Camera camera) {
        return true;
    }

    public boolean renderSnowAndRain(ClientLevel level, int ticks, float partialTick, LightTexture lightTexture, double camX, double camY, double camZ) {
        return true;
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        FogType fogtype;
        Minecraft mc = Minecraft.m_91087_();
        Vec3 cameraPos = camera.m_90583_();
        double y = cameraPos.m_7098_();
        setupFog.run();
        if (!isFoggy && (fogtype = camera.m_167685_()) != FogType.POWDER_SNOW && fogtype != FogType.LAVA && !mc.f_91060_.m_234310_(camera)) {
            Vec3 vec3 = mc.f_91073_.m_171660_(mc.f_91063_.m_109153_().m_90583_(), partialTick);
            float r = (float)vec3.f_82479_;
            float g = (float)vec3.f_82480_;
            float b = (float)vec3.f_82481_;
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            ShaderInstance shaderInstance = RenderSystem.m_157196_();
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            float dayTime = level.m_46942_(partialTick);
            float dayAngle = dayTime * 360.0f % 360.0f;
            FogRenderer.m_109036_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
            SkyHelper.drawSky(mc, matrix4f, projectionMatrix, shaderInstance);
            matrix4f = SkyHelper.setMatrixRot(poseStack, (Triple<Quaternion, Quaternion, Quaternion>)Triple.of((Object)Vector3f.f_122225_.m_122240_(-90.0f), (Object)Vector3f.f_122223_.m_122240_(dayTime), null));
            RenderSystem.m_157429_((float)0.8f, (float)0.8f, (float)0.8f, (float)0.8f);
            SkyHelper.drawStars(this.starBuffer, matrix4f, projectionMatrix, GameRenderer.m_172811_(), setupFog, true);
            matrix4f = SkyHelper.setMatrixRot(poseStack, (Triple<Quaternion, Quaternion, Quaternion>)Triple.of((Object)Vector3f.f_122225_.m_122240_(-90.0f), (Object)Vector3f.f_122223_.m_122240_(dayTime), null));
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            SkyHelper.drawPlanet(SkyHelper.WHITE_SUN, new Vec3(255.0, 255.0, 255.0), bufferBuilder, matrix4f, 30.0f, 100.0f, true);
            this.planet = Planets.getLocationForOrbit((Level)level);
            if (this.planet != null) {
                if (this.planet._parent != null) {
                    boolean inner = true;
                    for (Planets.Planet p : this.planet._parent.children) {
                        if (p == this.planet) {
                            inner = false;
                            continue;
                        }
                        float distance = (float)(inner ? this.planet.orbitRadius / p.orbitRadius : p.orbitRadius / this.planet.orbitRadius);
                        float phase = p.orbitPhase - this.planet.orbitPhase;
                        float dAngle = 90.0f * Mth.m_14031_((float)phase) / distance;
                        float angle = dayAngle + (inner ? dAngle : phase);
                        matrix4f = SkyHelper.setMatrixRot(poseStack, (Triple<Quaternion, Quaternion, Quaternion>)Triple.of((Object)Vector3f.f_122225_.m_122240_(-90.0f), (Object)Vector3f.f_122223_.m_122240_(angle), null));
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        SkyHelper.drawPlanetWithLight(p.texture, new Vec3(232.0, 219.0, 176.0), bufferBuilder, matrix4f, 3.0f, 12.0f, 100.0f * distance, false);
                    }
                }
                for (Planets.Planet p : this.planet.moons) {
                    p.orbitPhase = Planets.getRotation(p, dayTime, 1.0f);
                    matrix4f = SkyHelper.setMatrixRot(poseStack, (Triple<Quaternion, Quaternion, Quaternion>)Triple.of((Object)Vector3f.f_122225_.m_122240_(-90.0f), (Object)Vector3f.f_122223_.m_122240_(p.orbitPhase), (Object)Vector3f.f_122227_.m_122240_(1.0f)));
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    SkyHelper.drawPlanetWithLight(p.texture, new Vec3(232.0, 219.0, 176.0), bufferBuilder, matrix4f, 3.0f, 12.0f, 100.0f, false);
                }
            }
            matrix4f = SkyHelper.setMatrixRot(poseStack, (Triple<Quaternion, Quaternion, Quaternion>)Triple.of((Object)Vector3f.f_122223_.m_122240_(180.0f), null, null));
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float posScale = -3000.0f + (float)y * 6.0f;
            float scale = 50.0f * (0.2f - posScale / 10000.0f);
            float yScale = Math.max(scale, 4.0f);
            SkyHelper.drawPlanetWithLight(this.planet.texture, new Vec3(0.0, 177.0, 242.0), bufferBuilder, matrix4f, yScale, yScale * 3.0f, 30.0f, false);
            SkyHelper.setupShaderColor(mc, r, g, b);
            RenderSystem.m_69458_((boolean)true);
        }
        return true;
    }
}

