/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.client.renderers.sky.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Random;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StarHelper {
    public static VertexBuffer createStars(float scale, int amountFast, int amountFancy, int r, int g, int b) {
        return StarHelper.createStars(scale, false, amountFast, amountFancy, true, r, g, b);
    }

    public static VertexBuffer createStars(float scale, int r, int g, int b) {
        return StarHelper.createStars(scale, true, 0, 0, true, r, g, b);
    }

    public static VertexBuffer createStars(float scale, int amountFast, int amountFancy) {
        return StarHelper.createStars(scale, false, amountFast, amountFancy, false, 0, 0, 0);
    }

    public static VertexBuffer createStars(float scale) {
        return StarHelper.createStars(scale, true, 0, 0, false, 0, 0, 0);
    }

    private static VertexBuffer createStars(float scale, boolean amountDefault, int amountFast, int amountFancy, boolean colorSystem, int r, int g, int b) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(colorSystem ? GameRenderer::m_172811_ : GameRenderer::m_172808_);
        VertexBuffer vertexBuffer = new VertexBuffer();
        BufferBuilder.RenderedBuffer renderedBuffer = StarHelper.drawStars(bufferbuilder, scale, amountDefault, amountFast, amountFancy, colorSystem, r, g, b);
        vertexBuffer.m_85921_();
        vertexBuffer.m_231221_(renderedBuffer);
        VertexBuffer.m_85931_();
        return vertexBuffer;
    }

    private static BufferBuilder.RenderedBuffer drawStars(BufferBuilder p_109555_, float scale, boolean amountDefault, int amountFast, int amountFancy, boolean colorSystem, int r, int g, int b) {
        Random random = new Random(10842L);
        p_109555_.m_166779_(VertexFormat.Mode.QUADS, colorSystem ? DefaultVertexFormat.f_85815_ : DefaultVertexFormat.f_85814_);
        GraphicsStatus graphicsMode = (GraphicsStatus)Minecraft.m_91087_().f_91066_.m_232060_().m_231551_();
        int stars = 1500;
        if (!amountDefault) {
            stars = graphicsMode == GraphicsStatus.FANCY || graphicsMode == GraphicsStatus.FABULOUS ? amountFancy : amountFast;
        }
        for (int i = 0; i < stars; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = scale + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                if (colorSystem) {
                    int color1 = r == -1 ? i : r;
                    int color2 = g == -1 ? i : g;
                    int color3 = b == -1 ? i : b;
                    p_109555_.m_5483_(d5 + d25, d6 + d23, d7 + d26).m_6122_(color1, color2, color3, 170).m_5752_();
                    continue;
                }
                p_109555_.m_5483_(d5 + d25, d6 + d23, d7 + d26).m_5752_();
            }
        }
        return p_109555_.m_231175_();
    }
}

