/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.client.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.mrscauthd.beyond_earth.client.screens.helper.ScreenHelper;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.GaugeTextHelper;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.IGaugeValue;
import net.mrscauthd.beyond_earth.common.menus.RoverMenu;
import net.mrscauthd.beyond_earth.common.registries.ItemsRegistry;

@OnlyIn(value=Dist.CLIENT)
public class RoverScreen
extends AbstractContainerScreen<RoverMenu.GuiContainer> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("beyond_earth", "textures/gui/rover.png");
    public static final ResourceLocation FLUID_TANK_OVERLAY = new ResourceLocation("beyond_earth", "textures/gui/util/fluid_tank_overlay.png");

    public RoverScreen(RoverMenu.GuiContainer container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.f_97726_ = 177;
        this.f_97727_ = 181;
        this.f_97731_ = this.f_97727_ - 93;
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(ms);
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.m_7025_(ms, mouseX, mouseY);
        int fx = 50;
        int fy = 25;
        if (ScreenHelper.isInArea(mouseX, mouseY, this.f_97735_ + fx, this.f_97736_ + fy, 15.0f, 49.0f)) {
            ArrayList<MutableComponent> toolTip = new ArrayList<MutableComponent>();
            toolTip.add(GaugeTextHelper.buildFuelStorageTooltip(this.getFuel(), ChatFormatting.WHITE));
            this.m_96597_(ms, toolTip, mouseX, mouseY);
        }
    }

    protected void m_7286_(PoseStack ms, float p_97788_, int p_97789_, int p_97790_) {
        ScreenHelper.drawTexture(ms, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_, TEXTURE, false);
        int fx = 50;
        int fy = 25;
        IGaugeValue fuel = this.getFuel();
        FluidStack fluidStack = new FluidStack(((BucketItem)ItemsRegistry.FUEL_BUCKET.get()).getFluid(), fuel.getAmount());
        ScreenHelper.renderFluid.drawFluidVertical(ms, fluidStack, this.f_97735_ + fx + 1, this.f_97736_ + fy + 1, 12, 46, fuel.getCapacity());
        ScreenHelper.drawTexture(ms, this.f_97735_ + fx, this.f_97736_ + fy, 14, 48, FLUID_TANK_OVERLAY, false);
    }

    protected void m_7027_(PoseStack ms, int p_97809_, int p_97810_) {
        this.f_96547_.m_92883_(ms, this.f_96539_.getString(), (float)(this.f_97726_ / 2) - 14.0f, (float)this.f_97729_, 0x404040);
        this.f_96547_.m_92889_(ms, this.f_169604_, (float)this.f_97730_, (float)this.f_97731_, 0x404040);
    }

    public IGaugeValue getFuel() {
        return ((RoverMenu.GuiContainer)this.f_97732_).rover.getFuelGauge();
    }
}

