/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.client.screens.buttons;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrscauthd.beyond_earth.client.screens.buttons.TexturedButton;
import net.mrscauthd.beyond_earth.client.screens.planetselection.PlanetSelectionScreen;

@OnlyIn(value=Dist.CLIENT)
public class ModifiedButton
extends TexturedButton {
    private final TexturedButton.ColorTypes colorType;
    private final boolean rocketCondition;
    private final ButtonTypes type;
    private final List<String> list;
    public int row;
    public Predicate<Integer> isVisible = i -> false;

    public ModifiedButton(int xIn, int yIn, int row, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, boolean rocketCondition, ButtonTypes type, List<String> list, ResourceLocation buttonTexture, TexturedButton.ColorTypes colorType, int textureWidth, int textureHeight, Button.OnPress onPressIn, Component title) {
        this(xIn, yIn, row, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, rocketCondition, type, list, buttonTexture, colorType, textureWidth, textureHeight, onPressIn, Button.f_93716_, title);
    }

    public ModifiedButton(int p_i244513_1_, int p_i244513_2_, int row, int p_i244513_3_, int p_i244513_4_, int xTexStart, int yTexStart, int p_i244513_7_, boolean rocketCondition, ButtonTypes type, List<String> list, ResourceLocation buttonTexture, TexturedButton.ColorTypes colorType, int textureWidth, int textureHeight, Button.OnPress p_i244513_11_, Button.OnTooltip p_i244513_12_, Component p_i244513_13_) {
        super(p_i244513_1_, p_i244513_2_, p_i244513_3_, p_i244513_4_, p_i244513_13_, p_i244513_11_, p_i244513_12_);
        this.tex(buttonTexture, buttonTexture);
        this.size(textureWidth, textureHeight);
        this.setUVs(xTexStart, yTexStart);
        this.setYShift(p_i244513_7_);
        this.colorType = colorType;
        this.rocketCondition = rocketCondition;
        this.type = type;
        this.list = list;
        this.row = row;
    }

    public void setPosition(int xIn, int yIn) {
        this.f_93620_ = xIn;
        this.f_93621_ = yIn;
    }

    @Override
    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        super.m_6303_(poseStack, mouseX, mouseY, partialTicks);
        if (mc.f_91080_ instanceof PlanetSelectionScreen) {
            this.milkyWayCategoryManager(mc, poseStack, mouseX, mouseY);
            this.solarSystemToolTip(mc, poseStack, mouseX, mouseY);
            this.planetToolTip(mc, poseStack, mouseX, mouseY);
            this.spaceStationToolTip(mc, poseStack, mouseX, mouseY);
        }
    }

    private void milkyWayCategoryManager(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (this.f_93622_ && this.type == ButtonTypes.MILKY_WAY_CATEGORY) {
            Screen screen = minecraft.f_91080_;
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237113_((String)("\u00a79" + PlanetSelectionScreen.CATEGORY_TEXT.getString() + ": \u00a7b" + this.list.get(0))));
            list.add(Component.m_237113_((String)("\u00a79" + PlanetSelectionScreen.TYPE_TEXT.getString() + ": \u00a73" + PlanetSelectionScreen.SOLAR_SYSTEM_TEXT.getString())));
            screen.m_96597_(poseStack, list, mouseX, mouseY);
        }
    }

    private void solarSystemToolTip(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (this.f_93622_ && this.type == ButtonTypes.SOLAR_SYSTEM_CATEGORY) {
            Screen screen = minecraft.f_91080_;
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            String condition = this.rocketCondition ? "a" : "c";
            list.add(Component.m_237113_((String)("\u00a79" + PlanetSelectionScreen.CATEGORY_TEXT.getString() + ": \u00a7" + condition + this.list.get(0))));
            list.add(Component.m_237113_((String)("\u00a79" + PlanetSelectionScreen.PROVIDED_TEXT.getString() + ": \u00a7b" + this.list.get(1))));
            screen.m_96597_(poseStack, list, mouseX, mouseY);
        }
    }

    private void planetToolTip(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (this.f_93622_ && this.type == ButtonTypes.PLANET_CATEGORY) {
            Screen screen = minecraft.f_91080_;
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237113_((String)("\u00a79" + PlanetSelectionScreen.TYPE_TEXT.getString() + ": \u00a73" + this.list.get(0))));
            list.add(Component.m_237113_((String)("\u00a79" + PlanetSelectionScreen.GRAVITY_TEXT.getString() + ": \u00a73" + this.list.get(1))));
            list.add(Component.m_237113_((String)("\u00a79" + PlanetSelectionScreen.OXYGEN_TEXT.getString() + ": \u00a7" + this.list.get(2))));
            list.add(Component.m_237113_((String)("\u00a79" + PlanetSelectionScreen.TEMPERATURE_TEXT.getString() + ": \u00a7" + this.list.get(3))));
            screen.m_96597_(poseStack, list, mouseX, mouseY);
        }
    }

    private void spaceStationToolTip(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (this.f_93622_ && this.type == ButtonTypes.PLANET_SPACE_STATION_CATEGORY) {
            PlanetSelectionScreen screen = (PlanetSelectionScreen)minecraft.f_91080_;
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237113_((String)("\u00a79" + PlanetSelectionScreen.ITEM_REQUIREMENT_TEXT.getString())));
            list.add(Component.m_237113_((String)"\u00a7c----------------"));
            list.add(Component.m_237113_((String)("\u00a79" + PlanetSelectionScreen.TYPE_TEXT.getString() + ": \u00a73" + this.list.get(0))));
            list.add(Component.m_237113_((String)("\u00a79" + PlanetSelectionScreen.GRAVITY_TEXT.getString() + ": \u00a73" + this.list.get(1))));
            list.add(Component.m_237113_((String)("\u00a79" + PlanetSelectionScreen.OXYGEN_TEXT.getString() + ": \u00a7" + this.list.get(2))));
            list.add(Component.m_237113_((String)("\u00a79" + PlanetSelectionScreen.TEMPERATURE_TEXT.getString() + ": \u00a7" + this.list.get(3))));
            screen.m_96597_(poseStack, list, mouseX, mouseY);
        }
    }

    @Override
    protected Vec3 getTypeColor() {
        if (this.f_93622_) {
            return TexturedButton.ColorTypes.WHITE.getColor();
        }
        if (this.type == ButtonTypes.SOLAR_SYSTEM_CATEGORY ? !this.rocketCondition : this.type == ButtonTypes.PLANET_SPACE_STATION_CATEGORY) {
            return TexturedButton.ColorTypes.RED.getColor();
        }
        return this.colorType.getColor();
    }

    public static enum ButtonTypes {
        MILKY_WAY_CATEGORY,
        SOLAR_SYSTEM_CATEGORY,
        PLANET_CATEGORY,
        PLANET_SPACE_STATION_CATEGORY;

    }
}

