/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.client.screens.planetselection;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.mrscauthd.beyond_earth.client.events.forge.PlanetSelectionScreenBackgroundRenderEvent;
import net.mrscauthd.beyond_earth.client.events.forge.PlanetSelectionScreenButtonVisibilityEvent;
import net.mrscauthd.beyond_earth.client.events.forge.PlanetSelectionScreenInitEvent;
import net.mrscauthd.beyond_earth.client.events.forge.PlanetSelectionScreenRenderEvent;
import net.mrscauthd.beyond_earth.client.screens.buttons.ModifiedButton;
import net.mrscauthd.beyond_earth.client.screens.buttons.TexturedButton;
import net.mrscauthd.beyond_earth.client.screens.helper.ScreenHelper;
import net.mrscauthd.beyond_earth.client.screens.planetselection.helper.CategoryHelper;
import net.mrscauthd.beyond_earth.client.screens.planetselection.helper.PlanetSelectionScreenHelper;
import net.mrscauthd.beyond_earth.common.menus.planetselection.PlanetSelectionMenu;
import net.mrscauthd.beyond_earth.common.registries.NetworkRegistry;
import net.mrscauthd.beyond_earth.common.util.Planets;

@OnlyIn(value=Dist.CLIENT)
public class PlanetSelectionScreen
extends Screen
implements MenuAccess<PlanetSelectionMenu.GuiContainer> {
    public static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("beyond_earth", "textures/gui/planet_selection.png");
    public static final ResourceLocation SCROLLER_TEXTURE = new ResourceLocation("beyond_earth", "textures/gui/util/scroller.png");
    public static final ResourceLocation SMALL_BUTTON_TEXTURE = new ResourceLocation("beyond_earth", "textures/gui/util/buttons/small_button.png");
    public static final ResourceLocation BUTTON_TEXTURE = new ResourceLocation("beyond_earth", "textures/gui/util/buttons/button.png");
    public static final ResourceLocation LARGE_BUTTON_TEXTURE = new ResourceLocation("beyond_earth", "textures/gui/util/buttons/large_button.png");
    public static final ResourceLocation MILKY_WAY_TEXTURE = new ResourceLocation("beyond_earth", "textures/gui/util/milky_way.png");
    public static final ResourceLocation SMALL_MENU_LIST = new ResourceLocation("beyond_earth", "textures/gui/util/planet_menu.png");
    public static final ResourceLocation LARGE_MENU_TEXTURE = new ResourceLocation("beyond_earth", "textures/gui/util/large_planet_menu.png");
    public static final Component CATALOG_TEXT = PlanetSelectionScreenHelper.tl("catalog");
    public static final Component BACK_TEXT = PlanetSelectionScreenHelper.tl("back");
    public static final Component SOLAR_SYSTEM_TEXT = PlanetSelectionScreenHelper.tl("solar_system");
    public static final Component PLANET_TEXT = PlanetSelectionScreenHelper.tl("planet");
    public static final Component MOON_TEXT = PlanetSelectionScreenHelper.tl("moon");
    public static final Component ORBIT_TEXT = PlanetSelectionScreenHelper.tl("orbit");
    public static final Component NO_GRAVITY_TEXT = PlanetSelectionScreenHelper.tl("no_gravity");
    public static final Component SPACE_STATION_TEXT = PlanetSelectionScreenHelper.tl("space_station");
    public static final Component CATEGORY_TEXT = PlanetSelectionScreenHelper.tl("category");
    public static final Component PROVIDED_TEXT = PlanetSelectionScreenHelper.tl("provided");
    public static final Component TYPE_TEXT = PlanetSelectionScreenHelper.tl("type");
    public static final Component GRAVITY_TEXT = PlanetSelectionScreenHelper.tl("gravity");
    public static final Component OXYGEN_TEXT = PlanetSelectionScreenHelper.tl("oxygen");
    public static final Component TEMPERATURE_TEXT = PlanetSelectionScreenHelper.tl("temperature");
    public static final Component OXYGEN_TRUE_TEXT = PlanetSelectionScreenHelper.tl("oxygen.true");
    public static final Component OXYGEN_FALSE_TEXT = PlanetSelectionScreenHelper.tl("oxygen.false");
    public static final Component ITEM_REQUIREMENT_TEXT = PlanetSelectionScreenHelper.tl("item_requirement");
    public static final Component ROCKET_TIER_1_TEXT = Component.m_237115_((String)"entity.beyond_earth.rocket_t1");
    public static final Component ROCKET_TIER_2_TEXT = Component.m_237115_((String)"entity.beyond_earth.rocket_t2");
    public static final Component ROCKET_TIER_3_TEXT = Component.m_237115_((String)"entity.beyond_earth.rocket_t3");
    public static final Component ROCKET_TIER_4_TEXT = Component.m_237115_((String)"entity.beyond_earth.rocket_t4");
    public static final float MOON_ORBIT_SPEED = 2.5f;
    public static final float PLANET_ORBIT_SPEED = 2.5f;
    private final PlanetSelectionMenu.GuiContainer menu;
    public CategoryHelper category;
    public CategoryHelper starIndex = new CategoryHelper();
    public List<ModifiedButton> visibleButtons;
    public float rotationMilkyWay;
    public float planetTimer;
    public ModifiedButton backButton;
    public boolean spaceStationItemList;
    public int scrollIndex;
    public int rowEnd;

    public PlanetSelectionScreen(PlanetSelectionMenu.GuiContainer menu, Inventory inventory, Component p_96550_) {
        super(p_96550_);
        this.menu = menu;
        this.starIndex.set(0);
    }

    public PlanetSelectionMenu.GuiContainer getMenu() {
        return this.menu;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.renderBg(poseStack, partialTicks, mouseX, mouseY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        if (MinecraftForge.EVENT_BUS.post((Event)new PlanetSelectionScreenRenderEvent.Pre(this, poseStack, partialTicks, mouseX, mouseY))) {
            return;
        }
        this.f_96547_.m_92889_(poseStack, CATALOG_TEXT, 24.0f, (float)(this.f_96544_ / 2 - 71), -1);
        MinecraftForge.EVENT_BUS.post((Event)new PlanetSelectionScreenRenderEvent.Post(this, poseStack, partialTicks, mouseX, mouseY));
    }

    public Planets.StarSystem getStar() {
        return Planets.getStarsList().get(this.starIndex.get());
    }

    protected void renderBg(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        if (MinecraftForge.EVENT_BUS.post((Event)new PlanetSelectionScreenBackgroundRenderEvent.Pre(this, poseStack, partialTicks, mouseX, mouseY))) {
            return;
        }
        ScreenHelper.drawTexture(poseStack, 0, 0, this.f_96543_, this.f_96544_, BACKGROUND_TEXTURE, false);
        ResourceLocation starTexture = this.getStar().texture;
        if (PlanetSelectionScreenHelper.categoryRange(this.category.get(), 1, 7)) {
            ScreenHelper.drawTexture(poseStack, (this.f_96543_ - 15) / 2, (this.f_96544_ - 15) / 2, 15, 15, starTexture, false);
        }
        this.rotationCalculator(partialTicks);
        this.drawRings();
        this.drawPlanets(poseStack);
        if (PlanetSelectionScreenHelper.categoryRange(this.category.get(), 0, 1) || PlanetSelectionScreenHelper.categoryRange(this.category.get(), 6, 6)) {
            ScreenHelper.drawTexture(poseStack, 0, this.f_96544_ / 2 - 88, 105, 177, SMALL_MENU_LIST, true);
            this.drawScroller(poseStack, 92);
        }
        if (PlanetSelectionScreenHelper.categoryRange(this.category.get(), 2, 5) || PlanetSelectionScreenHelper.categoryRange(this.category.get(), 7, 7)) {
            ScreenHelper.drawTexture(poseStack, 0, this.f_96544_ / 2 - 88, 215, 177, LARGE_MENU_TEXTURE, true);
            this.drawScroller(poseStack, 210);
        }
        MinecraftForge.EVENT_BUS.post((Event)new PlanetSelectionScreenBackgroundRenderEvent.Post(this, poseStack, partialTicks, mouseX, mouseY));
    }

    protected void m_7856_() {
        super.m_7856_();
        if (MinecraftForge.EVENT_BUS.post((Event)new PlanetSelectionScreenInitEvent.Pre(this))) {
            return;
        }
        this.rowEnd = 5;
        this.category = new CategoryHelper();
        this.rotationMilkyWay = 0.0f;
        this.planetTimer = 0.0f;
        this.scrollIndex = 0;
        this.spaceStationItemList = true;
        this.visibleButtons = Lists.newArrayList();
        this.backButton = PlanetSelectionScreenHelper.addBackButton(this, 10, 1, 70, 20, false, BUTTON_TEXTURE, TexturedButton.ColorTypes.BLUE, BACK_TEXT, onPress -> {
            if (this.category.get() == 1) {
                this.category.set(0);
                this.scrollIndex = 0;
                this.updateButtonVisibility();
            } else if (PlanetSelectionScreenHelper.categoryRange(this.category.get(), 2, 5)) {
                this.category.set(1);
                this.scrollIndex = 0;
                this.updateButtonVisibility();
            } else if (this.category.get() == 6) {
                this.category.set(0);
                this.scrollIndex = 0;
                this.updateButtonVisibility();
            } else if (PlanetSelectionScreenHelper.categoryRange(this.category.get(), 7, 7)) {
                this.category.set(6);
                this.scrollIndex = 0;
                this.updateButtonVisibility();
            }
        });
        this.backButton.isVisible = i -> PlanetSelectionScreenHelper.categoryRange(i, 1, 5) || PlanetSelectionScreenHelper.categoryRange(i, 6, 7);
        AtomicInteger intholder = new AtomicInteger(1);
        for (Planets.StarSystem system : Planets.getStarsList()) {
            if (system.description == null) {
                system.description = PlanetSelectionScreenHelper.tl("solar_system_" + system.name);
            }
            ModifiedButton starButton = PlanetSelectionScreenHelper.addCategoryButton(this, this.category, 10, 1, 70, 20, intholder.get(), true, false, ModifiedButton.ButtonTypes.MILKY_WAY_CATEGORY, List.of(system.description.getString()), BUTTON_TEXTURE, TexturedButton.ColorTypes.LIGHT_BLUE, system.description);
            starButton.isVisible = i -> i == 0;
            int starCategory = intholder.getAndIncrement();
            system.planets.forEach(p -> {
                int planetCategory = intholder.getAndIncrement();
                this.addPlanetButtons(null, (Planets.Planet)p, planetCategory, starCategory);
            });
        }
        MinecraftForge.EVENT_BUS.post((Event)new PlanetSelectionScreenInitEvent.Post(this));
        this.updateButtonVisibility();
    }

    public void addPlanetButtons(Planets.Planet parent, Planets.Planet p, int planetCategory, int starCategory) {
        if (p.description == null) {
            p.description = PlanetSelectionScreenHelper.tl(p.name);
        }
        if (parent == null) {
            MutableComponent tierText = Component.m_237115_((String)("entity.beyond_earth.rocket_t" + p.tier));
            ModifiedButton planetCategoryButton = PlanetSelectionScreenHelper.addCategoryButton(this, this.category, 10, 1, 70, 20, planetCategory, this.checkTier(p.tier), false, ModifiedButton.ButtonTypes.SOLAR_SYSTEM_CATEGORY, List.of(p.description.getString(), tierText.getString()), BUTTON_TEXTURE, TexturedButton.ColorTypes.GREEN, p.description);
            planetCategoryButton.isVisible = i -> i == starCategory;
        }
        List<Object> buttonText = Lists.newArrayList();
        buttonText.add(p.description.getString());
        buttonText.add(String.format("%.3f m/s\u00b2", (double)p.g * 9.807));
        buttonText.add(p.hasOxygen ? "a" + OXYGEN_TRUE_TEXT.getString() : "c" + OXYGEN_FALSE_TEXT.getString());
        boolean niceT = p.temperature < 100.0f && p.temperature > -100.0f;
        buttonText.add(niceT ? "a" + p.temperature : "c" + p.temperature);
        ModifiedButton planetButton = PlanetSelectionScreenHelper.addHandlerButton(this, 10, 1, 70, 20, true, false, true, NetworkRegistry.PACKET_HANDLER, PlanetSelectionScreenHelper.getNetworkHandler(p.planetID), ModifiedButton.ButtonTypes.PLANET_CATEGORY, buttonText, BUTTON_TEXTURE, TexturedButton.ColorTypes.LIGHT_BLUE, p.description);
        planetButton.isVisible = i -> i == planetCategory;
        buttonText = List.of(ORBIT_TEXT.getString(), NO_GRAVITY_TEXT.getString(), "c" + OXYGEN_FALSE_TEXT.getString(), "c-270");
        ModifiedButton orbitButton = PlanetSelectionScreenHelper.addHandlerButton(this, 84, 2, 37, 20, true, false, true, NetworkRegistry.PACKET_HANDLER, PlanetSelectionScreenHelper.getNetworkHandler(p.orbitID), ModifiedButton.ButtonTypes.PLANET_CATEGORY, buttonText, SMALL_BUTTON_TEXTURE, TexturedButton.ColorTypes.LIGHT_BLUE, ORBIT_TEXT);
        orbitButton.isVisible = i -> i == planetCategory;
        ModifiedButton stationButton = PlanetSelectionScreenHelper.addHandlerButton(this, 125, 3, 75, 20, this.spaceStationItemList, false, true, NetworkRegistry.PACKET_HANDLER, PlanetSelectionScreenHelper.getNetworkHandler(p.stationID), ModifiedButton.ButtonTypes.PLANET_SPACE_STATION_CATEGORY, buttonText, LARGE_BUTTON_TEXTURE, TexturedButton.ColorTypes.GREEN, SPACE_STATION_TEXT);
        stationButton.isVisible = i -> i == planetCategory;
        p.moons.forEach(p2 -> this.addPlanetButtons(p, (Planets.Planet)p2, planetCategory, starCategory));
    }

    public void m_7379_() {
        this.menu.getPlayer().m_6915_();
        super.m_7379_();
    }

    public boolean m_6913_() {
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6050_(double p_99314_, double p_99315_, double p_99316_) {
        if (this.getVisibleButtons(1).size() > this.rowEnd) {
            if (p_99316_ == 1.0) {
                if (this.scrollIndex != 0) {
                    ++this.scrollIndex;
                    this.updateButtonVisibility();
                    return true;
                }
            } else if (this.scrollIndex != -(this.getVisibleButtons(1).size() - this.rowEnd)) {
                --this.scrollIndex;
                this.updateButtonVisibility();
                return true;
            }
        }
        return false;
    }

    public void updateButtonVisibility() {
        if (MinecraftForge.EVENT_BUS.post((Event)new PlanetSelectionScreenButtonVisibilityEvent.Pre(this))) {
            return;
        }
        this.visibleButtons.clear();
        this.m_6702_().forEach(s -> {
            if (s instanceof ModifiedButton) {
                ModifiedButton button = (ModifiedButton)((Object)s);
                this.visibleButton(button, button.isVisible.test(this.category.get()));
            }
        });
        MinecraftForge.EVENT_BUS.post((Event)new PlanetSelectionScreenButtonVisibilityEvent.Post(this));
    }

    public void rotationCalculator(float partialTicks) {
        this.rotationMilkyWay += partialTicks * 0.4f;
        this.planetTimer += partialTicks;
        for (Planets.StarSystem system : Planets.getStarsList()) {
            float minPeriod = Float.MAX_VALUE;
            for (Planets.Planet planet2 : system.planets) {
                minPeriod = (float)Math.min((double)minPeriod, planet2.orbitT);
            }
            float planetRotationSpeedScale = 2.5f / minPeriod;
            system.planets.forEach(planet -> {
                planet.rotation = Planets.getRotation(planet, this.planetTimer, planetRotationSpeedScale);
                float minMoonPeriod = Float.MAX_VALUE;
                for (Planets.Planet moon : planet.moons) {
                    minMoonPeriod = (float)Math.min((double)minMoonPeriod, moon.orbitT);
                }
                float moonRotationSpeedScale = 2.5f / minMoonPeriod;
                for (Planets.Planet moon : planet.moons) {
                    moon.rotation = Planets.getRotation(moon, this.planetTimer, moonRotationSpeedScale);
                }
            });
        }
    }

    public void drawRings() {
        int start = 1;
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        for (Planets.StarSystem system : Planets.getStarsList()) {
            int end = start + system.planets.size();
            if (PlanetSelectionScreenHelper.categoryRange(this.category.get(), start, end)) {
                float maxR = 0.0f;
                for (Planets.Planet planet2 : system.planets) {
                    maxR = (float)Math.max((double)maxR, planet2.orbitRadius);
                }
                float rScale = Math.min(1.15f / maxR, 1.0f);
                system.planets.forEach(planet -> this.drawPlanetRing((Planets.Planet)planet, rScale, x, y, 0.0f, 0.0f, 10.0f, 10.0f));
            }
            start += end;
        }
    }

    private void drawPlanetRing(Planets.Planet planet, float ringScale, float x, float y, float dx, float dy, float width, float height) {
        if (planet.description == null) {
            planet.description = PlanetSelectionScreenHelper.tl(planet.name);
        }
        float distance = (float)(90.0 * planet.orbitRadius * (double)ringScale);
        float rotation = planet.rotation;
        float sinTick = (float)Math.sin(rotation);
        float cosTick = (float)Math.cos(rotation);
        float x0 = (float)(this.f_96543_ / 2) - width / 2.0f;
        float y0 = (float)(this.f_96544_ / 2) - height / 2.0f;
        planet._xPos = x0 + sinTick * distance + dx;
        planet._yPos = y0 + cosTick * distance + dy;
        float dxm = sinTick * distance;
        float dym = cosTick * distance;
        boolean isMoon = planet._parent instanceof Planets.Planet;
        Vec3 colour = new Vec3((double)planet.orbitColour[0], (double)planet.orbitColour[1], (double)planet.orbitColour[2]);
        PlanetSelectionScreenHelper.drawCircle(x, y, distance, 180, isMoon ? 0.5f : 1.0f, colour);
        float maxR = 0.0f;
        for (Planets.Planet moon2 : planet.moons) {
            maxR = (float)Math.max((double)maxR, moon2.orbitRadius);
        }
        float newScale = Math.min(1.15f / (maxR *= 5.0f), 1.0f);
        planet.moons.forEach(moon -> this.drawPlanetRing((Planets.Planet)moon, newScale, planet._xPos + width / 2.0f, planet._yPos + width / 2.0f, dxm, dym, width / 2.0f, height / 2.0f));
    }

    public void drawPlanets(PoseStack poseStack) {
        if (this.category.get() == 0) {
            PlanetSelectionScreenHelper.drawGalaxy(this, poseStack, MILKY_WAY_TEXTURE, -125.0f, -125.0f, 250, 250, this.rotationMilkyWay);
        }
        int start = 1;
        for (Planets.StarSystem system : Planets.getStarsList()) {
            int end = start + system.planets.size();
            if (PlanetSelectionScreenHelper.categoryRange(this.category.get(), start, end)) {
                system.planets.forEach(planet -> this.drawPlanet(poseStack, (Planets.Planet)planet, 10, 10, true));
            }
            start += end;
        }
    }

    private void drawPlanet(PoseStack poseStack, Planets.Planet planet, int height, int width, boolean showName) {
        if (height / 2 > 0) {
            planet.moons.forEach(moon -> this.drawPlanet(poseStack, (Planets.Planet)moon, height / 2, width / 2, false));
        }
        if (planet.description == null) {
            planet.description = PlanetSelectionScreenHelper.tl(planet.name);
        }
        if (planet.texture == null) {
            planet.texture = new ResourceLocation("missing_planet_texture_" + planet.name);
        }
        PlanetSelectionScreenHelper.drawPlanet(poseStack, planet, height, width, showName);
    }

    public void drawScroller(PoseStack poseStack, int x) {
        if (this.getVisibleButtons(1).size() > this.rowEnd) {
            int buttonStartY = this.f_96544_ / 2 - 33;
            int scrollSize = this.getVisibleButtons(1).size() - this.rowEnd;
            float y = (float)buttonStartY + 97.0f / (float)scrollSize * (float)(-this.scrollIndex);
            ScreenHelper.drawTexture(poseStack, x, (int)y, 4, 8, SCROLLER_TEXTURE, false);
        }
    }

    public void handleButtonPos(int rowStart, int rowEnd) {
        for (int f1 = rowStart; f1 <= rowEnd; ++f1) {
            for (int f2 = 0; f2 < this.getVisibleButtons(f1).size(); ++f2) {
                int y;
                ModifiedButton button = this.getVisibleButtons(f1).get(f2);
                int buttonStartY = this.f_96544_ / 2 - 34;
                int extraPos = 0;
                if (f1 >= 2 && rowEnd <= 3) {
                    extraPos = 1;
                }
                if (button.f_93621_ == (y = buttonStartY + 22 * (f2 + extraPos + this.scrollIndex))) continue;
                button.setPosition(button.f_93620_, y);
            }
        }
    }

    public boolean buttonScrollVisibility(ModifiedButton button) {
        int buttonStartY = this.f_96544_ / 2 - 34;
        int buttonEndY = buttonStartY + 22 * this.rowEnd;
        if (button.f_93621_ < buttonStartY && button.row != 0) {
            return false;
        }
        return button.f_93621_ < buttonEndY || button.row == 0;
    }

    public List<ModifiedButton> getVisibleButtons(int row) {
        ArrayList<ModifiedButton> listVisible = new ArrayList<ModifiedButton>();
        for (int f1 = 0; f1 < this.visibleButtons.size(); ++f1) {
            ModifiedButton button = this.visibleButtons.get(f1);
            if (button.row != row) continue;
            listVisible.add(button);
        }
        return listVisible;
    }

    public void visibleButton(ModifiedButton button, Boolean condition) {
        if (condition.booleanValue() && !this.visibleButtons.contains((Object)button)) {
            this.visibleButtons.add(button);
        }
        this.handleButtonPos(1, 3);
        button.f_93624_ = condition != false && this.buttonScrollVisibility(button);
    }

    public boolean getSpaceStationItemCheck() {
        return true;
    }

    public boolean checkTier(int tier) {
        return this.menu.getTier() >= tier;
    }

    public ModifiedButton addButton(int x, int y, int row, int width, int height, boolean rocketCondition, ModifiedButton.ButtonTypes type, List<String> list, ResourceLocation buttonTexture, TexturedButton.ColorTypes colorType, Component title, Button.OnPress onPress) {
        ModifiedButton button = (ModifiedButton)this.m_142416_((GuiEventListener)new ModifiedButton(x, y, row, width, height, 0, 0, 0, rocketCondition, type, list, buttonTexture, colorType, width, height, onPress, title));
        return button;
    }
}

