/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.client.screens.planetselection.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.simple.SimpleChannel;
import net.mrscauthd.beyond_earth.client.screens.buttons.ModifiedButton;
import net.mrscauthd.beyond_earth.client.screens.buttons.TexturedButton;
import net.mrscauthd.beyond_earth.client.screens.helper.ScreenHelper;
import net.mrscauthd.beyond_earth.client.screens.planetselection.PlanetSelectionScreen;
import net.mrscauthd.beyond_earth.client.screens.planetselection.helper.CategoryHelper;
import net.mrscauthd.beyond_earth.client.util.ClientMethods;
import net.mrscauthd.beyond_earth.common.menus.planetselection.PlanetSelectionMenuNetworkHandler;
import net.mrscauthd.beyond_earth.common.menus.planetselection.helper.PlanetSelectionMenuNetworkHandlerHelper;
import net.mrscauthd.beyond_earth.common.util.Planets;

@OnlyIn(value=Dist.CLIENT)
public class PlanetSelectionScreenHelper {
    public static ModifiedButton addCategoryButton(PlanetSelectionScreen screen, CategoryHelper categoryHelper, int x, int row, int width, int height, int newCategory, boolean pressCondition, boolean startVisibility, ModifiedButton.ButtonTypes type, List<String> list, ResourceLocation buttonTexture, TexturedButton.ColorTypes colorType, Component title) {
        ModifiedButton button = screen.addButton(x, 0, row, width, height, pressCondition, type, list, buttonTexture, colorType, title, onPress -> {
            if (pressCondition) {
                categoryHelper.set(newCategory);
                screen.scrollIndex = 0;
                screen.updateButtonVisibility();
            }
        });
        screen.visibleButton(button, startVisibility);
        return button;
    }

    public static ModifiedButton addHandlerButton(PlanetSelectionScreen screen, int x, int row, int width, int height, boolean pressCondition, boolean startVisibility, boolean holdKeyMessage, SimpleChannel simpleChannel, PlanetSelectionMenuNetworkHandlerHelper handler, ModifiedButton.ButtonTypes type, List<String> list, ResourceLocation buttonTexture, TexturedButton.ColorTypes colorType, Component title) {
        ModifiedButton button = screen.addButton(x, 0, row, width, height, pressCondition, type, list, buttonTexture, colorType, title, onPress -> {
            if (pressCondition) {
                PlanetSelectionScreenHelper.callPacketHandler(simpleChannel, handler);
                if (holdKeyMessage) {
                    ClientMethods.sendPressKeyMessage();
                }
                screen.scrollIndex = 0;
                screen.updateButtonVisibility();
            }
        });
        screen.visibleButton(button, startVisibility);
        return button;
    }

    public static ModifiedButton addBackButton(PlanetSelectionScreen screen, int x, int row, int width, int height, boolean startVisibility, ResourceLocation buttonTexture, TexturedButton.ColorTypes colorType, Component title, Button.OnPress onPress) {
        ModifiedButton button = screen.addButton(x, 0, row, width, height, false, null, null, buttonTexture, colorType, title, onPress);
        screen.visibleButton(button, startVisibility);
        return button;
    }

    public static void drawCircle(double x, double y, double radius, int sides, float lineWidth, Vec3 color) {
        double width;
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        int r = (int)color.m_7096_();
        int g = (int)color.m_7098_();
        int b = (int)color.m_7094_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        for (double f1 = width = radius - 0.5; f1 < width + (double)lineWidth; f1 += 0.1 * (double)lineWidth) {
            for (int f2 = 0; f2 <= sides; ++f2) {
                double angle = Math.PI * 2 * (double)f2 / (double)sides + Math.toRadians(180.0);
                bufferBuilder.m_5483_(x + Math.sin(angle) * f1, y + Math.cos(angle) * f1, 0.0).m_6122_(r, g, b, 255).m_5752_();
            }
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    public static void drawPlanet(PoseStack ms, Planets.Planet planet, int width, int height, boolean showName) {
        ResourceLocation texture = planet.texture;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        ScreenHelper.renderWithFloat.blit(ms, planet._xPos, planet._yPos, 0.0f, 0.0f, width, height, width, height);
        if (showName) {
            Font font = Minecraft.m_91087_().f_91062_;
            Component name = planet.description;
            font.m_92889_(ms, name, planet._xPos - (float)(font.m_92852_((FormattedText)name) / 3), planet._yPos + 13.0f, 0xFFFFFF);
        }
    }

    public static void drawGalaxy(PlanetSelectionScreen screen, PoseStack ms, ResourceLocation texture, float x, float y, int width, int height, float rotation) {
        ms.m_85836_();
        ms.m_85837_((double)(screen.f_96543_ / 2), (double)(screen.f_96544_ / 2), 0.0);
        ms.m_85845_(new Quaternion(Vector3f.f_122227_, rotation, true));
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        ScreenHelper.renderWithFloat.blit(ms, x, y, 0.0f, 0.0f, width, height, width, height);
        ms.m_85849_();
    }

    public static boolean categoryRange(int category, int start, int end) {
        return category >= start && category <= end;
    }

    public static Component tl(String text) {
        return Component.m_237115_((String)("gui.beyond_earth.planet_selection." + text));
    }

    public static void callPacketHandler(SimpleChannel simpleChannel, PlanetSelectionMenuNetworkHandlerHelper handler) {
        simpleChannel.sendToServer((Object)handler);
    }

    public static PlanetSelectionMenuNetworkHandler getNetworkHandler(int handler) {
        return new PlanetSelectionMenuNetworkHandler(handler);
    }
}

