/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.armors;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.mrscauthd.beyond_earth.common.capabilities.oxygen.IOxygenStorage;
import net.mrscauthd.beyond_earth.common.capabilities.oxygen.OxygenProvider;
import net.mrscauthd.beyond_earth.common.capabilities.oxygen.OxygenUtil;
import org.jetbrains.annotations.Nullable;

public abstract class ISpaceArmor
extends ArmorItem {
    private static final HashMap<String, ResourceLocation> TEXTURES = Maps.newHashMap();

    public ISpaceArmor(ArmorMaterial armorMaterial, EquipmentSlot equipmentSlot, Item.Properties properties) {
        super(armorMaterial, equipmentSlot, properties);
    }

    public ResourceLocation getTexture(ItemStack itemStack, LivingEntity entity) {
        String loc = itemStack.m_41720_().getArmorTexture(itemStack, (Entity)entity, itemStack.getEquipmentSlot(), null);
        ResourceLocation texture = TEXTURES.get(loc);
        if (texture == null) {
            texture = new ResourceLocation(loc);
            TEXTURES.put(loc, texture);
        }
        return texture;
    }

    public static abstract class Boots
    extends ISpaceArmor {
        public Boots(ArmorMaterial armorMaterial, EquipmentSlot equipmentSlot, Item.Properties properties) {
            super(armorMaterial, equipmentSlot, properties);
        }
    }

    public static abstract class Leggings
    extends ISpaceArmor {
        public Leggings(ArmorMaterial armorMaterial, EquipmentSlot equipmentSlot, Item.Properties properties) {
            super(armorMaterial, equipmentSlot, properties);
        }
    }

    public static abstract class Chestplate
    extends ISpaceArmor {
        public float oxygenTime;

        public Chestplate(ArmorMaterial armorMaterial, EquipmentSlot equipmentSlot, Item.Properties properties) {
            super(armorMaterial, equipmentSlot, properties);
        }

        public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> list) {
            super.m_6787_(tab, list);
            if (this.m_220152_(tab)) {
                ItemStack itemStack = new ItemStack((ItemLike)this);
                IOxygenStorage oxygen = OxygenUtil.getItemStackOxygenStorage(itemStack);
                oxygen.setOxygen(oxygen.getMaxCapacity());
                list.add((Object)itemStack);
            }
        }

        public void m_7373_(ItemStack itemStack, Level level, List<Component> list, TooltipFlag tooltipFlag) {
            super.m_7373_(itemStack, level, list, tooltipFlag);
            IOxygenStorage oxygen = OxygenUtil.getItemStackOxygenStorage(itemStack);
            list.add((Component)Component.m_237115_((String)"general.beyond_earth.oxygen").m_130946_(": ").m_130940_(ChatFormatting.BLUE).m_130946_("\u00a76" + oxygen.getOxygen() + " mb\u00a78 | \u00a7c" + oxygen.getMaxCapacity() + " mb"));
        }

        public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
            return new OxygenProvider(stack, this.getOxygenCapacity());
        }

        public void onArmorTick(ItemStack stack, Level level, Player player) {
            super.onArmorTick(stack, level, player);
        }

        public abstract int getOxygenCapacity();
    }

    public static abstract class Helmet
    extends ISpaceArmor {
        public Helmet(ArmorMaterial armorMaterial, EquipmentSlot equipmentSlot, Item.Properties properties) {
            super(armorMaterial, equipmentSlot, properties);
        }
    }
}

