/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.armors;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.mrscauthd.beyond_earth.client.renderers.armors.SpaceSuitModel;
import net.mrscauthd.beyond_earth.common.armors.ISpaceArmor;
import org.jetbrains.annotations.NotNull;

public class NetheriteSpaceSuit {

    public static class Boots
    extends ISpaceArmor.Boots {
        public Boots(ArmorMaterial armorMaterial, EquipmentSlot equipmentSlot, Item.Properties properties) {
            super(armorMaterial, equipmentSlot, properties);
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @NotNull
                public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                    Map<String, ModelPart> map = Map.of("right_leg", new SpaceSuitModel.SpaceSuitP1<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SpaceSuitModel.SpaceSuitP1.LAYER_LOCATION)).f_102813_, "left_leg", new SpaceSuitModel.SpaceSuitP1<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SpaceSuitModel.SpaceSuitP1.LAYER_LOCATION)).f_102814_, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()));
                    ModelPart modelPart = new ModelPart(Collections.emptyList(), map);
                    SpaceSuitModel.SpaceSuitP1 armorModel = new SpaceSuitModel.SpaceSuitP1(modelPart, livingEntity, itemStack);
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "beyond_earth:textures/armor/netherite_space_suit.png";
        }
    }

    public static class Pants
    extends ISpaceArmor.Leggings {
        public Pants(ArmorMaterial armorMaterial, EquipmentSlot equipmentSlot, Item.Properties properties) {
            super(armorMaterial, equipmentSlot, properties);
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @NotNull
                public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                    Map<String, ModelPart> map = Map.of("right_leg", new SpaceSuitModel.SpaceSuitP2<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SpaceSuitModel.SpaceSuitP2.LAYER_LOCATION)).f_102813_, "left_leg", new SpaceSuitModel.SpaceSuitP2<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SpaceSuitModel.SpaceSuitP2.LAYER_LOCATION)).f_102814_, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()));
                    ModelPart modelPart = new ModelPart(Collections.emptyList(), map);
                    SpaceSuitModel.SpaceSuitP2 armorModel = new SpaceSuitModel.SpaceSuitP2(modelPart, livingEntity, itemStack);
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "beyond_earth:textures/armor/netherite_space_pants.png";
        }
    }

    public static class Suit
    extends ISpaceArmor.Chestplate {
        public Suit(ArmorMaterial armorMaterial, EquipmentSlot equipmentSlot, Item.Properties properties) {
            super(armorMaterial, equipmentSlot, properties);
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @NotNull
                public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                    Map<String, ModelPart> map = Map.of("body", new SpaceSuitModel.SpaceSuitP1<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SpaceSuitModel.SpaceSuitP1.LAYER_LOCATION)).f_102810_, "right_arm", new SpaceSuitModel.SpaceSuitP1<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SpaceSuitModel.SpaceSuitP1.LAYER_LOCATION)).f_102811_, "left_arm", new SpaceSuitModel.SpaceSuitP1<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SpaceSuitModel.SpaceSuitP1.LAYER_LOCATION)).f_102812_, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()));
                    ModelPart modelPart = new ModelPart(Collections.emptyList(), map);
                    SpaceSuitModel.SpaceSuitP1 armorModel = new SpaceSuitModel.SpaceSuitP1(modelPart, livingEntity, itemStack);
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "beyond_earth:textures/armor/netherite_space_suit.png";
        }

        @Override
        public int getOxygenCapacity() {
            return 48000;
        }
    }

    public static class Helmet
    extends ISpaceArmor.Helmet {
        public Helmet(ArmorMaterial armorMaterial, EquipmentSlot equipmentSlot, Item.Properties properties) {
            super(armorMaterial, equipmentSlot, properties);
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @NotNull
                public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                    Map<String, ModelPart> map = Map.of("head", new SpaceSuitModel.SpaceSuitP1<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)SpaceSuitModel.SpaceSuitP1.LAYER_LOCATION)).f_102808_, "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()));
                    ModelPart modelPart = new ModelPart(Collections.emptyList(), map);
                    SpaceSuitModel.SpaceSuitP1 armorModel = new SpaceSuitModel.SpaceSuitP1(modelPart, livingEntity, itemStack);
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "beyond_earth:textures/armor/netherite_space_suit.png";
        }
    }
}

