/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.blocks.entities.machines;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.GaugeValueHelper;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.IGaugeValue;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.IGaugeValuesProvider;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.power.NamedComponentRegistry;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.power.PowerSystem;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.power.PowerSystemFuel;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.power.PowerSystemRegistry;
import net.mrscauthd.beyond_earth.common.blocks.machines.AbstractMachineBlock;
import net.mrscauthd.beyond_earth.common.capabilities.energy.IEnergyStorageHolder;
import net.mrscauthd.beyond_earth.common.data.recipes.FluidIngredient;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractMachineBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer,
IEnergyStorageHolder,
IGaugeValuesProvider {
    public static final String KEY_ACTIVATED = "activated";
    public static final int DEFAULT_ENERGY_STORAGE_CAPACITY = 9000;
    public static final int DEFAULT_ENERGY_STORAGE_TRANSFER = 200;
    public static final int DEFAULT_TANK_CAPACITY = 3000;
    public static final int DEFAULT_TANK_TRANSFER = 256;
    private final Map<Object, Object> selectedPrimaries = new HashMap<Object, Object>();
    private final Map<ResourceLocation, IEnergyStorage> energyStorages;
    private final Map<ResourceLocation, IFluidHandler> fluidHandlers;
    private final Map<ResourceLocation, PowerSystem> powerSystems;
    private NonNullList<ItemStack> stacks = null;
    private final LazyOptional<? extends IItemHandler>[] itemHandlers;
    private boolean processedInThisTick = false;

    public AbstractMachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        NamedComponentRegistry<IEnergyStorage> energyRegistry = new NamedComponentRegistry<IEnergyStorage>();
        this.createEnergyStorages(energyRegistry);
        this.energyStorages = Collections.unmodifiableMap(energyRegistry);
        NamedComponentRegistry<IFluidHandler> fluidRegistry = new NamedComponentRegistry<IFluidHandler>();
        this.createFluidHandlers(fluidRegistry);
        this.fluidHandlers = Collections.unmodifiableMap(fluidRegistry);
        PowerSystemRegistry powerSystemMap = new PowerSystemRegistry();
        this.createPowerSystems(powerSystemMap);
        this.powerSystems = Collections.unmodifiableMap(powerSystemMap);
        this.itemHandlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])Direction.values());
        this.createItemHandlers();
        this.stacks = NonNullList.m_122780_((int)this.getInitialInventorySize(), (Object)ItemStack.f_41583_);
    }

    public Component m_6820_() {
        ResourceLocation registryName = ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)this.m_58903_());
        return Component.m_237115_((String)("container." + registryName.m_135827_() + "." + registryName.m_135815_()));
    }

    protected void createItemHandlers() {
    }

    public boolean isPowerEnoughForOperation() {
        return this.getPowerSystems().values().stream().allMatch(PowerSystem::isPowerEnoughForOperation);
    }

    @Nullable
    public Map<PowerSystem, Integer> consumePowerForOperation() {
        if (this.isPowerEnoughForOperation()) {
            return this.getPowerSystems().values().stream().collect(Collectors.toMap(ps -> ps, PowerSystem::consumeForOperation));
        }
        return null;
    }

    public int getPowerPerTick(PowerSystem powerSystem, int base) {
        return base;
    }

    public int getPowerForOperation(PowerSystem powerSystem, int base) {
        return base;
    }

    protected int getInitialInventorySize() {
        return this.getPowerSystems().values().stream().collect(Collectors.summingInt(PowerSystem::getUsingSlots));
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.stacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compound, this.stacks);
        this.deserializeCompoents(this.getEnergyStorages(), compound.m_128469_("energyStorages"));
        this.deserializeCompoents(this.getFluidHandlers(), compound.m_128469_("fluidHandlers"));
        this.deserializeCompoents(this.getPowerSystems(), compound.m_128469_("powerSystems"));
    }

    public <T> void deserializeCompoents(Map<ResourceLocation, T> registry, @Nonnull CompoundTag compound) {
        for (Map.Entry<ResourceLocation, T> entry : registry.entrySet()) {
            Tag tag = compound.m_128423_(entry.getKey().toString());
            if (tag == null) continue;
            this.deserializeComponent(entry.getKey(), entry.getValue(), tag);
        }
    }

    public <T> void deserializeComponent(ResourceLocation name, @Nonnull T component, @Nonnull Tag tag) {
        if (component != null && tag != null) {
            if (component instanceof INBTSerializable) {
                ((INBTSerializable)component).deserializeNBT(tag);
            } else if (component instanceof EnergyStorage) {
                ((EnergyStorage)component).deserializeNBT(tag);
            } else if (component instanceof FluidTank) {
                ((FluidTank)component).readFromNBT((CompoundTag)tag);
            }
        }
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.stacks);
        compound.m_128365_("energyStorages", (Tag)this.serializeComponents(this.getEnergyStorages()));
        compound.m_128365_("fluidHandlers", (Tag)this.serializeComponents(this.getFluidHandlers()));
        compound.m_128365_("powerSystems", (Tag)this.serializeComponents(this.getPowerSystems()));
    }

    @Nonnull
    public <T> CompoundTag serializeComponents(Map<ResourceLocation, T> registry) {
        CompoundTag compound = new CompoundTag();
        for (Map.Entry<ResourceLocation, T> entry : registry.entrySet()) {
            Tag tag = this.serializeComponent(entry.getKey(), entry.getValue());
            if (tag == null) continue;
            compound.m_128365_(entry.getKey().toString(), tag);
        }
        return compound;
    }

    @Nullable
    public <T> Tag serializeComponent(ResourceLocation name, @Nonnull T component) {
        if (component == null) {
            return null;
        }
        if (component instanceof INBTSerializable) {
            return ((INBTSerializable)component).serializeNBT();
        }
        if (component instanceof EnergyStorage) {
            return ((EnergyStorage)component).serializeNBT();
        }
        if (component instanceof FluidTank) {
            return ((FluidTank)component).writeToNBT(new CompoundTag());
        }
        return null;
    }

    public int m_6643_() {
        return this.stacks.size();
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.stacks;
    }

    protected void m_6520_(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    protected void getSlotsForFace(Direction direction, List<Integer> slots) {
        this.getPowerSystems().values().stream().forEach(ps -> ps.getSlotsForFace(direction, slots));
    }

    public int[] m_7071_(Direction side) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        this.getSlotsForFace(side, slots);
        return Ints.toArray(slots);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.onCanPlaceItemThroughFace(index, stack, null);
    }

    public final boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        ItemStack stackInSlot;
        boolean result = this.onCanPlaceItemThroughFace(index, stack, direction);
        if (result && !(stackInSlot = this.m_8020_(index)).m_41619_() && ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stack)) {
            int limit = Math.min(stack.m_41741_(), this.m_6893_());
            if (stackInSlot.m_41613_() + stack.m_41613_() > limit) {
                return false;
            }
        }
        return result;
    }

    protected boolean onCanPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return this.getPowerSystems().values().stream().anyMatch(ps -> ps.canInsertItem(direction, index, stack));
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return this.getPowerSystems().values().stream().anyMatch(ps -> ps.canExtractItem(direction, index, stack));
    }

    public <T> LazyOptional<T> getCapabilityItemHandler(Capability<T> capability, @Nullable Direction facing) {
        if (facing != null) {
            return this.itemHandlers[facing.ordinal()].cast();
        }
        return super.getCapability(capability, facing);
    }

    public <T> LazyOptional<T> getCapabilityEnergy(Capability<T> capability, @Nullable Direction facing) {
        IEnergyStorage energyStorage = this.getPrimaryEnergyStorage();
        if (energyStorage != null) {
            return LazyOptional.of(() -> energyStorage).cast();
        }
        return LazyOptional.empty();
    }

    public <T> LazyOptional<T> getCapabilityFluidHandler(Capability<T> capability, @Nullable Direction facing) {
        IFluidHandler fluidHandler = this.getPrimaryFluidHandler();
        if (fluidHandler != null) {
            return LazyOptional.of(() -> fluidHandler).cast();
        }
        return LazyOptional.empty();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.m_58901_()) {
            LazyOptional<T> optional;
            if (capability == ForgeCapabilities.ITEM_HANDLER ? (optional = this.getCapabilityItemHandler(capability, facing)) != null && optional.isPresent() : (capability == ForgeCapabilities.ENERGY ? (optional = this.getCapabilityEnergy(capability, facing)) != null && optional.isPresent() : capability == ForgeCapabilities.FLUID_HANDLER && (optional = this.getCapabilityFluidHandler(capability, facing)) != null && optional.isPresent())) {
                return optional;
            }
            for (PowerSystem powerSystem : this.getPowerSystems().values()) {
                LazyOptional<T> optional2 = powerSystem.getCapability(capability, facing);
                if (optional2 == null || !optional2.isPresent()) continue;
                return optional2;
            }
        }
        return super.getCapability(capability, facing);
    }

    public void m_7651_() {
        super.m_7651_();
        Arrays.stream(this.itemHandlers).forEach(h -> h.invalidate());
    }

    public void tick() {
        if (this.m_58904_().m_5776_()) {
            return;
        }
        this.onTickProcessingPre();
        if (this.canTickProcessing()) {
            this.tickProcessing();
        }
        this.onTickProcessingPost();
        this.updatePowerSystem();
        this.updateActivated();
        this.refreshBlockActivatedChanged();
    }

    protected void updatePowerSystem() {
        this.getPowerSystems().values().forEach(ps -> ps.update());
    }

    protected BooleanProperty getBlockActivatedProperty() {
        return AbstractMachineBlock.LIT;
    }

    protected void refreshBlockActivatedChanged() {
        BooleanProperty property = this.getBlockActivatedProperty();
        BlockState state = this.m_58900_();
        if (property == null || !state.m_61138_((Property)property)) {
            return;
        }
        Level level = this.m_58904_();
        BlockPos pos = this.m_58899_();
        boolean activated = this.isActivated();
        if ((Boolean)state.m_61143_((Property)property) != activated) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(activated)), 3);
        }
    }

    protected void onTickProcessingPre() {
        this.processedInThisTick = false;
    }

    protected boolean canTickProcessing() {
        return true;
    }

    protected abstract void tickProcessing();

    protected void onTickProcessingPost() {
    }

    public void updateActivated() {
        this.setActivated(this.canActivated());
    }

    protected boolean canActivated() {
        PowerSystem primary;
        ArrayList powerSystems = Lists.newArrayList(this.getPowerSystems().values());
        if (powerSystems.size() == 1 && (primary = (PowerSystem)powerSystems.get(0)) instanceof PowerSystemFuel) {
            return primary.isPowerEnoughForOperation();
        }
        return this.processedInThisTick;
    }

    @Nonnull
    protected void createPowerSystems(PowerSystemRegistry map) {
    }

    public Map<ResourceLocation, PowerSystem> getPowerSystems() {
        return this.powerSystems;
    }

    @Nullable
    protected void createFluidHandlers(NamedComponentRegistry<IFluidHandler> registry) {
    }

    public Map<ResourceLocation, IFluidHandler> getFluidHandlers() {
        return this.fluidHandlers;
    }

    public IFluidHandler getPrimaryFluidHandler() {
        return this.getPrimaryComponent(this.getFluidHandlers());
    }

    @Nullable
    protected void createEnergyStorages(NamedComponentRegistry<IEnergyStorage> registry) {
    }

    public Map<ResourceLocation, IEnergyStorage> getEnergyStorages() {
        return this.energyStorages;
    }

    @Nullable
    public IEnergyStorage getPrimaryEnergyStorage() {
        return this.getPrimaryComponent(this.getEnergyStorages());
    }

    @Nonnull
    public <T> T getPrimaryComponent(Map<ResourceLocation, T> map) {
        return (T)this.selectedPrimaries.computeIfAbsent(map, k -> this.selectPrimaryComponent((Map)k));
    }

    protected <T> T selectPrimaryComponent(Map<ResourceLocation, T> map) {
        if (map.containsKey(NamedComponentRegistry.UNNAMED)) {
            return map.get(NamedComponentRegistry.UNNAMED);
        }
        return map.values().stream().findFirst().orElse(null);
    }

    public IItemHandlerModifiable getItemHandler() {
        return (IItemHandlerModifiable)this.getCapability(ForgeCapabilities.ITEM_HANDLER, null).resolve().get();
    }

    public boolean isActivated() {
        return this.getPersistentData().m_128471_(KEY_ACTIVATED);
    }

    protected void setActivated(boolean activated) {
        if (this.isActivated() != activated) {
            this.getPersistentData().m_128379_(KEY_ACTIVATED, activated);
            this.m_6596_();
        }
    }

    public void m_6596_() {
        super.m_6596_();
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7726_().m_8450_(this.m_58899_());
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    @Override
    public void onEnergyChanged(IEnergyStorage energyStorage, int energyDelta) {
        this.m_6596_();
    }

    protected boolean isProcessedInThisTick() {
        return this.processedInThisTick;
    }

    protected void setProcessedInThisTick() {
        this.processedInThisTick = true;
    }

    public abstract boolean hasSpaceInOutput();

    public boolean nullOrMatch(@Nullable Direction direction, Direction ... matches) {
        return direction == null || ArrayUtils.contains((Object[])matches, (Object)direction);
    }

    public boolean hasSpaceInOutput(ItemStack recipeOutput, ItemStack output) {
        if (output.m_41619_()) {
            return true;
        }
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)output, (ItemStack)recipeOutput)) {
            int limit = Math.min(recipeOutput.m_41741_(), this.m_6893_());
            return output.m_41613_() + recipeOutput.m_41613_() <= limit;
        }
        return false;
    }

    public boolean hasSpaceInOutput(FluidIngredient recipeOutput, IFluidTank tank) {
        return this.hasSpaceInOutput(recipeOutput, tank.getFluid(), tank.getCapacity());
    }

    public boolean hasSpaceInOutput(FluidIngredient recipeOutput, FluidStack output, int capacity) {
        if (output.isEmpty()) {
            return true;
        }
        if (recipeOutput.testFluid(output.getFluid())) {
            return output.getAmount() + recipeOutput.getAmount() <= capacity;
        }
        return false;
    }

    public List<IGaugeValue> getFluidHandlerGaugeValues(IFluidHandler fluidHandler) {
        ArrayList<IGaugeValue> list = new ArrayList<IGaugeValue>();
        for (int i = 0; i < fluidHandler.getTanks(); ++i) {
            list.add(GaugeValueHelper.getFluid(fluidHandler.getFluidInTank(i), fluidHandler.getTankCapacity(i)));
        }
        return list;
    }

    @Override
    public List<IGaugeValue> getDisplayGaugeValues() {
        ArrayList<IGaugeValue> list = new ArrayList<IGaugeValue>();
        this.getPowerSystems().values().stream().map(PowerSystem::getGaugeValues).forEach(list::addAll);
        return list;
    }
}

