/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.blocks.entities.machines;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.energy.IEnergyStorage;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.GeneratorBlockEntity;
import net.mrscauthd.beyond_earth.common.capabilities.energy.EnergyStorageBasic;
import net.mrscauthd.beyond_earth.common.config.Config;
import net.mrscauthd.beyond_earth.common.menus.SolarPanelMenu;
import net.mrscauthd.beyond_earth.common.registries.BlockEntityRegistry;

public class SolarPanelBlockEntity
extends GeneratorBlockEntity {
    public static final int DEFAULT_ENERGY_USAGE = 5;

    public SolarPanelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.SOLAR_PANEL_BLOCK_ENTITY.get(), pos, state);
    }

    public AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new SolarPanelMenu.GuiContainer(id, inventory, this);
    }

    protected int getGenerationInTick() {
        return this.getMaxGeneration();
    }

    @Override
    public int getMaxGeneration() {
        return (Integer)Config.SOLAR_PANEL_ENERGY_GENERATION.get();
    }

    @Override
    protected boolean canGenerateEnergy() {
        Level level = this.m_58904_();
        BlockPos blockPos = new BlockPos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_() + 1, this.m_58899_().m_123343_());
        return level.m_46461_() && level.m_45527_(blockPos);
    }

    @Override
    protected void generateEnergy() {
        this.generateEnergy(this.getGenerationInTick());
    }

    @Override
    protected List<Direction> getEjectDirections() {
        List<Direction> list = super.getEjectDirections();
        list.addAll(Arrays.stream(Direction.values()).filter(d -> d != Direction.UP).toList());
        return list;
    }

    @Override
    protected IEnergyStorage createGeneratingEnergyStorage() {
        int capacity = (Integer)Config.SOLAR_PANEL_ENERGY_CAPACITY.get();
        int maxExtract = (Integer)Config.SOLAR_PANEL_ENERGY_TRANSFER.get();
        return new EnergyStorageBasic(this, capacity, capacity, maxExtract);
    }
}

