/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.GaugeValueFluidStack;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.GaugeValueSimple;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.IGaugeValue;

public class GaugeValueSerializer<T extends INBTSerializable<CompoundTag>> {
    public static final GaugeValueSerializer<IGaugeValue> Serializer = new GaugeValueSerializer();
    private final Map<ResourceLocation, Class<? extends T>> location_class_map = new LinkedHashMap<ResourceLocation, Class<? extends T>>();
    private final Map<Class<? extends T>, ResourceLocation> class_location_map = new LinkedHashMap<Class<? extends T>, ResourceLocation>();

    private GaugeValueSerializer() {
    }

    public T deserialize(CompoundTag compound) {
        String locationToString = compound.m_128461_("location");
        CompoundTag valueNBT = compound.m_128469_("value");
        Class<T> clazz = this.location_class_map.get(new ResourceLocation(locationToString));
        INBTSerializable format = null;
        try {
            format = (INBTSerializable)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            format.deserializeNBT((Tag)valueNBT);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        return (T)format;
    }

    public T read(FriendlyByteBuf buffer) {
        return this.deserialize(buffer.m_130260_());
    }

    public CompoundTag serialize(T format) {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("location", this.class_location_map.get(format.getClass()).toString());
        compound.m_128365_("value", format.serializeNBT());
        return compound;
    }

    public void write(T format, FriendlyByteBuf buffer) {
        buffer.m_130079_(this.serialize(format));
    }

    public void addCodec(ResourceLocation location, Class<? extends T> clazz) {
        this.location_class_map.put(location, clazz);
        this.class_location_map.put(clazz, location);
    }

    static {
        Serializer.addCodec(new ResourceLocation("beyond_earth", "fluidstack"), GaugeValueFluidStack.class);
        Serializer.addCodec(new ResourceLocation("beyond_earth", "simple"), GaugeValueSimple.class);
    }
}

