/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.capabilities.oxygen;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.mrscauthd.beyond_earth.common.capabilities.oxygen.IOxygenStorage;
import net.mrscauthd.beyond_earth.common.capabilities.oxygen.IOxygenStorageHolder;

public class OxygenStorage
implements IOxygenStorage {
    private int oxygen;
    private int capacity;
    private final IOxygenStorageHolder listener;

    public OxygenStorage(IOxygenStorageHolder holder, int capacity) {
        this(holder, capacity, 0);
    }

    public OxygenStorage(IOxygenStorageHolder holder, int capacity, int oxygen) {
        this.listener = holder;
        this.capacity = capacity;
        this.oxygen = Math.max(0, Math.min(capacity, oxygen));
    }

    public OxygenStorage(IOxygenStorageHolder listener) {
        this.listener = listener;
    }

    public void setMaxCapacity(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public int getOxygen() {
        return this.oxygen;
    }

    @Override
    public void setOxygen(int oxygen) {
        oxygen = Mth.m_14045_((int)oxygen, (int)0, (int)this.getMaxCapacity());
        int dO2 = oxygen - this.oxygen;
        this.oxygen = oxygen;
        if (this.listener != null) {
            this.listener.onOxygenChanged(this, dO2);
        }
    }

    @Override
    public int getMaxCapacity() {
        return this.capacity;
    }

    @Override
    public double getOxygenStoredRatio() {
        return (double)this.getOxygen() / (double)this.getMaxCapacity();
    }

    @Override
    public int receiveOxygen(int maxReceive, boolean simulate) {
        int oxygen = (int)Mth.m_14053_((long)((long)this.oxygen + (long)maxReceive), (long)0L, (long)this.getMaxCapacity());
        int dO2 = oxygen - this.oxygen;
        if (!simulate) {
            this.setOxygen(oxygen);
        }
        return dO2;
    }

    @Override
    public int extractOxygen(int maxExtract, boolean simulate) {
        int oxygen = (int)Mth.m_14053_((long)((long)this.oxygen - (long)maxExtract), (long)0L, (long)this.getMaxCapacity());
        int dO2 = this.oxygen - oxygen;
        if (!simulate) {
            this.setOxygen(oxygen);
        }
        return dO2;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128405_("oxygenStorage", this.getOxygen());
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.oxygen = nbt.m_128451_("oxygenStorage");
    }
}

