/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkEvent;
import net.mrscauthd.beyond_earth.common.events.forge.PlanetRegisterEvent;
import net.mrscauthd.beyond_earth.common.util.Planets;

public class PlanetData {
    public boolean modified = false;
    public List<StarEntry> stars = new ArrayList<StarEntry>();

    public void initPlanets(boolean event) {
        if (!this.modified) {
            this.stars.clear();
            Planets.getStarsList().forEach(s -> this.stars.add(new StarEntry((Planets.StarSystem)s)));
            Planets.clear();
            this.stars.forEach(StarEntry::toStarSystem);
            if (event) {
                MinecraftForge.EVENT_BUS.post((Event)new PlanetRegisterEvent.Load());
            }
            Planets.initIDs();
            return;
        }
        Planets.clear();
        this.stars.forEach(StarEntry::toStarSystem);
        if (event) {
            MinecraftForge.EVENT_BUS.post((Event)new PlanetRegisterEvent.Load());
        }
        Planets.initIDs();
    }

    public static void loadOrGenerateDefaults() {
        Path path = FMLPaths.CONFIGDIR.get().resolve("beyond_earth").resolve("planets.json");
        try {
            BufferedReader reader = Files.newBufferedReader(path);
            PlanetData data = (PlanetData)PlanetDataHandler.gson.fromJson((Reader)reader, PlanetData.class);
            data.initPlanets(true);
        }
        catch (Exception e) {
            if (!(e instanceof NoSuchFileException)) {
                e.printStackTrace();
            }
            Planets.generateDefaults();
            PlanetData defaults = new PlanetData();
            Planets.ORDERED_STARS.forEach(s -> defaults.stars.add(new StarEntry((Planets.StarSystem)s)));
            try {
                File folder = path.toFile().getParentFile();
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                String json = PlanetDataHandler.gson.toJson((Object)defaults);
                BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);
                writer.write(json);
                writer.close();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            defaults.modified = true;
            defaults.initPlanets(true);
        }
    }

    public static class PlanetDataHandler {
        public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
        public PlanetData data;

        public static void encode(PlanetDataHandler data, FriendlyByteBuf buffer) {
            buffer.m_130070_(gson.toJson((Object)data.data));
        }

        public static PlanetDataHandler decode(FriendlyByteBuf buffer) {
            PlanetDataHandler ret = new PlanetDataHandler();
            ret.data = (PlanetData)gson.fromJson(buffer.m_130277_(), PlanetData.class);
            return ret;
        }

        public static void handle(PlanetDataHandler message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> message.data.initPlanets(false));
        }
    }

    public static class StarEntry {
        String name;
        String texture;
        public List<PlanetEntry> planets = new ArrayList<PlanetEntry>();
        public float[] location = new float[3];
        public int[] colour = new int[]{255, 255, 255};
        double mass = 1.0;

        public StarEntry() {
        }

        public StarEntry(Planets.StarSystem star) {
            this.name = star.name;
            this.mass = star.mass;
            this.location = star.location;
            this.colour = star.colour;
            if (star.texture != null) {
                this.texture = star.texture.toString();
            }
            star.planets.forEach(p -> this.planets.add(new PlanetEntry((Planets.Planet)p)));
        }

        public Planets.StarSystem toStarSystem() {
            Planets.StarSystem star = new Planets.StarSystem();
            star.name = this.name;
            this.planets.forEach(p -> star.addChild(p.toPlanet(null)));
            star.mass = this.mass;
            star.location = this.location;
            star.colour = this.colour;
            if (this.texture != null) {
                star.texture = new ResourceLocation(this.texture);
            }
            star.register();
            return star;
        }
    }

    public static class PlanetEntry {
        String name;
        String planet;
        String orbit;
        String planet_bar;
        String orbit_bar;
        String texture;
        String phase_texture;
        double orbit_radius = 1.0;
        double mass = 1.0;
        float g = 1.0f;
        float orbit_g = 0.05f;
        double radius = 6000.0;
        float air_density = 0.0f;
        boolean has_oxygen = false;
        boolean has_rain = false;
        boolean has_clouds = false;
        boolean space_level = true;
        boolean has_dust_storms = false;
        float rotation = 0.0f;
        int[] orbit_colour = new int[]{255, 255, 255};
        public float[] sunriseColour = new float[]{0.7f, 0.2f, 0.2f};
        boolean tidal_lock = false;
        int tier = 0;
        public List<PlanetEntry> moons = new ArrayList<PlanetEntry>();

        public PlanetEntry() {
        }

        public PlanetEntry(Planets.Planet planet) {
            this.mass = planet.mass;
            this.orbit_radius = planet.orbitRadius;
            this.name = planet.name;
            this.planet = planet.planet.m_135782_().toString();
            this.orbit = planet.orbit.m_135782_().toString();
            this.has_oxygen = planet.hasOxygen;
            this.space_level = planet.spaceLevel;
            this.has_clouds = planet.hasClouds;
            this.has_rain = planet.hasRain;
            this.has_dust_storms = planet.hasDustStorms;
            this.tier = planet.tier;
            this.g = planet.g;
            this.tidal_lock = planet.tidalLock;
            this.air_density = planet.airDensity;
            this.radius = planet.radius;
            this.orbit_colour = planet.orbitColour;
            this.sunriseColour = planet.sunriseColour;
            if (planet.planetBar != null) {
                this.planet_bar = planet.planetBar.toString();
            }
            if (planet.orbitBar != null) {
                this.orbit_bar = planet.orbitBar.toString();
            }
            if (planet.texture != null) {
                this.texture = planet.texture.toString();
            }
            if (planet.phaseTexture != null) {
                this.phase_texture = planet.phaseTexture.toString();
            }
            this.rotation = planet.rotation;
            planet.moons.forEach(p -> this.moons.add(new PlanetEntry((Planets.Planet)p)));
        }

        public Planets.Planet toPlanet(@Nullable Planets.Planet parent) {
            ResourceKey location = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(this.planet));
            ResourceKey orbit = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(this.orbit));
            Planets.Planet planet = new Planets.Planet((ResourceKey<Level>)location, (ResourceKey<Level>)orbit);
            if (this.name != null) {
                planet.name = this.name;
            }
            if (this.planet_bar != null) {
                planet.planetBar = new ResourceLocation(this.planet_bar);
            }
            if (this.orbit_bar != null) {
                planet.orbitBar = new ResourceLocation(this.orbit_bar);
            }
            if (this.texture != null) {
                planet.texture = new ResourceLocation(this.texture);
            }
            if (this.phase_texture != null) {
                planet.phaseTexture = new ResourceLocation(this.phase_texture);
            }
            planet.mass = this.mass;
            planet.orbitRadius = this.orbit_radius;
            planet.g = this.g;
            planet.hasClouds = this.has_clouds;
            planet.hasDustStorms = this.has_dust_storms;
            planet.sunriseColour = this.sunriseColour;
            planet.tidalLock = this.tidal_lock;
            planet.airDensity = this.air_density;
            planet.radius = this.radius;
            planet.rotation = this.rotation;
            planet.orbitPhase = this.rotation;
            planet._initPhase = this.rotation;
            planet.hasOxygen = this.has_oxygen;
            planet.hasRain = this.has_rain;
            planet.spaceLevel = this.space_level;
            planet.tier = this.tier;
            planet.orbitColour = this.orbit_colour;
            if (parent != null) {
                parent.addChild(planet);
            }
            this.moons.forEach(p -> p.toPlanet(planet));
            return planet;
        }
    }
}

