/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.data.recipes;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.mrscauthd.beyond_earth.common.data.recipes.AlienTradingRecipeItemStack;
import net.mrscauthd.beyond_earth.common.data.recipes.BeyondEarthRecipeSerializer;
import net.mrscauthd.beyond_earth.common.registries.RecipeSerializersRegistry;
import net.mrscauthd.beyond_earth.common.registries.RecipeTypeRegistry;

public class AlienTradingRecipeDyedItem
extends AlienTradingRecipeItemStack {
    private float chance1 = 0.7f;
    private float chance2 = 0.8f;

    public AlienTradingRecipeDyedItem(ResourceLocation id, JsonObject json) {
        super(id, json);
        this.chance1 = GsonHelper.m_13820_((JsonObject)json, (String)"chance1", (float)this.chance1);
        this.chance2 = GsonHelper.m_13820_((JsonObject)json, (String)"chance2", (float)this.chance2);
    }

    public AlienTradingRecipeDyedItem(ResourceLocation id, FriendlyByteBuf buffer) {
        super(id, buffer);
        this.chance1 = buffer.readFloat();
        this.chance2 = buffer.readFloat();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeFloat(this.chance1);
        buffer.writeFloat(this.chance2);
    }

    @Override
    public ItemStack getResult(Entity trader, RandomSource rand) {
        ItemStack result = super.getResult(trader, rand);
        if (result.m_41720_() instanceof DyeableArmorItem) {
            ArrayList list = Lists.newArrayList();
            list.add(this.getRandomDyeItem(rand));
            if (rand.m_188501_() > this.getChance1()) {
                list.add(this.getRandomDyeItem(rand));
            }
            if (rand.m_188501_() > this.getChance2()) {
                list.add(this.getRandomDyeItem(rand));
            }
            return DyeableLeatherItem.m_41118_((ItemStack)result, (List)list);
        }
        return result;
    }

    public DyeItem getRandomDyeItem(RandomSource random) {
        return DyeItem.m_41082_((DyeColor)DyeColor.m_41053_((int)random.m_188503_(16)));
    }

    public float getChance1() {
        return this.chance1;
    }

    public float getChance2() {
        return this.chance2;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializersRegistry.RECIPE_SERIALIZER_ALIEN_TRADING_DYED_ITEM.get();
    }

    @Override
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.ALIEN_TRADING_DYED_ITEM.get();
    }

    public static class Serializer
    extends BeyondEarthRecipeSerializer<AlienTradingRecipeDyedItem> {
        public AlienTradingRecipeDyedItem fromJson(ResourceLocation id, JsonObject json) {
            return new AlienTradingRecipeDyedItem(id, json);
        }

        public AlienTradingRecipeDyedItem fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            return new AlienTradingRecipeDyedItem(id, buffer);
        }

        public void toNetwork(FriendlyByteBuf buffer, AlienTradingRecipeDyedItem recipe) {
            recipe.write(buffer);
        }
    }
}

