/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.mrscauthd.beyond_earth.common.data.recipes.BeyondEarthRecipe;
import net.mrscauthd.beyond_earth.common.registries.RecipeSerializersRegistry;
import net.mrscauthd.beyond_earth.common.registries.RecipeTypeRegistry;

public class GeneratingRecipe
extends BeyondEarthRecipe
implements Predicate<ItemStack> {
    public static final int SLOT_FUEL = 0;
    private final Ingredient input;
    private final int burnTime;

    public GeneratingRecipe(ResourceLocation id, JsonObject json) {
        super(id, json);
        this.input = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
        this.burnTime = GsonHelper.m_13927_((JsonObject)json, (String)"burnTime");
    }

    public GeneratingRecipe(ResourceLocation id, FriendlyByteBuf buffer) {
        super(id, buffer);
        this.input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        this.burnTime = buffer.readInt();
    }

    public GeneratingRecipe(ResourceLocation id, Ingredient ingredient, int burnTime) {
        super(id);
        this.input = ingredient;
        this.burnTime = burnTime;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        this.getInput().m_43923_(buffer);
        buffer.writeInt(this.getBurnTime());
    }

    public boolean m_8004_(int var1, int var2) {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializersRegistry.RECIPE_SERIALIZER_COAL_GENERATOR.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.COAL_GENERATING.get();
    }

    public int getFuelSlot(Container container, Level level) {
        return 0;
    }

    @Override
    public boolean test(ItemStack ingredient) {
        return this.input.test(ingredient);
    }

    public Ingredient getInput() {
        return this.input;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = super.m_7527_();
        list.add((Object)this.getInput());
        return list;
    }

    public int getBurnTime() {
        return this.burnTime;
    }
}

