/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public abstract class IVehicleEntity
extends Entity {
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private float speed;
    private boolean discardFriction = false;
    public float xxa;
    public float yya;
    public float zza;

    public IVehicleEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.f_19850_ = true;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag p_20052_) {
    }

    protected void m_7380_(CompoundTag p_20139_) {
    }

    public boolean m_6087_() {
        return true;
    }

    public InteractionResult m_6096_(Player p_19978_, InteractionHand p_19979_) {
        return InteractionResult.PASS;
    }

    public void m_8119_() {
        super.m_8119_();
        this.tickLerp();
        this.rotAnim();
        Vec3 vec3 = this.m_20184_();
        double d1 = vec3.f_82479_;
        double d3 = vec3.f_82480_;
        double d5 = vec3.f_82481_;
        if (Math.abs(vec3.f_82479_) < 0.003) {
            d1 = 0.0;
        }
        if (Math.abs(vec3.f_82480_) < 0.003) {
            d3 = 0.0;
        }
        if (Math.abs(vec3.f_82481_) < 0.003) {
            d5 = 0.0;
        }
        this.m_20334_(d1, d3, d5);
        this.xxa *= 0.98f;
        this.zza *= 0.98f;
        this.travel(new Vec3((double)this.xxa, (double)this.yya, (double)this.zza));
    }

    public void rotAnim() {
        while (this.m_146908_() - this.f_19859_ < -180.0f) {
            this.f_19859_ -= 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ >= 180.0f) {
            this.f_19859_ += 360.0f;
        }
    }

    public void m_6453_(double p_20977_, double p_20978_, double p_20979_, float p_20980_, float p_20981_, int p_20982_, boolean p_20983_) {
        this.lerpX = p_20977_;
        this.lerpY = p_20978_;
        this.lerpZ = p_20979_;
        this.lerpYRot = p_20980_;
        this.lerpXRot = p_20981_;
        this.lerpSteps = p_20982_;
    }

    private void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d2 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d4 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d6 = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d6 / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d0, d2, d4);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    public void travel(Vec3 p_21280_) {
        if (this.m_6109_()) {
            boolean flag;
            double d0 = 0.08;
            boolean bl = flag = this.m_20184_().f_82480_ <= 0.0;
            if (this.m_20069_()) {
                double d8 = this.m_20186_();
                float f5 = this.m_20142_() ? 0.9f : this.getWaterSlowDown();
                float f6 = 0.02f;
                this.m_19920_(f6, p_21280_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                Vec3 vec36 = this.m_20184_();
                if (this.f_19862_) {
                    vec36 = new Vec3(vec36.f_82479_, 0.2, vec36.f_82481_);
                }
                this.m_20256_(vec36.m_82542_((double)f5, (double)0.8f, (double)f5));
                Vec3 vec32 = this.getFluidFallingAdjustedMovement(d0, flag, this.m_20184_());
                this.m_20256_(vec32);
                if (this.f_19862_ && this.m_20229_(vec32.f_82479_, vec32.f_82480_ + (double)0.6f - this.m_20186_() + d8, vec32.f_82481_)) {
                    this.m_20334_(vec32.f_82479_, 0.3f, vec32.f_82481_);
                }
            } else if (this.m_20077_()) {
                double d7 = this.m_20186_();
                this.m_19920_(0.02f, p_21280_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                if (this.m_204036_(FluidTags.f_13132_) <= this.m_20204_()) {
                    this.m_20256_(this.m_20184_().m_82542_(0.5, (double)0.8f, 0.5));
                    Vec3 vec33 = this.getFluidFallingAdjustedMovement(d0, flag, this.m_20184_());
                    this.m_20256_(vec33);
                } else {
                    this.m_20256_(this.m_20184_().m_82490_(0.5));
                }
                if (!this.m_20068_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -d0 / 4.0, 0.0));
                }
                Vec3 vec34 = this.m_20184_();
                if (this.f_19862_ && this.m_20229_(vec34.f_82479_, vec34.f_82480_ + (double)0.6f - this.m_20186_() + d7, vec34.f_82481_)) {
                    this.m_20334_(vec34.f_82479_, 0.3f, vec34.f_82481_);
                }
            } else {
                BlockPos blockpos = this.m_20099_();
                float f3 = this.f_19853_.m_8055_(this.m_20099_()).getFriction((LevelReader)this.f_19853_, this.m_20099_(), (Entity)this);
                float f4 = this.f_19861_ ? f3 * 0.91f : 0.91f;
                Vec3 vec35 = this.handleRelativeFrictionAndCalculateMovement(p_21280_, f3);
                double d2 = vec35.f_82480_;
                if (this.f_19853_.f_46443_ && !this.f_19853_.m_46805_(blockpos)) {
                    d2 = this.m_20186_() > (double)this.f_19853_.m_141937_() ? -0.1 : 0.0;
                } else if (!this.m_20068_()) {
                    d2 -= d0;
                }
                if (this.shouldDiscardFriction()) {
                    this.m_20334_(vec35.f_82479_, d2, vec35.f_82481_);
                } else {
                    this.m_20334_(vec35.f_82479_ * (double)f4, d2 * (double)0.98f, vec35.f_82481_ * (double)f4);
                }
            }
        }
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float p_21320_) {
        this.speed = p_21320_;
    }

    protected float getWaterSlowDown() {
        return 0.8f;
    }

    public Vec3 getFluidFallingAdjustedMovement(double p_20995_, boolean p_20996_, Vec3 p_20997_) {
        if (!this.m_20068_() && !this.m_20142_()) {
            double d0 = p_20996_ && Math.abs(p_20997_.f_82480_ - 0.005) >= 0.003 && Math.abs(p_20997_.f_82480_ - p_20995_ / 16.0) < 0.003 ? -0.003 : p_20997_.f_82480_ - p_20995_ / 16.0;
            return new Vec3(p_20997_.f_82479_, d0, p_20997_.f_82481_);
        }
        return p_20997_;
    }

    public float getFrictionInfluencedSpeed(float p_21331_) {
        return this.getSpeed() * (0.21600002f / (p_21331_ * p_21331_ * p_21331_));
    }

    public Vec3 handleRelativeFrictionAndCalculateMovement(Vec3 p_21075_, float p_21076_) {
        this.m_19920_(this.getFrictionInfluencedSpeed(p_21076_), p_21075_);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        Vec3 vec3 = this.m_20184_();
        if (this.f_19862_ && this.m_146900_().m_60713_(Blocks.f_152499_) && PowderSnowBlock.m_154255_((Entity)this)) {
            vec3 = new Vec3(vec3.f_82479_, 0.2, vec3.f_82481_);
        }
        return vec3;
    }

    public boolean shouldDiscardFriction() {
        return this.discardFriction;
    }

    public void setDiscardFriction(boolean p_147245_) {
        this.discardFriction = p_147245_;
    }
}

