/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.entities;

import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrscauthd.beyond_earth.common.registries.EntityRegistry;
import net.mrscauthd.beyond_earth.common.registries.ItemsRegistry;

public class IceSpitEntity
extends AbstractArrow
implements ItemSupplier {
    public IceSpitEntity(EntityType<? extends AbstractArrow> type, Level world) {
        super(type, world);
    }

    public IceSpitEntity(EntityType<? extends AbstractArrow> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ItemsRegistry.ICE_SHARD.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)ItemsRegistry.ICE_SHARD.get(), 1);
    }

    protected SoundEvent m_7239_() {
        return null;
    }

    protected void m_7761_(LivingEntity p_36744_) {
        super.m_7761_(p_36744_);
        p_36744_.m_21317_(p_36744_.m_21234_() - 1);
    }

    public void m_8119_() {
        super.m_8119_();
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        Vec3 vec = this.m_20184_();
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123764_, x - vec.f_82479_, y - vec.f_82480_, z - vec.f_82481_, 0.0, 0.001, 0.0);
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123754_, x - vec.f_82479_, y - vec.f_82480_, z - vec.f_82481_, 0.0, 0.001, 0.0);
        if (this.f_36703_ && !this.f_19853_.f_46443_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public static IceSpitEntity shoot(LivingEntity entity, LivingEntity target, int damage) {
        IceSpitEntity entityArrow = new IceSpitEntity((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.ICE_SPIT_ENTITY.get()), entity, entity.f_19853_);
        double d0 = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double d1 = target.m_20185_() - entity.m_20185_();
        double d3 = target.m_20189_() - entity.m_20189_();
        entityArrow.m_6686_(d1, d0 - entityArrow.m_20186_() + Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f, d3, 1.4f, 12.0f);
        entityArrow.m_20225_(true);
        entityArrow.m_36781_(damage);
        entityArrow.m_36735_(1);
        entityArrow.m_36762_(false);
        entity.f_19853_.m_7967_((Entity)entityArrow);
        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.HOSTILE, 1.0f, 1.0f / (new Random().nextFloat() * 0.5f + 1.0f));
        return entityArrow;
    }
}

