/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.events;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.mrscauthd.beyond_earth.common.data.PlanetData;
import net.mrscauthd.beyond_earth.common.entities.LanderEntity;
import net.mrscauthd.beyond_earth.common.events.forge.EntityTickEvent;
import net.mrscauthd.beyond_earth.common.events.forge.FireworkRocketUseEvent;
import net.mrscauthd.beyond_earth.common.events.forge.ItemEntityTickAtEndEvent;
import net.mrscauthd.beyond_earth.common.events.forge.LivingSprintingEvent;
import net.mrscauthd.beyond_earth.common.events.forge.TryStartFallFlyingEvent;
import net.mrscauthd.beyond_earth.common.registries.LevelRegistry;
import net.mrscauthd.beyond_earth.common.registries.NetworkRegistry;
import net.mrscauthd.beyond_earth.common.registries.SoundRegistry;
import net.mrscauthd.beyond_earth.common.util.EntityGravity;
import net.mrscauthd.beyond_earth.common.util.ItemGravity;
import net.mrscauthd.beyond_earth.common.util.Methods;
import net.mrscauthd.beyond_earth.common.util.OxygenSystem;
import net.mrscauthd.beyond_earth.common.util.Planets;

@Mod.EventBusSubscriber(modid="beyond_earth")
public class Events {
    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Player player = event.player;
            Methods.openPlanetGui(player);
            Methods.setJetSuitHoverPose(player);
            Methods.disableFlyAntiCheat(player, player.getPersistentData().m_128471_("beyond_earth:planet_selection_menu_open"));
        }
    }

    @SubscribeEvent
    public static void livingEntityTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        Level level = livingEntity.f_19853_;
        Methods.dropOffHandVehicle(livingEntity);
        OxygenSystem.entityOxygen(livingEntity, level);
        Methods.venusRain(livingEntity, LevelRegistry.VENUS);
        Methods.planetFire(livingEntity, LevelRegistry.VENUS);
        Methods.planetFire(livingEntity, LevelRegistry.MERCURY);
    }

    @SubscribeEvent
    public static void itemEntityEndTick(ItemEntityTickAtEndEvent event) {
        ItemEntity itemEntity = event.getEntity();
        Level level = itemEntity.f_19853_;
        ItemGravity.setGravities(itemEntity, level);
    }

    @SubscribeEvent
    public static void entityTick(EntityTickEvent event) {
        Entity entity = event.getEntity();
        Level level = entity.f_19853_;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            double artificialGravity = EntityGravity.getArtificalGravityModifier(level, entity.m_20183_());
            Attribute attribute = (Attribute)ForgeMod.ENTITY_GRAVITY.get();
            AttributeInstance attributeInstance = living.m_21051_(attribute);
            AttributeModifier modifier = attributeInstance.m_22111_(EntityGravity.ARTIFICIAL_GRAVITY_ID);
            if (modifier != null && modifier.m_22218_() != (artificialGravity *= attribute.m_22082_())) {
                attributeInstance.m_22120_(EntityGravity.ARTIFICIAL_GRAVITY_ID);
                modifier = null;
            }
            if (modifier == null) {
                modifier = new AttributeModifier(EntityGravity.ARTIFICIAL_GRAVITY_ID, "beyond_earth:artificial_grabity", artificialGravity, AttributeModifier.Operation.ADDITION);
                attributeInstance.m_22118_(modifier);
            }
        }
        if (entity.m_20202_() instanceof LanderEntity) {
            Methods.entityFallWithLanderToPlanet(entity, level);
        }
        if (!(entity.m_20202_() instanceof LanderEntity)) {
            if (entity instanceof LanderEntity && entity.m_20160_()) {
                return;
            }
            Methods.entityFallToPlanet(entity, level);
        }
    }

    @SubscribeEvent
    public static void worldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Level level = event.level;
            if (Planets.LEVELS_WITHOUT_RAIN.contains(level.m_46472_())) {
                level.f_46440_ = 0.0f;
                level.f_46438_ = 0.0f;
            }
            Planets.updatePlanetLocations(level);
        }
    }

    @SubscribeEvent
    public static void livingEntityAttack(LivingAttackEvent event) {
        if (!event.getSource().m_19384_()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!Methods.isLivingInNetheriteSpaceSuit(entity) && !Methods.isLivingInJetSuit(entity)) {
            return;
        }
        entity.m_7311_(0);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void projectileImpact(ProjectileImpactEvent event) {
        if (event.getRayTraceResult().m_6662_() != HitResult.Type.ENTITY) {
            return;
        }
        Entity entity = ((EntityHitResult)event.getRayTraceResult()).m_82443_();
        if (Methods.isVehicle(entity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void livingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.getPersistentData().m_128471_("beyond_earth:planet_selection_menu_open")) {
                player.m_6915_();
                Methods.resetPlanetSelectionMenuNeededNbt(player);
                player.m_20242_(false);
            }
        }
        if (Methods.isLivingInJetSuit(entity) && entity.m_21255_() && event.getSource() == DamageSource.f_19316_ && !entity.f_19853_.f_46443_) {
            entity.f_19853_.m_46518_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 10.0f, true, Explosion.BlockInteraction.BREAK);
        }
    }

    @SubscribeEvent
    public static void livingFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        Attribute attribute = (Attribute)ForgeMod.ENTITY_GRAVITY.get();
        double gravity = entity.m_21133_(attribute) / attribute.m_22082_();
        float scale = (float)(gravity - 1.0);
        scale *= 10.0f * scale;
        event.setDistance(event.getDistance() - scale);
    }

    @SubscribeEvent
    public static void entityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        Level level = event.getLevel();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            EntityGravity.setGravities(livingEntity, level);
        }
    }

    @SubscribeEvent
    public static void fireworkRocketUse(FireworkRocketUseEvent event) {
        Player player = event.getEntity();
        if (Methods.isLivingInJetSuit((LivingEntity)player) && player.m_21255_()) {
            event.getCallbackInfoReturnable().setReturnValue((Object)InteractionResultHolder.m_19098_((Object)player.m_21120_(event.getInteractionHand())));
        }
    }

    @SubscribeEvent
    public static void tryStartFallFlying(TryStartFallFlyingEvent event) {
        Player player = event.getEntity();
        if (Methods.isLivingInJetSuit((LivingEntity)player) && player.m_21255_()) {
            if (!player.f_19853_.f_46443_) {
                event.getCallbackInfoReturnable().setReturnValue((Object)false);
            } else {
                event.getCallbackInfoReturnable().setReturnValue((Object)true);
            }
        }
        if (Methods.isLivingInJetSuit((LivingEntity)player) && !player.m_21255_() && player.m_20142_()) {
            player.f_19853_.m_6269_(null, (Entity)player, (SoundEvent)SoundRegistry.SONIC_BOOM_SOUND.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void livingSprinting(LivingSprintingEvent event) {
        LivingEntity entity = event.getEntity();
        if (Methods.isLivingInJetSuit(entity) && event.getSprinting() && entity.m_21255_()) {
            entity.f_19853_.m_6269_(null, (Entity)entity, (SoundEvent)SoundRegistry.SONIC_BOOM_SOUND.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onDataSync(OnDatapackSyncEvent event) {
        PlanetData data = new PlanetData();
        Planets.getStarsList().forEach(s -> data.stars.add(new PlanetData.StarEntry((Planets.StarSystem)s)));
        PlanetData.PlanetDataHandler holder = new PlanetData.PlanetDataHandler();
        holder.data = data;
        if (event.getPlayer() != null) {
            NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> event.getPlayer()), (Object)holder);
        }
    }
}

