/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.fluids.types;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Vector3f;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OilFluidType
extends FluidType {
    public OilFluidType(FluidType.Properties properties) {
        super(properties);
    }

    public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
        boolean flag = entity.m_20184_().f_82480_ <= 0.0;
        double d8 = entity.m_20186_();
        entity.m_19920_(0.02f, movementVector);
        entity.m_6478_(MoverType.SELF, entity.m_20184_());
        if (entity.getFluidTypeHeight((FluidType)this) <= entity.m_20204_()) {
            entity.m_20256_(entity.m_20184_().m_82542_(0.5, (double)0.8f, 0.5));
            Vec3 vec33 = entity.m_20994_(gravity, flag, entity.m_20184_());
            entity.m_20256_(vec33);
        } else {
            entity.m_20256_(entity.m_20184_().m_82490_(0.5));
        }
        if (!entity.m_20068_()) {
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, -gravity / 4.0, 0.0));
        }
        Vec3 vec34 = entity.m_20184_();
        if (entity.f_19862_ && entity.m_20229_(vec34.f_82479_, vec34.f_82480_ + (double)0.6f - entity.m_20186_() + d8, vec34.f_82481_)) {
            entity.m_20334_(vec34.f_82479_, (double)0.3f, vec34.f_82481_);
        }
        return true;
    }

    public void setItemMovement(ItemEntity entity) {
        Vec3 vec3 = entity.m_20184_();
        entity.m_20334_(vec3.f_82479_ * (double)0.95f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.95f);
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){
            private static final ResourceLocation UNDERWATER_LOCATION = new ResourceLocation("beyond_earth", "textures/block/fluids/under_oil.png");
            private static final ResourceLocation WATER_STILL = new ResourceLocation("beyond_earth", "block/fluids/oil_still");
            private static final ResourceLocation WATER_FLOW = new ResourceLocation("beyond_earth", "block/fluids/oil_flow");
            private static final ResourceLocation WATER_OVERLAY = new ResourceLocation("beyond_earth", "block/fluids/oil_overlay");

            public ResourceLocation getStillTexture() {
                return WATER_STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return WATER_FLOW;
            }

            @Nullable
            public ResourceLocation getOverlayTexture() {
                return WATER_OVERLAY;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return UNDERWATER_LOCATION;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return new Vector3f(0.09f, 0.09f, 0.09f);
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                nearDistance = -8.0f;
                farDistance = 10.0f;
                shape = FogShape.CYLINDER;
                RenderSystem.m_157445_((float)nearDistance);
                RenderSystem.m_157443_((float)farDistance);
                RenderSystem.m_202160_((FogShape)shape);
            }
        });
    }
}

