/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.items;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.mrscauthd.beyond_earth.common.blocks.RocketLaunchPad;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.GaugeTextHelper;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.GaugeValueHelper;
import net.mrscauthd.beyond_earth.common.entities.IRocketEntity;
import net.mrscauthd.beyond_earth.common.entities.RocketTier1Entity;
import net.mrscauthd.beyond_earth.common.events.forge.PlaceRocketEvent;
import net.mrscauthd.beyond_earth.common.items.VehicleItem;

public abstract class IRocketItem
extends VehicleItem {
    public static final String FUEL_TAG = "beyond_earth:fuel";
    public static final String BUCKET_TAG = "beyond_earth:buckets";

    public IRocketItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        InteractionHand hand = context.m_43724_();
        ItemStack itemStack = context.m_43722_();
        if (level.m_5776_()) {
            return InteractionResult.PASS;
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (state.m_60734_() instanceof RocketLaunchPad && ((Boolean)state.m_61143_((Property)RocketLaunchPad.STAGE)).booleanValue()) {
            BlockPlaceContext blockplacecontext = new BlockPlaceContext(context);
            BlockPos blockpos = blockplacecontext.m_8083_();
            Vec3 vec3 = Vec3.m_82514_((Vec3i)blockpos, (double)this.getRocketPlaceHigh());
            AABB aabb = this.getEntityType().m_20680_().m_20384_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_());
            if (level.m_45772_(aabb)) {
                AABB scanAbove = new AABB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
                List entities = player.m_20193_().m_45976_(Entity.class, scanAbove);
                if (entities.isEmpty()) {
                    IRocketEntity rocket = this.getRocket(context.m_43725_());
                    rocket.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
                    double d0 = IRocketItem.getYOffset((LevelReader)level, pos, true, rocket.m_20191_());
                    float f = (float)Mth.m_14143_((float)((Mth.m_14177_((float)(context.m_7074_() - 180.0f)) + 45.0f) / 90.0f)) * 90.0f;
                    rocket.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + d0, (double)pos.m_123343_() + 0.5, f, 0.0f);
                    rocket.f_19859_ = rocket.m_146908_();
                    level.m_7967_((Entity)rocket);
                    rocket.m_20088_().m_135381_(RocketTier1Entity.FUEL, (Object)itemStack.m_41784_().m_128451_(FUEL_TAG));
                    MinecraftForge.EVENT_BUS.post((Event)new PlaceRocketEvent(rocket, context));
                    if (!player.m_150110_().f_35937_) {
                        player.m_21008_(hand, ItemStack.f_41583_);
                    }
                    this.rocketPlaceSound(pos, level);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6225_(context);
    }

    public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, level, list, flag);
        int fuel = itemstack.m_41784_().m_128451_(FUEL_TAG);
        int capacity = this.getFuelBuckets() * 1000;
        list.add((Component)GaugeTextHelper.buildFuelStorageTooltip(GaugeValueHelper.getFuel(fuel, capacity), ChatFormatting.GRAY));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return IRocketItem.this.getRenderer();
            }
        });
    }

    public void m_6787_(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        super.m_6787_(p_41391_, p_41392_);
        if (this.m_220152_(p_41391_)) {
            ItemStack itemStack = new ItemStack((ItemLike)this);
            itemStack.m_41784_().m_128405_(FUEL_TAG, this.getFuelBuckets() * 1000);
            p_41392_.add((Object)itemStack);
        }
    }

    public float getRocketPlaceHigh() {
        return -0.6f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract BlockEntityWithoutLevelRenderer getRenderer();

    public abstract EntityType<? extends IRocketEntity> getEntityType();

    public abstract IRocketEntity getRocket(Level var1);

    public abstract int getFuelBuckets();

    public void rocketPlaceSound(BlockPos pos, Level world) {
        world.m_5594_(null, pos, SoundEvents.f_12442_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

