/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.items;

import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrscauthd.beyond_earth.client.registries.ItemRendererRegistry;
import net.mrscauthd.beyond_earth.common.config.Config;
import net.mrscauthd.beyond_earth.common.entities.IRocketEntity;
import net.mrscauthd.beyond_earth.common.entities.RocketTier4Entity;
import net.mrscauthd.beyond_earth.common.items.IRocketItem;
import net.mrscauthd.beyond_earth.common.registries.EntityRegistry;

public class Tier4RocketItem
extends IRocketItem {
    public Tier4RocketItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BlockEntityWithoutLevelRenderer getRenderer() {
        return ItemRendererRegistry.ROCKET_TIER_4_ITEM_RENDERER;
    }

    @Override
    public EntityType<? extends IRocketEntity> getEntityType() {
        return (EntityType)EntityRegistry.TIER_4_ROCKET.get();
    }

    @Override
    public IRocketEntity getRocket(Level level) {
        return new RocketTier4Entity((EntityType)EntityRegistry.TIER_4_ROCKET.get(), level);
    }

    @Override
    public int getFuelBuckets() {
        return (Integer)Config.ROCKET_TIER_4_FUEL_BUCKETS.get();
    }
}

