/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.mrscauthd.beyond_earth.common.data.recipes.BeyondEarthRecipeType;
import net.mrscauthd.beyond_earth.common.data.recipes.CompressingRecipe;
import net.mrscauthd.beyond_earth.common.data.recipes.FuelRefiningRecipe;
import net.mrscauthd.beyond_earth.common.data.recipes.GeneratingRecipe;
import net.mrscauthd.beyond_earth.common.data.recipes.ItemStackToItemStackRecipeType;
import net.mrscauthd.beyond_earth.common.data.recipes.OxygenBubbleDistributorRecipe;
import net.mrscauthd.beyond_earth.common.data.recipes.OxygenLoaderRecipe;
import net.mrscauthd.beyond_earth.common.data.recipes.WorkbenchingRecipe;
import net.mrscauthd.beyond_earth.common.jei.categories.CoalGenerator;
import net.mrscauthd.beyond_earth.common.jei.categories.Compressor;
import net.mrscauthd.beyond_earth.common.jei.categories.FuelRefining;
import net.mrscauthd.beyond_earth.common.jei.categories.NASAWorkbench;
import net.mrscauthd.beyond_earth.common.jei.categories.OxygenBubbleLoader;
import net.mrscauthd.beyond_earth.common.jei.categories.OxygenLoader;
import net.mrscauthd.beyond_earth.common.jei.helper.EnergyIngredient;
import net.mrscauthd.beyond_earth.common.jei.helper.O2Ingredient;
import net.mrscauthd.beyond_earth.common.registries.RecipeTypeRegistry;

@JeiPlugin
public class Jei
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("beyond_earth", "jei");
    public static final IIngredientType<O2Ingredient> O2_INGREDIENT_TYPE = () -> O2Ingredient.class;
    public static final IIngredientType<EnergyIngredient> FE_INGREDIENT_TYPE = () -> EnergyIngredient.class;
    public static final RecipeType<GeneratingRecipe> COAL_TYPE = RecipeType.create((String)"beyond_earth", (String)"coal_generator", GeneratingRecipe.class);
    public static final RecipeType<CompressingRecipe> COMPRESS_TYPE = RecipeType.create((String)"beyond_earth", (String)"compressor", CompressingRecipe.class);
    public static final RecipeType<FuelRefiningRecipe> REFINE_TYPE = RecipeType.create((String)"beyond_earth", (String)"fuel_refining", FuelRefiningRecipe.class);
    public static final RecipeType<OxygenLoaderRecipe> OXYGEN_LOADER_TYPE = RecipeType.create((String)"beyond_earth", (String)"oxygen_loading", OxygenLoaderRecipe.class);
    public static final RecipeType<OxygenBubbleDistributorRecipe> OXYGEN_BUBBLE_TYPE = RecipeType.create((String)"beyond_earth", (String)"oxygen_bubble_distributing", OxygenBubbleDistributorRecipe.class);
    public static final RecipeType<WorkbenchingRecipe> WORKBENCH_TYPE = RecipeType.create((String)"beyond_earth", (String)"nasa_workbenching", WorkbenchingRecipe.class);

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration register) {
        IGuiHelper helper = register.getJeiHelpers().getGuiHelper();
        register.addRecipeCategories(new IRecipeCategory[]{new CoalGenerator(helper)});
        register.addRecipeCategories(new IRecipeCategory[]{new Compressor(helper)});
        register.addRecipeCategories(new IRecipeCategory[]{new FuelRefining(helper)});
        register.addRecipeCategories(new IRecipeCategory[]{new OxygenLoader(helper)});
        register.addRecipeCategories(new IRecipeCategory[]{new OxygenBubbleLoader(helper)});
        register.addRecipeCategories(new IRecipeCategory[]{new NASAWorkbench(helper)});
    }

    public void registerIngredients(IModIngredientRegistration register) {
        register.register(O2_INGREDIENT_TYPE, O2Ingredient.getIngredients(), (IIngredientHelper)O2Ingredient.INSTANCE, (IIngredientRenderer)new O2Ingredient.DummyRenderer());
        register.register(FE_INGREDIENT_TYPE, EnergyIngredient.getIngredients(), (IIngredientHelper)EnergyIngredient.INSTANCE, (IIngredientRenderer)new EnergyIngredient.DummyRenderer());
    }

    public void registerRecipes(IRecipeRegistration register) {
        register.addRecipes(COAL_TYPE, ((BeyondEarthRecipeType)RecipeTypeRegistry.COAL_GENERATING.get()).getRecipes((Level)Minecraft.m_91087_().f_91073_));
        register.addRecipes(COMPRESS_TYPE, ((ItemStackToItemStackRecipeType)RecipeTypeRegistry.COMPRESSING.get()).getRecipes((Level)Minecraft.m_91087_().f_91073_));
        register.addRecipes(REFINE_TYPE, ((BeyondEarthRecipeType)RecipeTypeRegistry.FUEL_REFINING.get()).getRecipes((Level)Minecraft.m_91087_().f_91073_));
        register.addRecipes(OXYGEN_LOADER_TYPE, ((BeyondEarthRecipeType)RecipeTypeRegistry.OXYGEN_LOADING.get()).getRecipes((Level)Minecraft.m_91087_().f_91073_));
        register.addRecipes(OXYGEN_BUBBLE_TYPE, ((BeyondEarthRecipeType)RecipeTypeRegistry.OXYGEN_BUBBLE_DISTRIBUTING.get()).getRecipes((Level)Minecraft.m_91087_().f_91073_));
        register.addRecipes(WORKBENCH_TYPE, ((BeyondEarthRecipeType)RecipeTypeRegistry.NASA_WORKBENCHING.get()).getRecipes((Level)Minecraft.m_91087_().f_91073_));
    }
}

