/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.jei.helper;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.common.util.TickTimer;
import net.minecraftforge.fluids.FluidStack;
import net.mrscauthd.beyond_earth.client.util.GuiHelper;

public class DrawableFluidAnimated
implements IDrawableAnimated {
    private FluidStack fluid;
    private final ITickTimer tickTimer;
    boolean drain;
    boolean O2;

    public DrawableFluidAnimated(int timer, boolean drain, FluidStack fluid) {
        this(timer, drain, fluid, false);
    }

    public DrawableFluidAnimated(int timer, boolean drain, FluidStack fluid, boolean O2) {
        this.drain = drain;
        this.tickTimer = new TickTimer(timer, 46, drain);
        this.fluid = fluid;
        this.O2 = O2;
    }

    public int getWidth() {
        return 12;
    }

    public int getHeight() {
        return 46;
    }

    public void setFluid(FluidStack stack) {
        this.fluid = stack;
    }

    public void draw(PoseStack poseStack, int xOffset, int yOffset) {
        int fluidY;
        int animationValue = this.tickTimer.getValue();
        int n = fluidY = this.drain ? yOffset - animationValue + this.getHeight() : this.getHeight() - animationValue + yOffset;
        if (this.O2) {
            GuiHelper.drawOxygenTank(poseStack, xOffset, yOffset, (double)animationValue / 46.0);
        } else {
            GuiHelper.drawFluid(poseStack, xOffset, fluidY, 12, animationValue, this.fluid);
            GuiHelper.drawFluidTankOverlay(poseStack, xOffset, yOffset);
        }
    }
}

