/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.jei.helper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.fluids.FluidStack;
import net.mrscauthd.beyond_earth.common.jei.Jei;
import net.mrscauthd.beyond_earth.common.jei.helper.DrawableFluidAnimated;
import org.jetbrains.annotations.Nullable;

public class O2Ingredient
implements IIngredientHelper<O2Ingredient>,
IIngredientRenderer<O2Ingredient> {
    public static final O2Ingredient INSTANCE = new O2Ingredient();
    public static final O2Ingredient INTANK = new O2Ingredient();
    public static final O2Ingredient OUTTANK = new O2Ingredient();
    static final List<O2Ingredient> ALL = Lists.newArrayList((Object[])new O2Ingredient[]{INTANK, OUTTANK});
    private final LoadingCache<Integer, DrawableFluidAnimated> cachedTank = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, DrawableFluidAnimated>(){

        public DrawableFluidAnimated load(Integer stack) {
            return new DrawableFluidAnimated(100 * stack, O2Ingredient.this == INTANK, FluidStack.EMPTY, true);
        }
    });
    private int amount = 0;

    public static Collection<O2Ingredient> getIngredients() {
        return ALL;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public void render(PoseStack stack, O2Ingredient ingredient) {
        int amount = Math.max(ingredient.amount, 1);
        DrawableFluidAnimated fluid = (DrawableFluidAnimated)this.cachedTank.getUnchecked((Object)amount);
        fluid.draw(stack);
    }

    public List<Component> getTooltip(O2Ingredient ingredient, TooltipFlag tooltipFlag) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        try {
            String displayName = this.getDisplayName(ingredient);
            tooltip.add((Component)Component.m_237113_((String)displayName));
            long amount = ingredient.amount;
            long milliBuckets = amount * 1000L / 1000L;
            NumberFormat nf = NumberFormat.getIntegerInstance();
            MutableComponent amountString = Component.m_237110_((String)"jei.tooltip.liquid.amount", (Object[])new Object[]{nf.format(milliBuckets)});
            tooltip.add((Component)amountString.m_130940_(ChatFormatting.GRAY));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return tooltip;
    }

    public int getWidth() {
        return 12;
    }

    public int getHeight() {
        return 46;
    }

    public IIngredientType<O2Ingredient> getIngredientType() {
        return Jei.O2_INGREDIENT_TYPE;
    }

    public String getDisplayName(O2Ingredient ingredient) {
        return I18n.m_118938_((String)"general.beyond_earth.oxygen", (Object[])new Object[0]);
    }

    public String getUniqueId(O2Ingredient ingredient, UidContext context) {
        return "beyond_earth:oxygen";
    }

    public ResourceLocation getResourceLocation(O2Ingredient ingredient) {
        return new ResourceLocation("beyond_earth:oxygen");
    }

    public O2Ingredient copyIngredient(O2Ingredient ingredient) {
        return ingredient;
    }

    public String getErrorInfo(@Nullable O2Ingredient ingredient) {
        return "error with oxygen?";
    }

    public static final class DummyRenderer
    implements IIngredientRenderer<O2Ingredient> {
        public void render(PoseStack stack, O2Ingredient ingredient) {
        }

        public List<Component> getTooltip(O2Ingredient ingredient, TooltipFlag tooltipFlag) {
            return Lists.newArrayList();
        }
    }
}

