/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.menus.nasaworkbench;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.IContainerFactory;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.NASAWorkbenchBlockEntity;
import net.mrscauthd.beyond_earth.common.data.recipes.RocketPart;
import net.mrscauthd.beyond_earth.common.data.recipes.WorkbenchingRecipe;
import net.mrscauthd.beyond_earth.common.menus.helper.MenuHelper;
import net.mrscauthd.beyond_earth.common.menus.nasaworkbench.GridPlacer;
import net.mrscauthd.beyond_earth.common.menus.nasaworkbench.NasaWorkbenchResultSlot;
import net.mrscauthd.beyond_earth.common.menus.nasaworkbench.RocketPartGridPlacer;
import net.mrscauthd.beyond_earth.common.menus.nasaworkbench.RocketPartsItemHandler;
import net.mrscauthd.beyond_earth.common.registries.ContainerRegistry;
import net.mrscauthd.beyond_earth.common.registries.RocketPartsRegistry;

public class NasaWorkbenchMenu {

    public static class GuiContainer
    extends AbstractContainerMenu {
        private final NASAWorkbenchBlockEntity blockEntity;
        private final ResultContainer resultInventory;
        private final Slot resultSlot;
        private int partSlotStart = 0;
        private int partSlotEnd = 0;

        public GuiContainer(int id, Inventory inv, NASAWorkbenchBlockEntity blockEntity) {
            super((MenuType)ContainerRegistry.NASA_WORKBENCH_GUI.get(), id);
            this.blockEntity = blockEntity;
            this.resultInventory = new ResultContainer(){

                public ItemStack m_7407_(int p_40149_, int p_40150_) {
                    ItemStack stack = super.m_7407_(p_40149_, p_40150_);
                    this.onExtractResult(stack);
                    return stack;
                }

                public ItemStack m_8016_(int p_40160_) {
                    ItemStack stack = super.m_8016_(p_40160_);
                    this.onExtractResult(stack);
                    return stack;
                }
            };
            this.resultSlot = this.m_38897_(new NasaWorkbenchResultSlot((Container)this.resultInventory, 0, 128, 56, blockEntity));
            this.partSlotStart = this.f_38839_.size();
            RocketPartsItemHandler partsItemHandler = blockEntity.getPartsItemHandler();
            GridPlacer placer = new GridPlacer();
            int dx = 15;
            int dy = 2;
            RocketPartGridPlacer.placeContainer(40 + dx, 18 + dy, 1, placer::placeBottom, (RocketPart)RocketPartsRegistry.ROCKET_PART_NOSE.get(), partsItemHandler, x$0 -> this.m_38897_((Slot)x$0));
            RocketPartGridPlacer.placeContainer(31 + dx, 36 + dy, 2, placer::placeBottom, (RocketPart)RocketPartsRegistry.ROCKET_PART_BODY.get(), partsItemHandler, x$0 -> this.m_38897_((Slot)x$0));
            RocketPartGridPlacer.placeContainer(31 + dx, 90 + dy, 1, placer::placeRight, (RocketPart)RocketPartsRegistry.ROCKET_PART_TANK.get(), partsItemHandler, x$0 -> this.m_38897_((Slot)x$0));
            RocketPartGridPlacer.placeContainer(13 + dx, 90 + dy, 1, placer::placeBottom, (RocketPart)RocketPartsRegistry.ROCKET_PART_FIN_LEFT.get(), partsItemHandler, x$0 -> this.m_38897_((Slot)x$0));
            RocketPartGridPlacer.placeContainer(67 + dx, 90 + dy, 1, placer::placeBottom, (RocketPart)RocketPartsRegistry.ROCKET_PART_FIN_RIGHT.get(), partsItemHandler, x$0 -> this.m_38897_((Slot)x$0));
            RocketPartGridPlacer.placeContainer(40 + dx, 108 + dy, 1, placer::placeBottom, (RocketPart)RocketPartsRegistry.ROCKET_PART_ENGINE.get(), partsItemHandler, x$0 -> this.m_38897_((Slot)x$0));
            this.partSlotEnd = this.f_38839_.size();
            MenuHelper.createInventorySlots(inv, x$0 -> this.m_38897_((Slot)x$0), 8, 142);
        }

        private void onExtractResult(ItemStack stack) {
            NASAWorkbenchBlockEntity blockEntity = this.getBlockEntity();
            if (!stack.m_41619_() && blockEntity.cacheRecipes() != null) {
                blockEntity.consumeIngredient();
            }
        }

        public void m_38946_() {
            super.m_38946_();
            WorkbenchingRecipe recipe = this.getBlockEntity().cacheRecipes();
            this.resultSlot.m_5852_(recipe != null ? recipe.getOutput() : ItemStack.f_41583_);
        }

        public boolean m_6875_(Player p_38874_) {
            return !this.getBlockEntity().m_58901_();
        }

        public ItemStack m_7648_(Player playerIn, int slotNumber) {
            if (this.partSlotStart <= slotNumber && slotNumber < this.partSlotEnd) {
                return MenuHelper.transferStackInSlot((AbstractContainerMenu)this, playerIn, slotNumber, slotNumber - this.partSlotStart, (Container)this.getBlockEntity(), (x$0, x$1, x$2, x$3) -> this.m_38903_(x$0, x$1, x$2, x$3));
            }
            if (slotNumber == this.resultSlot.f_40219_) {
                Slot slot = this.m_38853_(slotNumber);
                ItemStack prev = slot.m_7993_().m_41777_();
                ItemStack itemStack = MenuHelper.transferStackInSlot(this, playerIn, slotNumber, (Container)this.getBlockEntity(), (x$0, x$1, x$2, x$3) -> this.m_38903_(x$0, x$1, x$2, x$3));
                if (slotNumber == this.resultSlot.f_40219_) {
                    ItemStack next = slot.m_7993_().m_41777_();
                    if (!prev.m_41619_()) {
                        int nextSize;
                        int n = nextSize = next.m_41619_() ? 0 : next.m_41613_();
                        if (nextSize > 0) {
                            playerIn.m_36176_(next, false);
                            slot.m_5852_(ItemStack.f_41583_);
                        }
                    }
                    this.onExtractResult(prev);
                }
                return itemStack;
            }
            return MenuHelper.transferStackInSlot(this, playerIn, slotNumber, (Container)this.getBlockEntity(), (x$0, x$1, x$2, x$3) -> this.m_38903_(x$0, x$1, x$2, x$3));
        }

        public NASAWorkbenchBlockEntity getBlockEntity() {
            return this.blockEntity;
        }

        public ResultContainer getResultInventory() {
            return this.resultInventory;
        }

        public Slot getResultSlot() {
            return this.resultSlot;
        }
    }

    public static class GuiContainerFactory
    implements IContainerFactory<GuiContainer> {
        public GuiContainer create(int id, Inventory inv, FriendlyByteBuf extraData) {
            BlockPos pos = extraData.m_130135_();
            NASAWorkbenchBlockEntity blockEntity = (NASAWorkbenchBlockEntity)inv.f_35978_.f_19853_.m_7702_(pos);
            return new GuiContainer(id, inv, blockEntity);
        }
    }
}

