/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrscauthd.beyond_earth.common.blocks.CoalLanternBlock;
import net.mrscauthd.beyond_earth.common.blocks.WallCoalTorchBlock;
import net.mrscauthd.beyond_earth.common.capabilities.oxygen.ChunkOxygen;
import net.mrscauthd.beyond_earth.common.events.forge.BlockSetEvent;
import net.mrscauthd.beyond_earth.common.registries.BlockRegistry;
import net.mrscauthd.beyond_earth.common.registries.CapabilityRegistry;
import net.mrscauthd.beyond_earth.common.util.Methods;

@Mod.EventBusSubscriber(modid="beyond_earth")
public class FireSystemEvents {
    @SubscribeEvent
    public static void onBlockPlace(BlockSetEvent event) {
        Level level = (Level)event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        if (Methods.isSpaceLevelWithoutOxygen(level)) {
            boolean hasOxygen;
            BlockPos pos = event.getPos();
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            ChunkOxygen chunkO2 = (ChunkOxygen)((LevelChunk)level.m_46865_(pos)).getCapability(CapabilityRegistry.CHUNK_OXYGEN).orElse(null);
            int O2 = chunkO2.getO2(pos);
            boolean bl = hasOxygen = O2 > 10;
            if (!hasOxygen) {
                if (block == Blocks.f_50083_) {
                    level.m_46961_(pos, false);
                } else if (block == Blocks.f_50082_) {
                    level.m_7731_(pos, (BlockState)((Block)BlockRegistry.WALL_COAL_TORCH_BLOCK.get()).m_49966_().m_61124_((Property)WallCoalTorchBlock.FACING, (Comparable)((Direction)state.m_61143_((Property)WallTorchBlock.f_58119_))), 3);
                    FireSystemEvents.playFireExtinguish(pos, level);
                } else if (block == Blocks.f_50081_) {
                    level.m_7731_(pos, ((Block)BlockRegistry.COAL_TORCH_BLOCK.get()).m_49966_(), 3);
                    FireSystemEvents.playFireExtinguish(pos, level);
                } else if (block == Blocks.f_50681_) {
                    if (((Boolean)state.m_61143_((Property)LanternBlock.f_153459_)).booleanValue()) {
                        level.m_7731_(pos, (BlockState)((Block)BlockRegistry.COAL_LANTERN_BLOCK.get()).m_49966_().m_61124_((Property)CoalLanternBlock.f_153459_, (Comparable)Boolean.valueOf(true)), 3);
                    } else {
                        level.m_7731_(pos, ((Block)BlockRegistry.COAL_LANTERN_BLOCK.get()).m_49966_(), 3);
                    }
                    FireSystemEvents.playFireExtinguish(pos, level);
                } else if (block == Blocks.f_50683_ && ((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                    level.m_7731_(pos, (BlockState)level.m_8055_(pos).m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)), 3);
                    FireSystemEvents.playFireExtinguish(pos, level);
                }
            }
        }
    }

    public static void playFireExtinguish(BlockPos pos, Level level) {
        level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

