/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidUtil2 {
    public static final int BUCKET_SIZE = 1000;
    private static final Map<Item, Fluid> fluidCacheds = new HashMap<Item, Fluid>();

    public static Fluid findBucketFluid(Item item) {
        if (item == Items.f_41852_) {
            return Fluids.f_76191_;
        }
        return fluidCacheds.computeIfAbsent(item, FluidUtil2::findBucketFluidInternal);
    }

    private static Fluid findBucketFluidInternal(Item item) {
        return ForgeRegistries.FLUIDS.getValues().stream().filter(f -> f.m_7444_(f.m_76145_()) && f.m_6859_() == item).findFirst().orElse(Fluids.f_76191_);
    }

    public static boolean isSame(FluidStack left, Fluid right) {
        if (left.isEmpty()) {
            return right == Fluids.f_76191_;
        }
        if (right == Fluids.f_76191_) {
            return false;
        }
        return left.getFluid().m_6212_(right);
    }

    public static boolean isSame(FluidStack left, FluidStack right) {
        if (left.isEmpty()) {
            return right.isEmpty();
        }
        if (right.isEmpty()) {
            return false;
        }
        return left.getFluid().m_6212_(right.getFluid()) && FluidStack.areFluidStackTagsEqual((FluidStack)left, (FluidStack)right);
    }

    public static Fluid getFluid(FluidStack stack) {
        return Optional.ofNullable(stack).map(fs -> fs.getFluid()).orElse(Fluids.f_76191_);
    }

    public static IFluidHandlerItem getItemStackFluidHandler(ItemStack itemStack) {
        return (IFluidHandlerItem)itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
    }

    public static boolean canFill(ItemStack itemStack, Fluid fluid) {
        if (itemStack.m_41619_() || fluid == null) {
            return false;
        }
        if (itemStack.m_41720_() == Items.f_42446_) {
            return fluid.m_6859_() != Items.f_41852_;
        }
        IFluidHandlerItem handlerInItemStack = FluidUtil2.getItemStackFluidHandler(itemStack);
        return handlerInItemStack != null && handlerInItemStack.fill(new FluidStack(fluid, 1), IFluidHandler.FluidAction.SIMULATE) > 0;
    }

    public static boolean canDrain(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        if (FluidUtil2.findBucketFluid(itemStack.m_41720_()) != Fluids.f_76191_) {
            return true;
        }
        IFluidHandlerItem handlerInItemStack = FluidUtil2.getItemStackFluidHandler(itemStack);
        return handlerInItemStack != null && !handlerInItemStack.drain(1, IFluidHandler.FluidAction.SIMULATE).isEmpty();
    }

    public static boolean canDrain(ItemStack itemStack, Fluid fluid) {
        if (itemStack.m_41619_() || fluid == null) {
            return false;
        }
        if (itemStack.m_41720_() == fluid.m_6859_()) {
            return true;
        }
        IFluidHandlerItem handlerInItemStack = FluidUtil2.getItemStackFluidHandler(itemStack);
        return handlerInItemStack != null && !handlerInItemStack.drain(new FluidStack(fluid, 1), IFluidHandler.FluidAction.SIMULATE).isEmpty();
    }

    public static int getMaxCapacity(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return 0;
        }
        if (itemStack.m_41720_() == Items.f_42446_) {
            return 1000;
        }
        IFluidHandlerItem handlerInItemStack = FluidUtil2.getItemStackFluidHandler(itemStack);
        if (handlerInItemStack != null) {
            return FluidUtil2.getMaxCapacity((IFluidHandler)handlerInItemStack);
        }
        return 0;
    }

    public static int getMaxCapacity(IFluidHandler fluidHandler) {
        int capacity = 0;
        for (int i = 0; i < fluidHandler.getTanks(); ++i) {
            capacity = Math.max(capacity, fluidHandler.getTankCapacity(i));
        }
        return capacity;
    }

    public static ItemStack makeEmpty(ItemStack itemStack, Fluid fluid) {
        if (itemStack.m_41619_()) {
            return itemStack;
        }
        if (itemStack.m_41720_() == fluid.m_6859_()) {
            return new ItemStack((ItemLike)Items.f_42446_);
        }
        IFluidHandlerItem handlerInItemStack = FluidUtil2.getItemStackFluidHandler(itemStack);
        if (handlerInItemStack != null) {
            FluidStack fluidStack = new FluidStack(fluid, FluidUtil2.getMaxCapacity((IFluidHandler)handlerInItemStack));
            handlerInItemStack.drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        }
        return itemStack;
    }

    public static ItemStack makeFull(ItemStack itemStack, Fluid fluid) {
        if (itemStack.m_41619_()) {
            return itemStack;
        }
        if (itemStack.m_41720_() == Items.f_42446_ && fluid.m_6859_() != null) {
            return new ItemStack((ItemLike)fluid.m_6859_());
        }
        IFluidHandlerItem handlerInItemStack = FluidUtil2.getItemStackFluidHandler(itemStack);
        if (handlerInItemStack != null) {
            FluidStack fluidStack = new FluidStack(fluid, FluidUtil2.getMaxCapacity((IFluidHandler)handlerInItemStack));
            handlerInItemStack.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        }
        return itemStack;
    }

    public static List<FluidStack> getFluidStacks(ItemStack itemStack) {
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        if (itemStack.m_41619_()) {
            return fluidStacks;
        }
        Item item = itemStack.m_41720_();
        if (item == Items.f_42446_) {
            fluidStacks.add(new FluidStack(Fluids.f_76191_, 0));
        } else {
            IFluidHandlerItem handlerInItemStack = FluidUtil2.getItemStackFluidHandler(itemStack);
            if (handlerInItemStack != null) {
                for (int i = 0; i < handlerInItemStack.getTanks(); ++i) {
                    fluidStacks.add(handlerInItemStack.getFluidInTank(i));
                }
            } else {
                Fluid fluid = FluidUtil2.findBucketFluid(item);
                if (fluid != Fluids.f_76191_) {
                    fluidStacks.add(new FluidStack(fluid, 1000));
                }
            }
        }
        return fluidStacks;
    }

    public static boolean fillSink(IItemHandlerModifiable itemHandler, int sinkItemSlot, IFluidHandler source, int transfer) {
        ItemStack sinkItemStack = itemHandler.getStackInSlot(sinkItemSlot);
        if (FluidUtil2.fillSinkBucket(itemHandler, sinkItemSlot, source, sinkItemStack)) {
            return true;
        }
        return !FluidUtil2.fillSinkCapability(source, sinkItemStack, transfer).isEmpty();
    }

    public static FluidStack fillSinkCapability(IFluidHandler source, ItemStack sinkItemStack, int transfer) {
        IFluidHandlerItem sink = FluidUtil2.getItemStackFluidHandler(sinkItemStack);
        return FluidUtil2.tryTransfer((IFluidHandler)sink, source, transfer);
    }

    public static boolean fillSinkBucket(IItemHandlerModifiable itemHandler, int sinkItemSlot, IFluidHandler source, ItemStack itemStack) {
        int size;
        FluidStack fluidStack;
        if (itemStack.m_41720_() == Items.f_42446_ && (fluidStack = source.drain(size = 1000, IFluidHandler.FluidAction.SIMULATE)).getAmount() == size) {
            source.drain(size, IFluidHandler.FluidAction.EXECUTE);
            itemHandler.setStackInSlot(sinkItemSlot, new ItemStack((ItemLike)fluidStack.getFluid().m_6859_()));
            return true;
        }
        return false;
    }

    public static boolean drainSource(IItemHandlerModifiable itemHandler, int sourceItemSlot, IFluidHandler sink, int transfer) {
        ItemStack sourceItemStack = itemHandler.getStackInSlot(sourceItemSlot);
        if (FluidUtil2.drainSourceBucket(itemHandler, sourceItemSlot, sink, sourceItemStack)) {
            return true;
        }
        return !FluidUtil2.drainSourceCapability(sink, sourceItemStack, transfer).isEmpty();
    }

    public static boolean drainSourceBucket(IItemHandlerModifiable itemHandler, int itemSlot, IFluidHandler sink, ItemStack sourceItemStack) {
        FluidStack fluidStack;
        Item sourceItem = sourceItemStack.m_41720_();
        Fluid sourceFluid = FluidUtil2.findBucketFluid(sourceItem);
        if (sourceFluid != Fluids.f_76191_ && sink.fill(fluidStack = new FluidStack(sourceFluid, 1000), IFluidHandler.FluidAction.SIMULATE) == fluidStack.getAmount()) {
            sink.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            itemHandler.setStackInSlot(itemSlot, new ItemStack((ItemLike)Items.f_42446_));
            return true;
        }
        return false;
    }

    public static FluidStack drainSourceCapability(IFluidHandler sink, ItemStack sourceItemStack, int transfer) {
        IFluidHandlerItem source = FluidUtil2.getItemStackFluidHandler(sourceItemStack);
        return FluidUtil2.tryTransfer(sink, (IFluidHandler)source, transfer);
    }

    public static FluidStack tryTransfer(IFluidHandler sink, IFluidHandler source, int transfer) {
        if (sink != null && source != null && transfer > 0) {
            return FluidUtil.tryFluidTransfer((IFluidHandler)sink, (IFluidHandler)source, (int)transfer, (boolean)true);
        }
        return FluidStack.EMPTY;
    }

    private FluidUtil2() {
    }
}

