/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.util;

import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.mrscauthd.beyond_earth.common.events.forge.ItemGravityEvent;
import net.mrscauthd.beyond_earth.common.util.EntityGravity;
import net.mrscauthd.beyond_earth.common.util.Planets;

public class ItemGravity {
    public static final double DEFAULT_ITEM_GRAVITY = 0.04;

    public static void setGravities(ItemEntity itemEntity, Level level) {
        float itemGravity = Planets.getItemGravityForLocation(level);
        if (itemGravity != -1.0f) {
            ItemGravity.setGravity(itemEntity, itemGravity);
        }
    }

    public static void setGravity(ItemEntity entity, double gravity) {
        if (!ItemGravity.getCondition(entity)) {
            return;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new ItemGravityEvent(entity, gravity))) {
            return;
        }
        float artificialGravity = EntityGravity.getArtificalGravityModifier(entity.f_19853_, entity.m_20183_());
        double dy = entity.m_20184_().f_82480_ / 0.98 + 0.04 - (gravity += (double)artificialGravity * 0.04);
        entity.m_20334_(entity.m_20184_().f_82479_, dy, entity.m_20184_().f_82481_);
    }

    private static boolean getCondition(ItemEntity entity) {
        return !entity.isInFluidType() && !entity.m_20077_() && !entity.m_20068_();
    }
}

