/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.mrscauthd.beyond_earth.common.events.forge.PlanetRegisterEvent;
import net.mrscauthd.beyond_earth.common.registries.PlanetRegistry;
import net.mrscauthd.beyond_earth.common.util.Methods;

public class Planets {
    public static Map<ResourceKey<Level>, Planet> PLANETS_BY_ORBIT = Maps.newHashMap();
    public static Map<ResourceKey<Level>, Planet> PLANETS_BY_PLANET = Maps.newHashMap();
    public static Map<ResourceKey<Level>, Planet> BY_DIMENSION = Maps.newHashMap();
    public static Int2ObjectOpenHashMap<ResourceKey<Level>> PLANET_ID_MAPS = new Int2ObjectOpenHashMap();
    public static Int2ObjectOpenHashMap<ResourceKey<Level>> ORBIT_ID_MAPS = new Int2ObjectOpenHashMap();
    public static Int2ObjectOpenHashMap<ResourceKey<Level>> STATION_ID_MAPS = new Int2ObjectOpenHashMap();
    public static Set<ResourceKey<Level>> LEVELS_WITHOUT_RAIN = new HashSet<ResourceKey<Level>>();
    public static Set<ResourceKey<Level>> LEVELS_WITHOUT_OXYGEN = new HashSet<ResourceKey<Level>>();
    public static Set<ResourceKey<Level>> SPACE_LEVELS = new HashSet<ResourceKey<Level>>();
    public static Map<String, StarSystem> STARS = Maps.newHashMap();
    public static List<StarSystem> ORDERED_STARS = new ArrayList<StarSystem>();
    private static final AtomicInteger IDMAPPINGS = new AtomicInteger();
    public static final double MOON_MASS_SCALE = 7.34E22;
    public static final double PLANET_MASS_SCALE = 5.9E24;
    public static final double STAR_MASS_SCALE = 2.0E30;
    public static final float MOON_ORBIT_SCALE = 384399.0f;
    public static final float PLANET_ORBIT_SCALE = 1.4959802E8f;

    public static void clear() {
        BY_DIMENSION.clear();
        PLANETS_BY_PLANET.clear();
        PLANETS_BY_ORBIT.clear();
        STARS.clear();
        ORDERED_STARS.clear();
    }

    public static void generateDefaults() {
        Planets.clear();
        PlanetRegistry.registerDefaultPlanets();
        MinecraftForge.EVENT_BUS.post((Event)new PlanetRegisterEvent.Generate());
        Planets.initIDs();
    }

    public static void initIDs() {
        IDMAPPINGS.set(0);
        PLANET_ID_MAPS.clear();
        ORBIT_ID_MAPS.clear();
        STATION_ID_MAPS.clear();
        LEVELS_WITHOUT_RAIN.clear();
        LEVELS_WITHOUT_OXYGEN.clear();
        SPACE_LEVELS.clear();
        ORDERED_STARS.forEach(star -> {
            star.init();
            star.planets.forEach(p -> p.initIDs(IDMAPPINGS));
        });
    }

    @Nullable
    public static Planet getLocationForOrbit(Level level) {
        if (!PLANETS_BY_ORBIT.containsKey(level.m_46472_())) {
            return null;
        }
        return PLANETS_BY_ORBIT.get(level.m_46472_());
    }

    @Nullable
    public static Planet getLocationForPlanet(Level level) {
        if (!PLANETS_BY_PLANET.containsKey(level.m_46472_())) {
            return null;
        }
        return PLANETS_BY_PLANET.get(level.m_46472_());
    }

    public static float getItemGravityForLocation(Level level) {
        ResourceKey key = level.m_46472_();
        Planet planet = BY_DIMENSION.get(key);
        if (planet == null) {
            return -1.0f;
        }
        float scale = key == planet.orbit ? planet.orbitG : planet.g;
        scale = Math.max(scale, 0.04f);
        float base = 0.04f;
        return scale * base;
    }

    public static float getEntityGravityForLocation(Level level) {
        ResourceKey key = level.m_46472_();
        Planet planet = BY_DIMENSION.get(key);
        if (planet == null) {
            return -1.0f;
        }
        float scale = key == planet.orbit ? planet.orbitG : planet.g;
        scale = Math.max(scale, 0.04f);
        float base = (float)((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22082_();
        return scale * base;
    }

    public static boolean registerMoon(ResourceKey<Level> planet, ResourceKey<Level> moon) {
        Planet p = PLANETS_BY_PLANET.get(planet);
        if (p == null) {
            return false;
        }
        Planet m = PLANETS_BY_PLANET.get(moon);
        if (m == null) {
            return false;
        }
        if (p.moons.contains(m)) {
            return false;
        }
        p.addChild(m);
        return true;
    }

    public static void registerPlanet(ResourceKey<Level> location, ResourceKey<Level> orbit) {
        Planet planet = new Planet(location, orbit);
        planet.register();
    }

    public static void registerPlanetBar(ResourceKey<Level> planet, ResourceLocation planetBar) {
        Planet p = BY_DIMENSION.get(planet);
        if (p != null) {
            p.planetBar = planetBar;
        }
    }

    public static ResourceLocation getPlanetBar(Level level) {
        Planet p = BY_DIMENSION.get(level.m_46472_());
        if (p == null) {
            return Planet.DEFAULT_PLANET_BAR;
        }
        return p.getPlanetBar(Methods.isOrbitLevel(level));
    }

    public static List<StarSystem> getStarsList() {
        if (ORDERED_STARS.isEmpty()) {
            Planets.generateDefaults();
        }
        return ORDERED_STARS;
    }

    public static float getRotation(Planet planet, float timer, float scale) {
        double T = planet.orbitT * (double)(scale /= 0.013888889f);
        return (float)((double)planet._initPhase + (double)(360.0f * (timer /= 20.0f)) / T) % 360.0f;
    }

    private static void updateLocation(Level level, Planet planet) {
        ResourceKey key = level.m_46472_();
        if (!key.equals(planet.orbit) || key.equals(planet.planet)) {
            return;
        }
        planet.orbitPhase = Planets.getRotation(planet, level.m_8044_(), 1.0f);
        planet.moons.forEach(moon -> Planets.updateLocation(level, moon));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePlanetLocations(Level level) {
        List<StarSystem> list;
        List<StarSystem> list2 = list = Planets.getStarsList();
        synchronized (list2) {
            for (StarSystem system : list) {
                List<Planet> list22;
                List<Planet> list3 = list22 = system.planets;
                synchronized (list3) {
                    list22.forEach(planet -> Planets.updateLocation(level, planet));
                }
            }
        }
    }

    static {
        Planets.generateDefaults();
    }

    public static class Planet
    extends CelestialBody {
        private static final ResourceLocation ORBIT_PLANET_BAR = new ResourceLocation("beyond_earth", "textures/planet_bar/orbit_planet_bar.png");
        private static final ResourceLocation DEFAULT_PLANET_BAR = new ResourceLocation("beyond_earth", "textures/planet_bar/earth_planet_bar.png");
        public ResourceKey<Level> planet;
        public ResourceKey<Level> orbit;
        public int planetID;
        public int orbitID;
        public int stationID;
        public boolean hasOxygen = false;
        public boolean hasRain = false;
        public boolean hasClouds = false;
        public boolean spaceLevel = true;
        public boolean hasDustStorms = false;
        public ResourceLocation planetBar;
        public ResourceLocation orbitBar;
        public ResourceLocation phaseTexture;
        public float rotation = 0.0f;
        public int[] orbitColour = new int[]{255, 255, 255};
        public float[] sunriseColour = new float[]{0.7f, 0.2f, 0.2f};
        public float _distance = 0.0f;
        public float _xPos = 0.0f;
        public float _yPos = 0.0f;
        public float orbitPhase = 0.0f;
        public float _initPhase = 0.0f;
        public int tier = 0;
        public int button_category = -1;
        public List<Planet> moons;

        public Planet(ResourceKey<Level> planet, ResourceKey<Level> orbit) {
            this.planet = planet;
            this.orbit = orbit;
            this.name = planet.m_135782_().m_135815_();
            if (planet == Level.f_46428_) {
                this.name = "earth";
            }
            this.moons = this.children;
        }

        private void initIDs(AtomicInteger global) {
            this.planetID = global.getAndIncrement();
            this.orbitID = global.getAndIncrement();
            this.stationID = global.getAndIncrement();
            PLANET_ID_MAPS.put(this.planetID, this.planet);
            ORBIT_ID_MAPS.put(this.orbitID, this.orbit);
            STATION_ID_MAPS.put(this.stationID, this.orbit);
            if (!this.hasOxygen) {
                LEVELS_WITHOUT_OXYGEN.add(this.planet);
            }
            LEVELS_WITHOUT_OXYGEN.add(this.orbit);
            if (!this.hasRain) {
                LEVELS_WITHOUT_RAIN.add(this.planet);
            }
            LEVELS_WITHOUT_RAIN.add(this.orbit);
            if (this.spaceLevel) {
                SPACE_LEVELS.add(this.planet);
            }
            SPACE_LEVELS.add(this.orbit);
            this.moons.forEach(p -> p.initIDs(global));
        }

        public ResourceLocation getPlanetBar(boolean orbit) {
            if (orbit) {
                return this.orbitBar != null ? this.orbitBar : ORBIT_PLANET_BAR;
            }
            return this.planetBar != null ? this.planetBar : DEFAULT_PLANET_BAR;
        }

        public void register() {
            PLANETS_BY_ORBIT.put(this.orbit, this);
            PLANETS_BY_PLANET.put(this.planet, this);
            BY_DIMENSION.put(this.orbit, this);
            BY_DIMENSION.put(this.planet, this);
            this.moons.forEach(m -> m.register());
            this.moons.sort(null);
        }

        @Override
        protected void init() {
            super.init();
            this.moons.forEach(moon -> moon.init());
        }
    }

    public static class StarSystem
    extends CelestialBody {
        public List<Planet> planets;

        public StarSystem() {
            this.planets = this.children;
        }

        public void register() {
            STARS.put(this.name, this);
            ORDERED_STARS.add(this);
            this.planets.forEach(p -> p.register());
        }

        @Override
        protected void init() {
            super.init();
            this.planets.forEach(planet -> planet.init());
        }
    }

    public static class CelestialBody
    implements Comparable<CelestialBody> {
        public String name;
        public ResourceLocation texture;
        public float[] location = new float[3];
        public int[] colour = new int[]{232, 219, 176};
        public Component description;
        public double mass = 5.9E24;
        public double radius = 6000.0;
        public double orbitRadius = 1.49598016E8;
        public float g = 1.0f;
        public float orbitG = 0.05f;
        public float temperature = 14.0f;
        public boolean tidalLock = false;
        public float airDensity = 0.0f;
        public double orbitT;
        public double orbitL;
        public CelestialBody _parent = null;
        public List<Planet> children = new ArrayList<Planet>();
        public Set<String> childNames = Sets.newHashSet();
        protected Vec3 colourCache = null;

        public Vec3 getLightColour() {
            if (this.colourCache == null) {
                this.colourCache = new Vec3((double)this.colour[0], (double)this.colour[1], (double)this.colour[2]);
            }
            return this.colourCache;
        }

        protected void init() {
            double parentMass = this._parent == null ? 5.9E24 : this._parent.mass;
            double radius = this.orbitRadius * 1000.0;
            double GM = parentMass * 6.674E-11;
            this.orbitL = Math.PI * radius * 2.0 / 1000.0;
            this.orbitT = Math.PI * 2 * Math.sqrt(radius * radius * radius / GM);
            this.orbitT /= 86400.0;
        }

        public void addChild(Planet planet) {
            if (!this.childNames.add(planet.name)) {
                new IllegalStateException("Error, adding duplicate " + planet.name).printStackTrace();
                return;
            }
            this.children.add(planet);
            planet._parent = this;
            planet.colour = this.colour;
            planet.colourCache = this.getLightColour();
            this.children.sort(null);
            System.out.println("Adding child " + planet.name + " to " + this.name);
        }

        @Override
        public int compareTo(CelestialBody o) {
            return Double.compare(this.orbitRadius, o.orbitRadius);
        }
    }
}

