/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import com.google.common.collect.Lists;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.adventurez.entity.VoidFragmentEntity;
import net.adventurez.entity.VoidShadeEntity;
import net.adventurez.entity.nonliving.ThrownRockEntity;
import net.adventurez.init.EffectInit;
import net.adventurez.init.EntityInit;
import net.adventurez.init.SoundInit;
import net.adventurez.init.TagInit;
import net.adventurez.network.GeneralPacket;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1307;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.voidz.block.VoidBlock;
import net.voidz.init.BlockInit;
import net.voidz.init.DimensionInit;
import org.jetbrains.annotations.Nullable;

public class VoidShadowEntity
extends class_1307
implements class_1569 {
    public static final class_2940<Boolean> HALF_LIFE_CHANGE = class_2945.method_12791(VoidShadowEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> IS_THROWING_BLOCKS = class_2945.method_12791(VoidShadowEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> HOVERING_MAGIC_HANDS = class_2945.method_12791(VoidShadowEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> CIRCLING_HANDS = class_2945.method_12791(VoidShadowEntity.class, (class_2941)class_2943.field_13323);
    private List<class_2338> blockPosList = new ArrayList<class_2338>();
    private final class_3213 bossBar = new class_3213(this.method_5476(), class_1259.class_1260.field_5783, class_1259.class_1261.field_5795);
    private boolean circling;
    private boolean wasCircling;
    private int portalX;
    private int portalY;
    private int portalZ;
    private boolean isHalfLife;
    private final boolean isInVoidDungeon;
    private boolean invisible;
    private int ticksSinceDeath;

    public VoidShadowEntity(class_1299<? extends class_1307> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 100;
        this.field_6207 = new VoidShadowMoveControl(this);
        this.isInVoidDungeon = FabricLoader.getInstance().isModLoaded("voidz") && world.method_27983() == DimensionInit.VOID_WORLD;
    }

    public void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new ThrowBlocks(this));
        this.field_6201.method_6277(1, (class_1352)new DestroyBlocksAttack(this));
        this.field_6201.method_6277(2, (class_1352)new SummonFragment(this));
        this.field_6201.method_6277(3, (class_1352)new SummonShade(this));
        this.field_6201.method_6277(4, (class_1352)new Insanity(this));
        this.field_6201.method_6277(6, (class_1352)new FlyGoal(this));
        this.field_6201.method_6277(5, (class_1352)new LookGoal(this));
    }

    public static class_5132.class_5133 createVoidShadowAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 1000.0).method_26868(class_5134.field_23719, 0.1).method_26868(class_5134.field_23721, 10.0).method_26868(class_5134.field_23722, 2.0).method_26868(class_5134.field_23724, 1.0).method_26868(class_5134.field_23718, 10.0).method_26868(class_5134.field_23717, 80.0);
    }

    public void method_5958() {
        super.method_5958();
        this.bossBar.method_5408(this.method_6032() / this.method_6063());
        if (this.method_6032() < this.method_6063() / 2.0f) {
            if (!((Boolean)this.field_6011.method_12789(HALF_LIFE_CHANGE)).booleanValue()) {
                this.field_6011.method_12778(HALF_LIFE_CHANGE, (Object)true);
            }
            if (!this.isHalfLife) {
                this.method_5996(class_5134.field_23722).method_6192(6.0);
                this.method_5996(class_5134.field_23721).method_6192(14.0);
                this.method_5996(class_5134.field_23724).method_6192(4.0);
                this.isHalfLife = true;
            }
            if (this.method_6032() < this.method_6063() / 8.0f && !this.invisible) {
                this.method_6092(new class_1293(class_1294.field_5905, 400, 0, false, false, false));
                this.invisible = true;
            }
        }
    }

    public void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HALF_LIFE_CHANGE, (Object)false);
        this.field_6011.method_12784(IS_THROWING_BLOCKS, (Object)false);
        this.field_6011.method_12784(HOVERING_MAGIC_HANDS, (Object)false);
        this.field_6011.method_12784(CIRCLING_HANDS, (Object)false);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("VoidXPortal", this.portalX);
        tag.method_10569("VoidYPortal", this.portalY);
        tag.method_10569("VoidZPortal", this.portalZ);
        tag.method_10556("ShadowCircling", this.circling);
        tag.method_10556("ShadowIsHalfLife", this.isHalfLife);
        tag.method_10572("ShadowBrokenBlocks", this.blockListTransform(this.blockPosList));
        tag.method_10556("ShadowInvisible", this.invisible);
        tag.method_10556("ShadowWasCircling", this.wasCircling);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (this.method_16914()) {
            this.bossBar.method_5413(this.method_5476());
        }
        this.portalX = tag.method_10550("VoidXPortal");
        this.portalY = tag.method_10550("VoidYPortal");
        this.portalZ = tag.method_10550("VoidZPortal");
        this.circling = tag.method_10577("ShadowCircling");
        this.isHalfLife = tag.method_10577("ShadowIsHalfLife");
        this.setBlockList(tag.method_10561("ShadowBrokenBlocks"));
        this.invisible = tag.method_10577("ShadowInvisible");
        this.wasCircling = tag.method_10577("ShadowWasCircling");
        if (!this.circling && this.wasCircling) {
            this.circling = true;
        }
    }

    private List<Integer> blockListTransform(List<class_2338> oldBlockPosList) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < oldBlockPosList.size(); ++i) {
            list.add(oldBlockPosList.get(i).method_10263());
            list.add(oldBlockPosList.get(i).method_10264());
            list.add(oldBlockPosList.get(i).method_10260());
        }
        return list;
    }

    private void setBlockList(int[] integers) {
        if (integers.length != 0) {
            for (int i = 0; i < integers.length; ++i) {
                if (i % 3 != 0) continue;
                this.blockPosList.add(i / 3, new class_2338(integers[i], integers[i + 1], integers[i + 2]));
            }
        }
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossBar.method_5413(this.method_5476());
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossBar.method_14088(player);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityTag) {
        if (!this.hasVoidMiddleCoordinates() && FabricLoader.getInstance().isModLoaded("voidz") && world.method_8320(this.method_24515().method_10074()).method_26204() == BlockInit.PORTAL_BLOCK) {
            this.setVoidMiddle(this.method_24515().method_10263(), this.method_24515().method_10264(), this.method_24515().method_10260());
        }
        return super.method_5943(world, difficulty, spawnReason, entityData, entityTag);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossBar.method_14089(player);
    }

    public boolean method_5974(double num) {
        return false;
    }

    public void method_5982() {
        if (this.field_6002.method_8407() == class_1267.field_5801) {
            this.method_5650();
        }
    }

    public boolean method_5747(float fallDistance, float damageMultiplier) {
        return false;
    }

    public boolean method_6092(class_1293 effect) {
        return false;
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }

    public boolean method_5860(class_1297 entity) {
        return false;
    }

    public boolean method_5822() {
        return false;
    }

    public boolean method_6049(class_1293 effect) {
        return false;
    }

    private boolean hasVoidMiddleCoordinates() {
        return this.portalX != 0 || this.portalY != 0 || this.portalZ != 0;
    }

    public void setVoidMiddle(int x, int y, int z) {
        this.circling = true;
        this.portalX = x;
        this.portalY = y;
        this.portalZ = z;
    }

    public class_2338 getVoidMiddle() {
        return new class_2338(this.portalX, this.portalY, this.portalZ);
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_5529() instanceof class_1309) {
            if (this.circling) {
                this.method_5980((class_1309)source.method_5529());
            }
            amount *= 0.5f;
        }
        if (source.method_5526() instanceof ThrownRockEntity) {
            return false;
        }
        if (source.method_5533() && source.method_5526() instanceof class_1667) {
            class_1667 arrowEntity = (class_1667)source.method_5526();
            if (arrowEntity.method_5851()) {
                return true;
            }
            source.method_5526().method_5650();
            return false;
        }
        return this.method_5679(source) ? false : super.method_5643(source, amount);
    }

    public void method_6078(class_1282 source) {
        if (!this.field_6002.field_9236 && !this.blockPosList.isEmpty()) {
            for (int u = 0; u < this.blockPosList.size(); ++u) {
                this.field_6002.method_8501(this.blockPosList.get(u), BlockInit.VOID_BLOCK.method_9564());
                this.field_6002.method_8396(null, this.blockPosList.get(u), class_3417.field_14574, class_3419.field_15245, 1.0f, 1.0f);
            }
        }
        super.method_6078(source);
    }

    protected class_3414 method_5994() {
        return SoundInit.SHADOW_IDLE_EVENT;
    }

    protected class_3414 method_6002() {
        return SoundInit.SHADOW_DEATH_EVENT;
    }

    protected float method_6107() {
        return 5.0f;
    }

    private void deathParticles(class_2394 particleEffect) {
        float f = (this.field_5974.nextFloat() - 0.5f) * 16.0f;
        float g = (this.field_5974.nextFloat() - 0.5f) * 10.0f;
        float h = (this.field_5974.nextFloat() - 0.5f) * 16.0f;
        this.field_6002.method_8406(particleEffect, this.method_23317() + (double)f, this.method_23318() + 2.0 + (double)g, this.method_23321() + (double)h, 0.0, 0.0, 0.0);
    }

    protected void method_6108() {
        int i;
        ++this.ticksSinceDeath;
        this.method_5977(true);
        this.method_5980(null);
        if (this.field_6002.field_9236) {
            if (this.ticksSinceDeath >= 0 && this.ticksSinceDeath < 40) {
                for (i = 0; i < 10; ++i) {
                    this.deathParticles((class_2394)class_2398.field_11214);
                }
            }
            if (this.ticksSinceDeath >= 41 && this.ticksSinceDeath <= 200) {
                this.deathParticles((class_2394)class_2398.field_22447);
            }
        }
        if (!this.field_6002.field_9236) {
            this.bossBar.method_5408(0.0f);
            if (this.ticksSinceDeath == 1 && !this.method_5701()) {
                this.field_6002.method_8474(1028, this.method_24515(), 0);
            }
            if (this.hasVoidMiddleCoordinates() && this.ticksSinceDeath == 40) {
                this.method_20620(this.getVoidMiddle().method_10263(), this.getVoidMiddle().method_10086(5).method_10264(), this.getVoidMiddle().method_10260());
            }
        }
        this.method_5784(class_1313.field_6308, new class_243(0.0, 0.05, 0.0));
        if (this.ticksSinceDeath >= 198) {
            for (i = 0; i < 100; ++i) {
                this.deathParticles((class_2394)class_2398.field_11251);
            }
        }
        if (this.ticksSinceDeath >= 200 && !this.field_6002.field_9236) {
            if (this.isInVoidDungeon) {
                class_238 box = new class_238(this.method_24515());
                List list = this.field_6002.method_8390(class_1657.class, box.method_1014(128.0), class_1301.field_6155);
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    ((class_1657)list.get(i2)).method_6092(new class_1293(EffectInit.FAME, 48000, 0, false, false, true));
                }
            }
            this.method_5650();
        }
    }

    static class VoidShadowMoveControl
    extends class_1335 {
        private final VoidShadowEntity voidShadowEntity;

        public VoidShadowMoveControl(VoidShadowEntity voidShadowEntity) {
            super((class_1308)voidShadowEntity);
            this.voidShadowEntity = voidShadowEntity;
        }

        public void method_6240() {
            if (this.voidShadowEntity.circling && this.voidShadowEntity.hasVoidMiddleCoordinates()) {
                class_2338 pos = this.voidShadowEntity.getVoidMiddle();
                class_243 vec3d = new class_243((double)pos.method_10263() - this.voidShadowEntity.method_23317(), (double)pos.method_10264() - this.voidShadowEntity.method_23318(), (double)pos.method_10260() - this.voidShadowEntity.method_23321());
                vec3d = vec3d.method_1029();
                class_243 distanceVector = new class_243(this.voidShadowEntity.method_23317(), this.voidShadowEntity.method_23318(), this.voidShadowEntity.method_23321());
                class_243 class_2432 = new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                if (distanceVector.method_1022(class_2432) >= 50.0) {
                    this.voidShadowEntity.method_18799(this.voidShadowEntity.method_18798().method_1019(vec3d.method_1021(0.1)));
                } else {
                    this.voidShadowEntity.method_18799(this.voidShadowEntity.method_18798().method_1019(vec3d.method_1021(0.1).method_1021(-1.0)));
                }
                this.voidShadowEntity.method_18799(this.voidShadowEntity.method_18798().method_1019(vec3d.method_1021(0.1).method_1024(90.0f)));
                if (this.voidShadowEntity.method_18798().method_1033() <= 0.3) {
                    this.voidShadowEntity.method_5762(0.1, 0.1, 0.1);
                }
            } else if (this.field_6374 == class_1335.class_1336.field_6378) {
                class_243 vec3d = new class_243(this.field_6370 - this.voidShadowEntity.method_23317(), this.field_6369 - this.voidShadowEntity.method_23318(), this.field_6367 - this.voidShadowEntity.method_23321());
                vec3d = vec3d.method_1029();
                this.voidShadowEntity.method_18799(this.voidShadowEntity.method_18798().method_1019(vec3d.method_1021(0.1)));
            }
        }
    }

    static class ThrowBlocks
    extends class_1352 {
        private final VoidShadowEntity voidShadow;
        private int throwTicker;
        private int throwBlocks;

        public ThrowBlocks(VoidShadowEntity voidShadow) {
            this.voidShadow = voidShadow;
        }

        public boolean method_6264() {
            class_1309 livingEntity = this.voidShadow.method_5968();
            if (livingEntity != null && this.voidShadow.circling && this.voidShadow.method_5739((class_1297)livingEntity) > 5.0f && this.voidShadow.method_5739((class_1297)livingEntity) < 30.0f) {
                ++this.throwTicker;
                return this.throwTicker >= 80;
            }
            return false;
        }

        public void method_6268() {
            class_1309 livingEntity = this.voidShadow.method_5968();
            if (livingEntity != null) {
                this.voidShadow.field_6206.method_6226((class_1297)livingEntity, 1.0f, 1.0f);
                ++this.throwBlocks;
                if (this.throwBlocks >= 10) {
                    class_2338 pos = this.voidShadow.method_24515();
                    for (int i = 0; i < (this.voidShadow.isHalfLife ? 60 : 40); ++i) {
                        if (this.voidShadow.field_6002.field_9236) continue;
                        double random = this.voidShadow.field_6002.field_9229.nextDouble() + 0.3;
                        double anotherRandom = this.voidShadow.field_6002.field_9229.nextDouble();
                        double anotherExtraRandom = this.voidShadow.field_6002.field_9229.nextDouble() - 0.5;
                        double anotherExtraXXXRandom = this.voidShadow.field_6002.field_9229.nextDouble() - 0.5;
                        class_2248 block = this.voidShadow.hasVoidMiddleCoordinates() ? this.voidShadow.field_6002.method_8320(this.voidShadow.getVoidMiddle().method_10095().method_10074()).method_26204() : (!this.voidShadow.field_6002.method_8320(pos.method_10087(5)).method_26215() ? this.voidShadow.field_6002.method_8320(pos.method_10087(5)).method_26204() : class_2246.field_10340);
                        ThrownRockEntity thrownRockEntity = new ThrownRockEntity(this.voidShadow.field_6002, (class_1309)this.voidShadow);
                        class_243 vec3d = new class_243(livingEntity.method_23317() - this.voidShadow.method_23317(), livingEntity.method_23318() - this.voidShadow.method_23318(), livingEntity.method_23321() - this.voidShadow.method_23321());
                        vec3d = vec3d.method_1031(anotherExtraRandom * 12.0, 5.0 * anotherRandom, anotherExtraXXXRandom * 12.0);
                        vec3d = vec3d.method_1029();
                        thrownRockEntity.method_18799(thrownRockEntity.method_18798().method_1019(vec3d.method_1021(1.4 * random)));
                        thrownRockEntity.method_16940(new class_1799((class_1935)block.method_8389()));
                        this.voidShadow.field_6002.method_8649((class_1297)thrownRockEntity);
                    }
                    this.voidShadow.field_6002.method_8449((class_1657)null, (class_1297)this.voidShadow, SoundInit.ROCK_THROW_EVENT, class_3419.field_15251, 1.0f, 1.0f);
                    this.throwBlocks = 0;
                    this.method_6270();
                }
            }
        }

        public boolean method_6266() {
            class_1309 livingEntity = this.voidShadow.method_5968();
            if (livingEntity == null || !livingEntity.method_5805()) {
                return false;
            }
            return this.voidShadow.method_5739((class_1297)livingEntity) > 5.0f && this.voidShadow.method_5739((class_1297)livingEntity) < 30.0f && this.throwTicker == 0;
        }

        public void method_6269() {
            this.voidShadow.field_6011.method_12778(IS_THROWING_BLOCKS, (Object)true);
            this.voidShadow.method_5942().method_6340();
            this.throwTicker = 0;
        }

        public void method_6270() {
            this.voidShadow.field_6011.method_12778(IS_THROWING_BLOCKS, (Object)false);
            ++this.throwTicker;
        }
    }

    static class DestroyBlocksAttack
    extends class_1352 {
        private final VoidShadowEntity voidShadow;
        private int canStartTicker;
        private int destroyBlocksTicker;
        private final class_4051 PLAYER_PREDICATE = new class_4051().method_18418(128.0);
        private List<class_2338> playerBlockPosList = new ArrayList<class_2338>();

        public DestroyBlocksAttack(VoidShadowEntity voidShadow) {
            this.voidShadow = voidShadow;
        }

        public boolean method_6264() {
            class_1309 livingEntity = this.voidShadow.method_5968();
            if (livingEntity != null && this.voidShadow.isInVoidDungeon) {
                ++this.canStartTicker;
                return this.canStartTicker >= 200;
            }
            return false;
        }

        public void method_6268() {
            ++this.destroyBlocksTicker;
            if (this.destroyBlocksTicker == 40 && this.voidShadow.method_5968() != null) {
                int u;
                class_238 box = new class_238(this.voidShadow.method_24515());
                List playerList = this.voidShadow.field_6002.method_18464(this.PLAYER_PREDICATE, (class_1309)this.voidShadow, box.method_1014(120.0));
                for (int i = 0; i < playerList.size(); ++i) {
                    class_1657 playerEntity = (class_1657)playerList.get(i);
                    if (playerEntity.method_7337() || playerEntity.method_7325()) continue;
                    if (!this.voidShadow.field_6002.method_8320(playerEntity.method_24515().method_10074()).method_26215()) {
                        this.playerBlockPosList.add(playerEntity.method_24515().method_10074());
                        continue;
                    }
                    if (this.voidShadow.field_6002.method_8320(playerEntity.method_24515().method_10087(2)).method_26215()) continue;
                    this.playerBlockPosList.add(playerEntity.method_24515().method_10087(2));
                }
                for (u = 0; u < this.playerBlockPosList.size(); ++u) {
                    class_2338 pos = this.playerBlockPosList.get(u);
                    int radius = this.voidShadow.isHalfLife ? 5 : 3;
                    for (int k = -radius; k <= radius; ++k) {
                        for (int i = -radius; i <= radius; ++i) {
                            class_2338 blockPos = pos.method_10069(k, 0, i).method_10080(Math.sin(k) * (double)i, 0.0, Math.cos(k) * (double)i);
                            if (this.voidShadow.blockPosList.contains(blockPos) || this.voidShadow.field_6002.method_8320(blockPos).method_26215() || this.voidShadow.field_6002.method_8320(blockPos).method_26164(TagInit.UNBREAKABLE_BLOCKS)) continue;
                            this.voidShadow.blockPosList.add(blockPos);
                        }
                    }
                }
                for (u = 0; u < this.voidShadow.blockPosList.size(); ++u) {
                    this.voidShadow.field_6002.method_8501((class_2338)this.voidShadow.blockPosList.get(u), (class_2680)BlockInit.VOID_BLOCK.method_9564().method_11657((class_2769)VoidBlock.ACTIVATED, (Comparable)Boolean.valueOf(true)));
                }
            }
            if (this.destroyBlocksTicker == 110) {
                ((class_3218)this.voidShadow.field_6002).method_8449(null, (class_1297)this.voidShadow, SoundInit.SHADOW_CAST_EVENT, class_3419.field_15251, 20.0f, 1.0f);
            }
            if (this.destroyBlocksTicker == 120) {
                this.voidShadow.field_6011.method_12778(HOVERING_MAGIC_HANDS, (Object)false);
            }
            if (this.destroyBlocksTicker >= 400) {
                this.destroyBlocksTicker = 0;
                this.method_6270();
            }
        }

        public boolean method_6266() {
            return this.canStartTicker == 0;
        }

        public void method_6269() {
            this.voidShadow.field_6011.method_12778(HOVERING_MAGIC_HANDS, (Object)true);
            this.canStartTicker = 0;
            ((class_3218)this.voidShadow.field_6002).method_8449(null, (class_1297)this.voidShadow, SoundInit.SHADOW_PREPARE_EVENT, class_3419.field_15251, 20.0f, 1.0f);
        }

        public void method_6270() {
            ++this.canStartTicker;
            for (int u = 0; u < this.voidShadow.blockPosList.size(); ++u) {
                this.voidShadow.field_6002.method_8501((class_2338)this.voidShadow.blockPosList.get(u), BlockInit.VOID_BLOCK.method_9564());
                this.voidShadow.field_6002.method_8396(null, (class_2338)this.voidShadow.blockPosList.get(u), class_3417.field_14574, class_3419.field_15245, 1.0f, 1.0f);
            }
            if (!this.voidShadow.blockPosList.isEmpty()) {
                this.voidShadow.blockPosList.clear();
            }
            if (!this.playerBlockPosList.isEmpty()) {
                this.playerBlockPosList.clear();
            }
        }
    }

    static class SummonFragment
    extends class_1352 {
        private final VoidShadowEntity voidShadow;
        private int summonStartTicker;
        private int summonTick;

        public SummonFragment(VoidShadowEntity voidShadow) {
            this.voidShadow = voidShadow;
        }

        public boolean method_6264() {
            class_1309 livingEntity = this.voidShadow.method_5968();
            if (this.voidShadow.isInVoidDungeon && this.voidShadow.circling && this.voidShadow.hasVoidMiddleCoordinates() && livingEntity != null) {
                ++this.summonStartTicker;
                if (this.summonStartTicker >= 200) {
                    class_238 box = new class_238(this.voidShadow.method_24515());
                    List list = this.voidShadow.field_6002.method_8390(VoidFragmentEntity.class, box.method_1014(120.0), class_1301.field_6155);
                    if (list.isEmpty()) {
                        return true;
                    }
                    this.summonStartTicker = 0;
                }
                return false;
            }
            return false;
        }

        public void method_6268() {
            ++this.summonTick;
            if (this.summonTick >= 40 && this.voidShadow.method_5968() != null) {
                class_2338 pos = this.voidShadow.getVoidMiddle();
                Boolean isOrb = this.voidShadow.field_5974.nextFloat() < 0.5f;
                for (int i = 0; i < (isOrb != false ? 4 : 10); ++i) {
                    if (this.voidShadow.field_6002.field_9236) continue;
                    class_2338 spawnPos = isOrb.booleanValue() ? (i < 2 ? new class_2338(pos.method_10263() + 28 * (i - 1), pos.method_10264(), pos.method_10260() + 28 * i) : new class_2338(pos.method_10263() + 28 * (-i + 3), pos.method_10264(), pos.method_10260() + 28 * (-i + 2))) : new class_2338(pos.method_10263() - 35 + this.voidShadow.field_5974.nextInt(70), pos.method_10264(), pos.method_10260() - 35 + this.voidShadow.field_5974.nextInt(70));
                    VoidFragmentEntity voidShadeEntity = (VoidFragmentEntity)EntityInit.VOID_FRAGMENT_ENTITY.method_5883(this.voidShadow.field_6002);
                    voidShadeEntity.method_5943((class_5425)((class_3218)this.voidShadow.field_6002), this.voidShadow.field_6002.method_8404(pos), class_3730.field_16467, null, null);
                    voidShadeEntity.setVoidOrb(isOrb);
                    voidShadeEntity.method_5725(spawnPos, 0.0f, 0.0f);
                    this.voidShadow.field_6002.method_8649((class_1297)voidShadeEntity);
                }
                this.summonTick = 0;
                this.method_6270();
            }
        }

        public void method_6269() {
            this.voidShadow.field_6011.method_12778(HOVERING_MAGIC_HANDS, (Object)true);
            ((class_3218)this.voidShadow.field_6002).method_8449(null, (class_1297)this.voidShadow, SoundInit.SHADOW_PREPARE_EVENT, class_3419.field_15251, 20.0f, 1.0f);
        }

        public void method_6270() {
            this.voidShadow.field_6011.method_12778(HOVERING_MAGIC_HANDS, (Object)false);
            ((class_3218)this.voidShadow.field_6002).method_8449(null, (class_1297)this.voidShadow, SoundInit.SHADOW_CAST_EVENT, class_3419.field_15251, 20.0f, 1.0f);
        }
    }

    static class SummonShade
    extends class_1352 {
        private final VoidShadowEntity voidShadow;
        private int summonStartTicker;
        private int summonTick;

        public SummonShade(VoidShadowEntity voidShadow) {
            this.voidShadow = voidShadow;
        }

        public boolean method_6264() {
            class_1309 livingEntity = this.voidShadow.method_5968();
            if (this.voidShadow.isInVoidDungeon && this.voidShadow.hasVoidMiddleCoordinates() && livingEntity != null) {
                ++this.summonStartTicker;
                if (this.summonStartTicker >= 80) {
                    class_238 box = new class_238(this.voidShadow.method_24515());
                    List list = this.voidShadow.field_6002.method_8390(VoidShadeEntity.class, box.method_1014(120.0), class_1301.field_6155);
                    if (list.size() < 6) {
                        return true;
                    }
                    this.summonStartTicker = 0;
                }
                return false;
            }
            return false;
        }

        public void method_6268() {
            ++this.summonTick;
            if (this.summonTick >= 40 && this.voidShadow.method_5968() != null) {
                class_2338 pos = this.voidShadow.getVoidMiddle();
                for (int i = 0; i < (this.voidShadow.isHalfLife ? 24 : 16); ++i) {
                    if (this.voidShadow.field_6002.field_9236) continue;
                    class_2338 spawnPos = new class_2338(pos.method_10263() - 35 + this.voidShadow.field_5974.nextInt(70), pos.method_10264(), pos.method_10260() - 35 + this.voidShadow.field_5974.nextInt(70));
                    VoidShadeEntity voidShadeEntity = (VoidShadeEntity)EntityInit.VOID_SHADE_ENTITY.method_5883(this.voidShadow.field_6002);
                    voidShadeEntity.method_5943((class_5425)((class_3218)this.voidShadow.field_6002), this.voidShadow.field_6002.method_8404(pos), class_3730.field_16467, null, null);
                    voidShadeEntity.method_5725(spawnPos, this.voidShadow.field_6002.field_9229.nextFloat() * 360.0f, 0.0f);
                    this.voidShadow.field_6002.method_8649((class_1297)voidShadeEntity);
                }
                this.summonTick = 0;
                this.method_6270();
            }
        }

        public void method_6269() {
            this.voidShadow.field_6011.method_12778(HOVERING_MAGIC_HANDS, (Object)true);
            ((class_3218)this.voidShadow.field_6002).method_8449(null, (class_1297)this.voidShadow, SoundInit.SHADOW_PREPARE_EVENT, class_3419.field_15251, 20.0f, 1.0f);
        }

        public void method_6270() {
            this.voidShadow.field_6011.method_12778(HOVERING_MAGIC_HANDS, (Object)false);
            ((class_3218)this.voidShadow.field_6002).method_8449(null, (class_1297)this.voidShadow, SoundInit.SHADOW_CAST_EVENT, class_3419.field_15251, 20.0f, 1.0f);
        }
    }

    static class Insanity
    extends class_1352 {
        private final VoidShadowEntity voidShadow;
        private int insanityStartTicker;
        private int tick;
        private static final class_4051 PLAYER_PREDICATE = new class_4051().method_18418(80.0).method_18422();
        private List<class_1657> playerList;

        public Insanity(VoidShadowEntity voidShadow) {
            this.voidShadow = voidShadow;
        }

        public boolean method_6264() {
            if (this.voidShadow.isInVoidDungeon && this.voidShadow.circling && this.voidShadow.isHalfLife && this.voidShadow.hasVoidMiddleCoordinates() && this.voidShadow.blockPosList.isEmpty()) {
                ++this.insanityStartTicker;
                return this.insanityStartTicker >= 600;
            }
            return false;
        }

        public void method_6268() {
            ++this.tick;
            this.voidShadow.method_5980(null);
            if (this.tick == 60) {
                class_238 box = new class_238(this.voidShadow.method_24515());
                this.playerList = this.voidShadow.field_6002.method_18464(PLAYER_PREDICATE, (class_1309)this.voidShadow, box.method_1014(120.0));
                for (int i = 0; i < this.playerList.size(); ++i) {
                    class_1657 playerEntity = this.playerList.get(i);
                    playerEntity.method_6092(new class_1293(class_1294.field_5909, 60 + this.voidShadow.field_5974.nextInt(80), this.voidShadow.field_5974.nextInt(4), false, false, true));
                    playerEntity.method_6092(new class_1293(class_1294.field_5919, 40 + this.voidShadow.field_5974.nextInt(60), 0, false, false, true));
                }
            }
            if (this.tick == 100) {
                int radius = 8;
                class_2338 pos = this.voidShadow.getVoidMiddle().method_10074();
                for (int k = -radius; k <= radius; ++k) {
                    for (int i = -radius; i <= radius; ++i) {
                        class_2338 blockPos = pos.method_10069(k, 0, i);
                        if (!(this.voidShadow.field_5974.nextFloat() < 0.4f) || this.voidShadow.blockPosList.contains(blockPos) || this.voidShadow.field_6002.method_8320(blockPos).method_26215() || this.voidShadow.field_6002.method_8320(blockPos).method_26164(TagInit.UNBREAKABLE_BLOCKS)) continue;
                        this.voidShadow.blockPosList.add(blockPos);
                    }
                }
                for (int u = 0; u < this.voidShadow.blockPosList.size(); ++u) {
                    this.voidShadow.field_6002.method_8501((class_2338)this.voidShadow.blockPosList.get(u), BlockInit.INFESTED_VOID_BLOCK.method_9564());
                }
                ((class_3218)this.voidShadow.field_6002).method_8449(null, (class_1297)this.voidShadow, SoundInit.SHADOW_CAST_EVENT, class_3419.field_15251, 20.0f, 1.0f);
            }
            if (this.tick >= 300) {
                if (this.voidShadow.method_6032() < this.voidShadow.method_6063() / 10.0f && !this.playerList.isEmpty()) {
                    for (int i = 0; i < this.playerList.size(); ++i) {
                        if (!(this.playerList.get(i) instanceof class_3222)) continue;
                        class_2658 packet = new class_2658(GeneralPacket.VELOCITY_PACKET, new class_2540(Unpooled.buffer()));
                        ((class_3222)this.playerList.get((int)i)).field_13987.method_14364((class_2596)packet);
                    }
                    ((class_3218)this.voidShadow.field_6002).method_8449(null, (class_1297)this.voidShadow, SoundInit.SHADOW_IDLE_EVENT, class_3419.field_15251, 20.0f, 1.0f);
                }
                this.tick = 0;
                this.method_6270();
            }
        }

        public boolean method_6266() {
            return this.insanityStartTicker >= 600;
        }

        public void method_6269() {
            this.voidShadow.circling = false;
            this.voidShadow.wasCircling = true;
            this.voidShadow.field_6207.method_6239((double)this.voidShadow.getVoidMiddle().method_10263(), (double)this.voidShadow.getVoidMiddle().method_10264(), (double)this.voidShadow.getVoidMiddle().method_10260(), 1.0);
            this.voidShadow.method_5762(0.0, 0.2, 0.0);
            this.voidShadow.field_6011.method_12778(CIRCLING_HANDS, (Object)true);
            ((class_3218)this.voidShadow.field_6002).method_8449(null, (class_1297)this.voidShadow, SoundInit.SHADOW_PREPARE_EVENT, class_3419.field_15251, 20.0f, 1.0f);
        }

        public void method_6270() {
            this.voidShadow.circling = true;
            this.voidShadow.wasCircling = false;
            this.voidShadow.field_6011.method_12778(CIRCLING_HANDS, (Object)false);
            ((class_3218)this.voidShadow.field_6002).method_8449(null, (class_1297)this.voidShadow, SoundInit.SHADOW_CAST_EVENT, class_3419.field_15251, 20.0f, 1.0f);
            this.insanityStartTicker = 0;
            for (int u = 0; u < this.voidShadow.blockPosList.size(); ++u) {
                this.voidShadow.field_6002.method_8501((class_2338)this.voidShadow.blockPosList.get(u), BlockInit.VOID_BLOCK.method_9564());
            }
            if (!this.playerList.isEmpty()) {
                this.playerList.clear();
            }
            if (!this.voidShadow.blockPosList.isEmpty()) {
                this.voidShadow.blockPosList.clear();
            }
        }
    }

    static class FlyGoal
    extends class_1352 {
        private final VoidShadowEntity voidShadowEntity;

        public FlyGoal(VoidShadowEntity voidShadowEntity) {
            this.voidShadowEntity = voidShadowEntity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            double f;
            double e;
            class_1335 moveControl = this.voidShadowEntity.method_5962();
            if (!(moveControl.method_6241() && this.voidShadowEntity.method_5968() == null || this.voidShadowEntity.circling)) {
                return true;
            }
            double d = moveControl.method_6236() - this.voidShadowEntity.method_23317();
            double g = d * d + (e = moveControl.method_6235() - this.voidShadowEntity.method_23318()) * e + (f = moveControl.method_6237() - this.voidShadowEntity.method_23321()) * f;
            return g < 1.0 || g > 3600.0;
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6269() {
            if (this.voidShadowEntity.method_5968() != null && this.voidShadowEntity.method_5739((class_1297)this.voidShadowEntity.method_5968()) > 30.0f) {
                class_2338 pos = this.voidShadowEntity.method_5968().method_24515();
                this.voidShadowEntity.method_5962().method_6239((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 0.01);
            }
        }
    }

    static class LookGoal
    extends class_1352 {
        private final VoidShadowEntity voidShadowEntity;
        private static final class_4051 PLAYER_PREDICATE = new class_4051().method_18418(80.0).method_18422();

        public LookGoal(VoidShadowEntity voidShadowEntity) {
            this.voidShadowEntity = voidShadowEntity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return true;
        }

        public void method_6268() {
            if (this.voidShadowEntity.circling && this.voidShadowEntity.hasVoidMiddleCoordinates()) {
                class_2338 pos = this.voidShadowEntity.getVoidMiddle();
                class_243 vec3d = new class_243((double)pos.method_10263() - this.voidShadowEntity.method_23317(), (double)pos.method_10264() - this.voidShadowEntity.method_23318(), (double)pos.method_10260() - this.voidShadowEntity.method_23321());
                this.voidShadowEntity.field_6283 = this.voidShadowEntity.field_6031 = -((float)class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350)) * 57.295776f;
                this.voidShadowEntity.method_5980((class_1309)this.voidShadowEntity.field_6002.method_18462(PLAYER_PREDICATE, (class_1309)this.voidShadowEntity));
            } else if (this.voidShadowEntity.method_5968() == null) {
                class_243 vec3d = this.voidShadowEntity.method_18798();
                this.voidShadowEntity.field_6283 = this.voidShadowEntity.field_6031 = -((float)class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350)) * 57.295776f;
            } else {
                class_1309 livingEntity = this.voidShadowEntity.method_5968();
                if (livingEntity.method_5858((class_1297)this.voidShadowEntity) < 4096.0) {
                    double e = livingEntity.method_23317() - this.voidShadowEntity.method_23317();
                    double f = livingEntity.method_23321() - this.voidShadowEntity.method_23321();
                    this.voidShadowEntity.field_6283 = this.voidShadowEntity.field_6031 = -((float)class_3532.method_15349((double)e, (double)f)) * 57.295776f;
                }
            }
        }
    }
}

