/*
 * Decompiled with CFR 0.152.
 */
package net.jaspr.fasterladderclimbing;

import net.jaspr.fasterladderclimbing.FasterLadderClimbingConfig;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="fasterladderclimbing")
public class FasterLadderClimbing {
    public static final String MOD_ID = "fasterladderclimbing";
    public static final Logger LOGGER = LogManager.getLogger((String)"fasterladderclimbing");

    public FasterLadderClimbing() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, FasterLadderClimbingConfig.CONFIG_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player;
        if (event.phase == TickEvent.Phase.START && (player = event.player).func_70617_f_() && !player.func_213453_ef()) {
            EntityClimber climber = new EntityClimber(player);
            if (FasterLadderClimbingConfig.allowQuickDescension && climber.isFacingDownward() && !climber.isMovingForward() && !climber.isMovingBackward()) {
                climber.moveDownFarther();
            } else if (FasterLadderClimbingConfig.allowQuickAscension && climber.isFacingUpward() && climber.isMovingForward()) {
                climber.moveUpFarther();
            }
        }
    }

    private class EntityClimber {
        private PlayerEntity player;

        public EntityClimber(PlayerEntity player) {
            this.player = player;
        }

        private boolean isFacingDownward() {
            return this.player.field_70125_A > 0.0f;
        }

        private boolean isFacingUpward() {
            return this.player.field_70125_A < 0.0f;
        }

        private boolean isMovingForward() {
            return this.player.field_191988_bg > 0.0f;
        }

        private boolean isMovingBackward() {
            return this.player.field_191988_bg < 0.0f;
        }

        private float getElevationChangeUpdate() {
            return (float)Math.abs((double)this.player.field_70125_A / 90.0) * ((float)FasterLadderClimbingConfig.speedModifier / 10.0f);
        }

        public void moveUpFarther() {
            boolean px = false;
            float dx = this.getElevationChangeUpdate();
            Vector3d move = new Vector3d((double)px, (double)dx, (double)px);
            this.player.func_213315_a(MoverType.SELF, move);
        }

        public void moveDownFarther() {
            boolean px = false;
            float dx = this.getElevationChangeUpdate();
            Vector3d move = new Vector3d((double)px, (double)(dx * -1.0f), (double)px);
            this.player.func_213315_a(MoverType.SELF, move);
        }
    }
}

