/*
 * Decompiled with CFR 0.152.
 */
package net.jaspr.fasterladderclimbing;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="fasterladderclimbing", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FasterLadderClimbingConfig {
    public static final GeneralConfig CONFIG;
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static int speedModifier;
    public static boolean allowQuickAscension;
    public static boolean allowQuickDescension;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == CONFIG_SPEC) {
            FasterLadderClimbingConfig.bakeConfig();
        }
    }

    public static void bakeConfig() {
        speedModifier = (Integer)FasterLadderClimbingConfig.CONFIG.speedModifier.get();
        allowQuickAscension = (Boolean)FasterLadderClimbingConfig.CONFIG.allowQuickAscension.get();
        allowQuickDescension = (Boolean)FasterLadderClimbingConfig.CONFIG.allowQuickDescension.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(GeneralConfig::new);
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG = (GeneralConfig)specPair.getLeft();
    }

    public static class GeneralConfig {
        public final ForgeConfigSpec.IntValue speedModifier;
        public final ForgeConfigSpec.BooleanValue allowQuickAscension;
        public final ForgeConfigSpec.BooleanValue allowQuickDescension;

        public GeneralConfig(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.allowQuickAscension = builder.comment("Allow going UP faster. If [false], then player can only climb up the ladder at normal speed.").define("allowQuickAscension", true);
            this.allowQuickDescension = builder.comment("Allow going DOWN faster. If [false], then player can only climb down the ladder at normal speed.").define("allowQuickDescension", true);
            this.speedModifier = builder.comment("Speed modifier. 0 is Vanilla speed, 10 is lightning speed.").defineInRange("speedModifier", 4, 0, 10);
            builder.pop();
        }
    }
}

