/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import blusunrize.immersiveengineering.api.DimensionChunkCoords;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.common.IPConfig;
import flaxbeard.immersivepetroleum.common.IPSaveData;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import flaxbeard.immersivepetroleum.common.network.IPPacketHandler;
import flaxbeard.immersivepetroleum.common.network.MessageSyncReservoirs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.registries.ForgeRegistries;

public class PumpjackHandler {
    public static LinkedHashMap<ResourceLocation, ReservoirType> reservoirs = new LinkedHashMap();
    private static Map<ResourceLocation, Map<ResourceLocation, Integer>> totalWeightMap = new HashMap<ResourceLocation, Map<ResourceLocation, Integer>>();
    public static Map<DimensionChunkCoords, Long> timeCache = new HashMap<DimensionChunkCoords, Long>();
    public static Map<DimensionChunkCoords, OilWorldInfo> reservoirsCache = new HashMap<DimensionChunkCoords, OilWorldInfo>();
    private static int depositSize = 1;

    public static int getFluidAmount(World world, int chunkX, int chunkZ) {
        assert (!world.field_72995_K);
        if (world.field_72995_K) {
            return 0;
        }
        OilWorldInfo info = PumpjackHandler.getOrCreateOilWorldInfo(world, chunkX, chunkZ);
        if (info == null || info.capacity == 0 || info.getType() == null || info.getType().fluidLocation == null || info.current == 0 && info.getType().replenishRate == 0) {
            return 0;
        }
        return info.current;
    }

    public static Fluid getFluid(World world, int chunkX, int chunkZ) {
        assert (!world.field_72995_K);
        if (world.field_72995_K) {
            return null;
        }
        OilWorldInfo info = PumpjackHandler.getOrCreateOilWorldInfo(world, chunkX, chunkZ);
        if (info == null || info.getType() == null) {
            return null;
        }
        return info.getType().getFluid();
    }

    public static int getResidualFluid(World world, int chunkX, int chunkZ) {
        assert (!world.field_72995_K);
        OilWorldInfo info = PumpjackHandler.getOrCreateOilWorldInfo(world, chunkX, chunkZ);
        if (info == null || info.getType() == null || info.getType().fluidLocation == null || info.capacity == 0 || info.current == 0 && info.getType().replenishRate == 0) {
            return 0;
        }
        DimensionChunkCoords coords = new DimensionChunkCoords(world.func_201675_m().func_186058_p(), chunkX / depositSize, chunkZ / depositSize);
        Long l = timeCache.get(coords);
        if (l == null) {
            timeCache.put(coords, world.func_82737_E());
            return info.getType().replenishRate;
        }
        long lastTime = world.func_82737_E();
        timeCache.put(coords, world.func_82737_E());
        return lastTime != l ? info.getType().replenishRate : 0;
    }

    public static OilWorldInfo getOrCreateOilWorldInfo(World world, int chunkX, int chunkZ) {
        return PumpjackHandler.getOrCreateOilWorldInfo(world, new DimensionChunkCoords(world.func_201675_m().func_186058_p(), chunkX, chunkZ), false);
    }

    public static OilWorldInfo getOrCreateOilWorldInfo(World world, DimensionChunkCoords coords, boolean force) {
        assert (!world.field_72995_K);
        if (world.field_72995_K) {
            return null;
        }
        OilWorldInfo worldInfo = reservoirsCache.get(coords);
        if (worldInfo == null) {
            ReservoirType res = null;
            Random r = SharedSeedRandom.func_205190_a((int)coords.field_77276_a, (int)coords.field_77275_b, (long)world.func_72905_C(), (long)90210L);
            boolean empty = r.nextDouble() > (Double)IPConfig.EXTRACTION.reservoir_chance.get();
            double size = r.nextDouble();
            int query = r.nextInt();
            ImmersivePetroleum.log.debug("Empty? {}. Forced? {}. Size: {}, Query: {}", (Object)(empty ? "Yes" : "No"), (Object)(force ? "Yes" : "No"), (Object)size, (Object)query);
            if (!empty || force) {
                ResourceLocation biome = world.getBiomeBody(new BlockPos(coords.field_77276_a << 4, 64, coords.field_77275_b << 4)).getRegistryName();
                ResourceLocation dimension = world.func_201675_m().func_186058_p().getRegistryName();
                int totalWeight = PumpjackHandler.getTotalWeight(dimension, biome);
                ImmersivePetroleum.log.debug("Total Weight: " + totalWeight);
                if (totalWeight > 0) {
                    int weight = Math.abs(query % totalWeight);
                    for (ReservoirType type : reservoirs.values()) {
                        if (!type.isValidDimension(dimension) || !type.isValidBiome(biome) || (weight -= type.weight) >= 0) continue;
                        res = type;
                        break;
                    }
                }
            }
            int capacity = 0;
            if (res != null) {
                ImmersivePetroleum.log.debug("Using: {}", (Object)res.name);
                capacity = (int)((double)(res.maxSize - res.minSize) * size + (double)res.minSize);
            }
            ImmersivePetroleum.log.debug("Capacity: {}", (Object)capacity);
            worldInfo = new OilWorldInfo();
            worldInfo.capacity = capacity;
            worldInfo.current = capacity;
            worldInfo.type = res;
            ImmersivePetroleum.log.debug("Storing {} for {}", (Object)worldInfo, (Object)coords);
            reservoirsCache.put(coords, worldInfo);
        }
        return worldInfo;
    }

    public static void depleteFluid(World world, int chunkX, int chunkZ, int amount) {
        assert (!world.field_72995_K);
        OilWorldInfo info = PumpjackHandler.getOrCreateOilWorldInfo(world, chunkX, chunkZ);
        info.current = Math.max(info.current - amount, 0);
        IPSaveData.setDirty();
    }

    public static int getTotalWeight(ResourceLocation dimension, ResourceLocation biome) {
        Map<ResourceLocation, Integer> dimMap;
        if (!totalWeightMap.containsKey(dimension)) {
            totalWeightMap.put(dimension, new HashMap());
        }
        if ((dimMap = totalWeightMap.get(dimension)).containsKey(biome)) {
            return dimMap.get(biome);
        }
        int totalWeight = 0;
        for (ReservoirType type : reservoirs.values()) {
            if (!type.isValidDimension(dimension) || !type.isValidBiome(biome)) continue;
            totalWeight += type.weight;
        }
        return totalWeight;
    }

    public static ReservoirType addReservoir(ResourceLocation id, ReservoirType reservoir) {
        reservoirs.put(id, reservoir);
        return reservoir;
    }

    public static void recalculateChances(boolean mutePackets) {
        totalWeightMap.clear();
        if (!mutePackets) {
            IPPacketHandler.sendAll(new MessageSyncReservoirs(reservoirs));
        }
    }

    public static class OilWorldInfo {
        public ReservoirType type;
        public ReservoirType overrideType;
        public int capacity;
        public int current;

        public ReservoirType getType() {
            return this.overrideType == null ? this.type : this.overrideType;
        }

        public CompoundNBT writeToNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("capacity", this.capacity);
            tag.func_74768_a("resAmount", this.current);
            if (this.type != null) {
                tag.func_74778_a("type", this.type.name);
            }
            if (this.overrideType != null) {
                tag.func_74778_a("overrideType", this.overrideType.name);
            }
            return tag;
        }

        public static OilWorldInfo readFromNBT(CompoundNBT tag) {
            Object s;
            OilWorldInfo info = new OilWorldInfo();
            info.capacity = tag.func_74762_e("capacity");
            info.current = tag.func_74762_e("resAmount");
            if (tag.func_74764_b("type")) {
                s = tag.func_74779_i("type");
                for (ReservoirType res : reservoirs.values()) {
                    if (!((String)s).equalsIgnoreCase(res.name)) continue;
                    info.type = res;
                }
            } else if (info.current > 0) {
                for (ReservoirType res : reservoirs.values()) {
                    if (!res.name.equalsIgnoreCase("resAmount")) continue;
                    info.type = res;
                }
                if (info.type == null) {
                    return null;
                }
            }
            if (tag.func_74764_b("overrideType")) {
                s = tag.func_74779_i("overrideType");
                for (ReservoirType res : reservoirs.values()) {
                    if (!((String)s).equalsIgnoreCase(res.name)) continue;
                    info.overrideType = res;
                }
            }
            return info;
        }
    }

    public static class ReservoirType
    extends IESerializableRecipe {
        public static final IRecipeType<ReservoirType> TYPE = IRecipeType.func_222147_a((String)"immersivepetroleum:reservoirtype");
        public String name;
        public ResourceLocation fluidLocation;
        public int minSize;
        public int maxSize;
        public int replenishRate;
        public int weight;
        public List<ResourceLocation> dimWhitelist = new ArrayList<ResourceLocation>(0);
        public List<ResourceLocation> dimBlacklist = new ArrayList<ResourceLocation>(0);
        public List<ResourceLocation> bioWhitelist = new ArrayList<ResourceLocation>(0);
        public List<ResourceLocation> bioBlacklist = new ArrayList<ResourceLocation>(0);
        private Fluid fluid;

        public ReservoirType(String name, ResourceLocation id, ResourceLocation fluidLocation, int minSize, int maxSize, int traceAmount, int weight) {
            this(name, id, (Fluid)ForgeRegistries.FLUIDS.getValue(fluidLocation), minSize, maxSize, traceAmount, weight);
        }

        public ReservoirType(String name, ResourceLocation id, Fluid fluid, int minSize, int maxSize, int traceAmount, int weight) {
            super(ItemStack.field_190927_a, TYPE, id);
            this.name = name;
            this.fluidLocation = fluid.getRegistryName();
            this.fluid = fluid;
            this.replenishRate = traceAmount;
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.weight = weight;
        }

        public ReservoirType(CompoundNBT nbt) {
            super(ItemStack.field_190927_a, TYPE, new ResourceLocation(nbt.func_74779_i("id")));
            this.name = nbt.func_74779_i("name");
            this.fluidLocation = new ResourceLocation(nbt.func_74779_i("fluidname"));
            this.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(this.fluidLocation);
            this.minSize = nbt.func_74762_e("minSize");
            this.maxSize = nbt.func_74762_e("maxSize");
            this.replenishRate = nbt.func_74762_e("replenishRate");
            this.dimWhitelist = this.toList(nbt.func_150295_c("dimensionWhitelist", 8));
            this.dimBlacklist = this.toList(nbt.func_150295_c("dimensionBlacklist", 8));
            this.bioWhitelist = this.toList(nbt.func_150295_c("biomeWhitelist", 8));
            this.bioBlacklist = this.toList(nbt.func_150295_c("biomeBlacklist", 8));
        }

        public boolean addDimension(boolean blacklist, ResourceLocation ... names) {
            return this.addDimension(blacklist, Arrays.asList(names));
        }

        public boolean addDimension(boolean blacklist, List<ResourceLocation> names) {
            if (blacklist) {
                return this.dimBlacklist.addAll(names);
            }
            return this.dimWhitelist.addAll(names);
        }

        public boolean addBiome(boolean blacklist, ResourceLocation ... names) {
            return this.addBiome(blacklist, Arrays.asList(names));
        }

        public boolean addBiome(boolean blacklist, List<ResourceLocation> names) {
            if (blacklist) {
                return this.bioBlacklist.addAll(names);
            }
            return this.bioWhitelist.addAll(names);
        }

        public boolean isValidDimension(@Nonnull DimensionType dim) {
            if (dim == null) {
                return false;
            }
            return this.isValidDimension(dim.getRegistryName());
        }

        public boolean isValidDimension(@Nonnull ModDimension dim) {
            return this.isValidDimension(dim.getRegistryName());
        }

        public boolean isValidDimension(@Nonnull ResourceLocation rl) {
            if (this.dimWhitelist.size() > 0) {
                return this.dimWhitelist.contains(rl);
            }
            if (this.dimBlacklist.size() > 0) {
                return !this.dimBlacklist.contains(rl);
            }
            return true;
        }

        public boolean isValidBiome(@Nonnull Biome biome) {
            return this.isValidBiome(biome.getRegistryName());
        }

        public boolean isValidBiome(@Nonnull ResourceLocation rl) {
            if (this.bioWhitelist.size() > 0) {
                return this.bioWhitelist.contains(rl);
            }
            if (this.bioBlacklist.size() > 0) {
                return !this.bioBlacklist.contains(rl);
            }
            return true;
        }

        protected IERecipeSerializer<ReservoirType> getIESerializer() {
            return (IERecipeSerializer)Serializers.RESERVOIR_SERIALIZER.get();
        }

        public ItemStack func_77571_b() {
            return ItemStack.field_190927_a;
        }

        public Fluid getFluid() {
            return this.fluid;
        }

        public CompoundNBT writeToNBT() {
            return this.writeToNBT(new CompoundNBT());
        }

        public CompoundNBT writeToNBT(CompoundNBT nbt) {
            nbt.func_74778_a("name", this.name);
            nbt.func_74778_a("id", this.id.toString());
            nbt.func_74778_a("fluid", this.fluidLocation.toString());
            nbt.func_74768_a("minSize", this.minSize);
            nbt.func_74768_a("maxSize", this.maxSize);
            nbt.func_74768_a("replenishRate", this.replenishRate);
            nbt.func_218657_a("dimensionWhitelist", (INBT)this.toNbt(this.dimWhitelist));
            nbt.func_218657_a("dimensionBlacklist", (INBT)this.toNbt(this.dimBlacklist));
            nbt.func_218657_a("biomeWhitelist", (INBT)this.toNbt(this.bioWhitelist));
            nbt.func_218657_a("biomeBlacklist", (INBT)this.toNbt(this.bioBlacklist));
            return nbt;
        }

        public String toString() {
            return this.writeToNBT().toString();
        }

        private List<ResourceLocation> toList(ListNBT nbtList) {
            ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(0);
            if (nbtList.size() > 0) {
                for (INBT tag : nbtList) {
                    if (!(tag instanceof StringNBT)) continue;
                    list.add(new ResourceLocation(((StringNBT)tag).func_150285_a_()));
                }
            }
            return list;
        }

        private ListNBT toNbt(List<ResourceLocation> list) {
            ListNBT nbtList = new ListNBT();
            for (ResourceLocation rl : list) {
                nbtList.add((Object)new StringNBT(rl.toString()));
            }
            return nbtList;
        }
    }
}

