/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.builders.IEFinishedRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;

public class ReservoirTypeBuilder
extends IEFinishedRecipe<ReservoirTypeBuilder> {
    private String fluid;
    private int fluidMinimum;
    private int fluidMaximum;
    private int fluidTrace;
    private int weight;
    private final JsonArray dimWhitelist = new JsonArray();
    private final JsonArray dimBlacklist = new JsonArray();
    private final JsonArray bioWhitelist = new JsonArray();
    private final JsonArray bioBlacklist = new JsonArray();

    private ReservoirTypeBuilder() {
        super((IERecipeSerializer)Serializers.RESERVOIR_SERIALIZER.get());
        this.addWriter(writer -> writer.addProperty("fluid", this.fluid));
        this.addWriter(writer -> writer.addProperty("fluidminimum", (Number)this.fluidMinimum));
        this.addWriter(writer -> writer.addProperty("fluidcapacity", (Number)this.fluidMaximum));
        this.addWriter(writer -> writer.addProperty("fluidtrace", (Number)this.fluidTrace));
        this.addWriter(writer -> writer.addProperty("weight", (Number)this.weight));
        this.addWriter(writer -> {
            JsonObject dimension = new JsonObject();
            dimension.add("whitelist", (JsonElement)this.dimWhitelist);
            dimension.add("blacklist", (JsonElement)this.dimBlacklist);
            writer.add("dimension", (JsonElement)dimension);
        });
        this.addWriter(writer -> {
            JsonObject biome = new JsonObject();
            biome.add("whitelist", (JsonElement)this.bioWhitelist);
            biome.add("blacklist", (JsonElement)this.bioBlacklist);
            writer.add("biome", (JsonElement)biome);
        });
    }

    public static ReservoirTypeBuilder builder(String name) {
        return (ReservoirTypeBuilder)new ReservoirTypeBuilder().addWriter(writer -> writer.addProperty("name", name));
    }

    public static ReservoirTypeBuilder builder(String name, Fluid fluid, double min, double max, double trace, int weight) {
        return ReservoirTypeBuilder.builder(name).setFluid(fluid).min(min).max(max).trace(trace).weight(weight);
    }

    public ReservoirTypeBuilder setFluid(Fluid fluid) {
        this.fluid = fluid.getRegistryName().toString();
        return this;
    }

    public ReservoirTypeBuilder min(double amount) {
        this.fluidMinimum = (int)Math.floor(amount * 1000.0);
        return this;
    }

    public ReservoirTypeBuilder max(double amount) {
        this.fluidMaximum = (int)Math.floor(amount * 1000.0);
        return this;
    }

    public ReservoirTypeBuilder trace(double amount) {
        this.fluidTrace = (int)Math.floor(amount * 1000.0);
        return this;
    }

    public ReservoirTypeBuilder weight(int amount) {
        this.weight = amount;
        return this;
    }

    public ReservoirTypeBuilder addDimensions(boolean isBlacklist, ResourceLocation ... dimensions) {
        block6: {
            block5: {
                if (!isBlacklist) break block5;
                if (dimensions == null || dimensions.length <= 0) break block6;
                if (this.dimWhitelist.size() > 0) {
                    throw new IllegalArgumentException("Cannot set a whitelist and blacklist at the same time.");
                }
                for (ResourceLocation rl : dimensions) {
                    if (rl == null || this.dimBlacklist.contains((JsonElement)new JsonPrimitive(rl.toString()))) continue;
                    this.dimBlacklist.add(rl.toString());
                }
                break block6;
            }
            if (dimensions != null && dimensions.length > 0) {
                if (this.dimBlacklist.size() > 0) {
                    throw new IllegalArgumentException("Cannot set a whitelist and blacklist at the same time.");
                }
                for (ResourceLocation rl : dimensions) {
                    if (rl == null || this.dimWhitelist.contains((JsonElement)new JsonPrimitive(rl.toString()))) continue;
                    this.dimWhitelist.add(rl.toString());
                }
            }
        }
        return this;
    }

    public ReservoirTypeBuilder addBiomes(boolean isBlacklist, ResourceLocation ... biomes) {
        block6: {
            block5: {
                if (!isBlacklist) break block5;
                if (biomes == null || biomes.length <= 0) break block6;
                if (this.bioWhitelist.size() > 0) {
                    throw new IllegalArgumentException("Cannot set a whitelist and blacklist at the same time.");
                }
                for (ResourceLocation rl : biomes) {
                    if (rl == null || this.bioBlacklist.contains((JsonElement)new JsonPrimitive(rl.toString()))) continue;
                    this.bioBlacklist.add(rl.toString());
                }
                break block6;
            }
            if (biomes != null && biomes.length > 0) {
                if (this.bioBlacklist.size() > 0) {
                    throw new IllegalArgumentException("Cannot set a whitelist and blacklist at the same time.");
                }
                for (ResourceLocation rl : biomes) {
                    if (rl == null || this.bioWhitelist.contains((JsonElement)new JsonPrimitive(rl.toString()))) continue;
                    this.bioWhitelist.add(rl.toString());
                }
            }
        }
        return this;
    }
}

