/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import flaxbeard.immersivepetroleum.client.model.ModelSpeedboat;
import flaxbeard.immersivepetroleum.common.entity.SpeedboatEntity;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpeedboatRenderer
extends EntityRenderer<SpeedboatEntity> {
    private static String texture = "immersivepetroleum:textures/models/boat_motor.png";
    private static String textureArmor = "immersivepetroleum:textures/models/boat_motor_armor.png";
    protected ModelSpeedboat modelBoat = new ModelSpeedboat();

    public SpeedboatRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
        this.field_76989_e = 0.5f;
    }

    public void doRender(SpeedboatEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        this.setupTranslation(x, y, z);
        this.setupRotation(entity, entityYaw, partialTicks);
        ClientUtils.bindTexture((String)(entity.isFireproof ? textureArmor : texture));
        if (entity.func_180799_ab()) {
            GlStateManager.translatef((float)0.0f, (float)-0.24375f, (float)0.0f);
        }
        if (this.field_188301_f) {
            GlStateManager.enableColorMaterial();
        }
        this.modelBoat.render((Entity)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        if (entity.hasIcebreaker) {
            ClientUtils.bindTexture((String)textureArmor);
            this.modelBoat.renderIcebreaker(0.0625f);
        }
        if (entity.hasRudders) {
            ClientUtils.bindTexture((String)textureArmor);
            this.modelBoat.renderRudders((Entity)entity, 0.0625f);
        }
        if (entity.hasTank) {
            ClientUtils.bindTexture((String)textureArmor);
            this.modelBoat.renderTank(0.0625f);
        }
        if (entity.hasPaddles) {
            ClientUtils.bindTexture((String)texture);
            this.modelBoat.renderPaddles((Entity)entity, 0.0625f, partialTicks);
        }
        if (this.field_188301_f) {
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.popMatrix();
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    public boolean func_188295_H_() {
        return true;
    }

    public void renderMultipass(SpeedboatEntity entity, double x, double y, double z, float yaw, float partialTicks) {
        GlStateManager.pushMatrix();
        this.setupTranslation(x, y, z);
        this.setupRotation(entity, yaw, partialTicks);
        ClientUtils.bindTexture((String)texture);
        this.modelBoat.renderMultipass(0.0625f);
        GlStateManager.popMatrix();
    }

    protected ResourceLocation getEntityTexture(SpeedboatEntity entity) {
        return new ResourceLocation(texture);
    }

    public void setupRotation(SpeedboatEntity boat, float yaw, float partialTicks) {
        GlStateManager.rotatef((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        float f = (float)boat.func_70268_h() - partialTicks;
        float f1 = boat.func_70271_g() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            GlStateManager.rotatef((float)(MathHelper.func_76126_a((float)f) * f * f1 / 10.0f * (float)boat.func_70267_i()), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (boat.isBoosting) {
            GlStateManager.rotatef((float)3.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.scalef((float)-1.0f, (float)-1.0f, (float)1.0f);
    }

    public void setupTranslation(double x, double y, double z) {
        GlStateManager.translated((double)x, (double)(y + 0.375), (double)z);
    }
}

