/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockBase;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockItemBase;
import flaxbeard.immersivepetroleum.common.blocks.metal.AutoLubricatorTileEntity;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.common.ToolType;

public class AutoLubricatorBlock
extends IPBlockBase {
    private static final Material material = new Material(MaterialColor.field_151668_h, false, true, true, false, true, false, false, PushReaction.BLOCK);
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty SLAVE = BooleanProperty.func_177716_a((String)"slave");
    static final VoxelShape SHAPE_SLAVE = VoxelShapes.func_197873_a((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125);
    static final VoxelShape SHAPE_MASTER = VoxelShapes.func_197873_a((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375);

    public AutoLubricatorBlock(String name) {
        super(name, Block.Properties.func_200945_a((Material)material).func_200948_a(5.0f, 6.0f).harvestTool(ToolType.AXE).func_200947_a(SoundType.field_185852_e));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)SLAVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, SLAVE});
    }

    @Override
    protected BlockItem createBlockItem() {
        return new AutoLubricatorBlockItem(this);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        AutoLubricatorTileEntity te = new AutoLubricatorTileEntity();
        te.isSlave = (Boolean)state.func_177229_b((IProperty)SLAVE);
        te.facing = (Direction)state.func_177229_b((IProperty)FACING);
        return te;
    }

    public boolean canRenderInLayer(BlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (((Boolean)state.func_177229_b((IProperty)SLAVE)).booleanValue()) {
            worldIn.func_175655_b(pos.func_177982_a(0, -1, 0), true);
        } else {
            worldIn.func_175655_b(pos.func_177982_a(0, 1, 0), false);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof IEBlockInterfaces.IPlayerInteraction) {
            return ((IEBlockInterfaces.IPlayerInteraction)te).interact(hit.func_216354_b(), player, handIn, player.func_184586_b(handIn), (float)hit.func_216347_e().field_72450_a, (float)hit.func_216347_e().field_72448_b, (float)hit.func_216347_e().field_72449_c);
        }
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            worldIn.func_175656_a(pos.func_177982_a(0, 1, 0), (BlockState)state.func_206870_a((IProperty)SLAVE, (Comparable)Boolean.valueOf(true)));
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof IEBlockInterfaces.IReadOnPlacement) {
                ((IEBlockInterfaces.IReadOnPlacement)te).readOnPlacement(placer, stack);
            }
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity te = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (te instanceof AutoLubricatorTileEntity && ((AutoLubricatorTileEntity)te).isSlave) {
            ServerWorld world = builder.func_216018_a();
            BlockPos pos = (BlockPos)builder.func_216019_b(LootParameters.field_216286_f);
            te = world.func_175625_s(pos.func_177972_a(Direction.DOWN));
        }
        if (te instanceof IEBlockInterfaces.ITileDrop) {
            return ((IEBlockInterfaces.ITileDrop)te).getTileDrops(builder.func_216015_a(LootParameters.field_216287_g, (Object)state).func_216022_a(LootParameterSets.field_216267_h));
        }
        return Collections.emptyList();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((IProperty)SLAVE) != false ? SHAPE_SLAVE : SHAPE_MASTER;
    }

    public static class AutoLubricatorBlockItem
    extends IPBlockItemBase {
        public AutoLubricatorBlockItem(Block blockIn) {
            super(blockIn, new Item.Properties().func_200916_a(ImmersivePetroleum.creativeTab));
        }

        protected boolean func_195944_a(BlockItemUseContext con, BlockState state) {
            if (super.func_195944_a(con, state)) {
                BlockState stateAbove = con.func_195991_k().func_180495_p(con.func_195995_a().func_177982_a(0, 1, 0));
                return stateAbove == Blocks.field_150350_a.func_176223_P() || stateAbove.func_185904_a() == Material.field_151579_a;
            }
            return false;
        }
    }
}

