/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks;

import flaxbeard.immersivepetroleum.common.CommonEventHandler;
import flaxbeard.immersivepetroleum.common.util.fluids.IPFluid;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.IFluidState;
import net.minecraft.state.IProperty;
import net.minecraft.state.IStateHolder;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidAttributes;

public class BlockNapalm
extends IPFluid {
    public BlockNapalm(String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, @Nullable Consumer<FluidAttributes.Builder> buildAttributes) {
        super(name, stillTexture, flowingTexture, buildAttributes);
    }

    @Override
    protected FlowingFluidBlock createBlock() {
        FlowingFluidBlock block = new FlowingFluidBlock(() -> this.source, Block.Properties.func_200945_a((Material)Material.field_151586_h)){

            protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
                super.func_206840_a(builder);
                builder.func_206894_a(this.func_176194_O().func_177623_d().toArray(new IProperty[0]));
            }

            public IFluidState func_204507_t(BlockState state) {
                IFluidState baseState = super.func_204507_t(state);
                for (IProperty prop : this.func_176194_O().func_177623_d()) {
                    if (prop == FlowingFluidBlock.field_176367_b) continue;
                    baseState = this.withCopiedValue((IProperty)prop, (IStateHolder)baseState, (IStateHolder<?>)state);
                }
                return baseState;
            }

            private <T extends IStateHolder<T>, S extends Comparable<S>> T withCopiedValue(IProperty<S> prop, T oldState, IStateHolder<?> copyFrom) {
                return (T)((IStateHolder)oldState.func_206870_a(prop, copyFrom.func_177229_b(prop)));
            }

            public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
                for (Direction facing : Direction.values()) {
                    BlockPos notifyPos = pos.func_177972_a(facing);
                    if (!(worldIn.func_180495_p(notifyPos).func_177230_c() instanceof FireBlock) && worldIn.func_180495_p(notifyPos).func_185904_a() != Material.field_151581_o) continue;
                    worldIn.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                    break;
                }
                super.func_220082_b(state, worldIn, pos, oldState, isMoving);
            }

            public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
                int d;
                if (!(!(worldIn.func_180495_p(fromPos).func_177230_c() instanceof FireBlock) && worldIn.func_180495_p(fromPos).func_185904_a() != Material.field_151581_o || CommonEventHandler.napalmPositions.containsKey(d = worldIn.func_201675_m().func_186058_p().func_186068_a()) && CommonEventHandler.napalmPositions.get(d).contains(fromPos))) {
                    BlockNapalm.this.processFire(worldIn, pos);
                }
                super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
            }
        };
        return block;
    }

    public void processFire(World world, BlockPos pos) {
        int d = world.func_201675_m().func_186058_p().func_186068_a();
        if (!CommonEventHandler.napalmPositions.containsKey(d)) {
            CommonEventHandler.napalmPositions.put(d, new ArrayList());
        }
        CommonEventHandler.napalmPositions.get(d).add(pos);
        world.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 3);
        for (Direction facing : Direction.values()) {
            BlockPos notifyPos = pos.func_177972_a(facing);
            Block block = world.func_180495_p(notifyPos).func_177230_c();
            if (block != this.block) continue;
            CommonEventHandler.napalmPositions.get(d).add(notifyPos);
        }
    }
}

