/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks;

import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockBase;
import flaxbeard.immersivepetroleum.common.blocks.metal.GasGeneratorTileEntity;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.common.ToolType;

public class GasGeneratorBlock
extends IPBlockBase {
    private static final Material material = new Material(MaterialColor.field_151668_h, false, true, true, false, false, false, false, PushReaction.BLOCK);
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    static final VoxelShape SHAPE = VoxelShapes.func_197873_a((double)1.0E-4, (double)1.0E-4, (double)1.0E-4, (double)0.9999, (double)0.9999, (double)0.9999);

    public GasGeneratorBlock() {
        super("gas_generator", Block.Properties.func_200945_a((Material)material).func_200948_a(5.0f, 6.0f).harvestTool(ToolType.PICKAXE).func_200947_a(SoundType.field_185852_e));
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public boolean canRenderInLayer(BlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT || layer == BlockRenderLayer.SOLID;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0;
    }

    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof IEBlockInterfaces.IPlayerInteraction) {
            return ((IEBlockInterfaces.IPlayerInteraction)te).interact(hit.func_216354_b(), player, handIn, player.func_184586_b(handIn), (float)hit.func_216347_e().field_72450_a, (float)hit.func_216347_e().field_72448_b, (float)hit.func_216347_e().field_72449_c);
        }
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof IEBlockInterfaces.IReadOnPlacement) {
            ((IEBlockInterfaces.IReadOnPlacement)te).readOnPlacement(placer, stack);
            if (te instanceof IEBaseTileEntity) {
                ((IEBaseTileEntity)te).markContainingBlockForUpdate(null);
            }
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity te = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (te instanceof IEBlockInterfaces.ITileDrop) {
            return ((IEBlockInterfaces.ITileDrop)te).getTileDrops(builder.func_216015_a(LootParameters.field_216287_g, (Object)state).func_216022_a(LootParameterSets.field_216267_h));
        }
        return Collections.emptyList();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        GasGeneratorTileEntity te = new GasGeneratorTileEntity();
        te.setFacing((Direction)state.func_177229_b((IProperty)FACING));
        return te;
    }
}

