/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks;

import com.google.common.base.Preconditions;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IPBlockBaseAdvanced
extends IPBlockBase {
    protected static IProperty<?>[] tempProperties;
    public final String name;
    public final IProperty<?>[] additionalProperties;
    boolean isHidden;
    boolean hasFlavour;
    protected List<BlockRenderLayer> renderLayers = Collections.singletonList(BlockRenderLayer.SOLID);
    protected int lightOpacity;
    protected PushReaction mobilityFlag = PushReaction.NORMAL;
    protected boolean canHammerHarvest;
    protected boolean notNormalBlock;

    public IPBlockBaseAdvanced(String name, Block.Properties blockProps, @Nullable Class<? extends BlockItem> itemBlock, IProperty<?> ... additionalProperties) {
        super(name, IPBlockBaseAdvanced.setTempProperties(blockProps, additionalProperties));
        this.name = name;
        this.additionalProperties = Arrays.copyOf(tempProperties, tempProperties.length);
        this.func_180632_j(this.getInitDefaultState());
        if (itemBlock != null) {
            try {
                Item item = (Item)itemBlock.getConstructor(Block.class, Item.Properties.class).newInstance(new Object[]{this, new Item.Properties().func_200916_a(ImmersivePetroleum.creativeTab)});
                item.setRegistryName(this.getRegistryName());
                IPContent.registeredIPItems.add(item);
            }
            catch (Exception var7) {
                throw new RuntimeException(var7);
            }
        }
        this.lightOpacity = 15;
    }

    protected static Block.Properties setTempProperties(Block.Properties blockProps, Object[] additionalProperties) {
        ArrayList<IProperty> propList = new ArrayList<IProperty>();
        Object[] var3 = additionalProperties;
        int var4 = additionalProperties.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            Object o = var3[var5];
            if (o instanceof IProperty) {
                propList.add((IProperty)o);
            }
            if (!(o instanceof IProperty[])) continue;
            propList.addAll(Arrays.asList((IProperty[])o));
        }
        tempProperties = propList.toArray(new IProperty[0]);
        return blockProps.func_208770_d();
    }

    public IPBlockBaseAdvanced setHidden(boolean shouldHide) {
        this.isHidden = shouldHide;
        return this;
    }

    public IPBlockBaseAdvanced setNotNormalBlock() {
        this.notNormalBlock = true;
        return this;
    }

    public IPBlockBaseAdvanced setHasFlavour(boolean shouldHave) {
        this.hasFlavour = shouldHave;
        return this;
    }

    public IPBlockBaseAdvanced setBlockLayer(BlockRenderLayer ... layer) {
        Preconditions.checkArgument((layer.length > 0 ? 1 : 0) != 0);
        this.renderLayers = Arrays.asList(layer);
        return this;
    }

    public IPBlockBaseAdvanced setMobility(PushReaction flag) {
        this.mobilityFlag = flag;
        return this;
    }

    public IPBlockBaseAdvanced setLightOpacity(int opacity) {
        this.lightOpacity = opacity;
        return this;
    }

    public IPBlockBaseAdvanced setHammerHarvest() {
        this.canHammerHarvest = true;
        return this;
    }

    protected BlockState getInitDefaultState() {
        return (BlockState)this.field_176227_L.func_177621_b();
    }

    public boolean canRenderInLayer(BlockState state, BlockRenderLayer layer) {
        return this.renderLayers.contains(layer);
    }

    public BlockRenderLayer func_180664_k() {
        return this.notNormalBlock ? BlockRenderLayer.CUTOUT : BlockRenderLayer.SOLID;
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        if (this.notNormalBlock) {
            return 0;
        }
        if (state.func_200015_d(worldIn, pos)) {
            return this.lightOpacity;
        }
        return state.func_200131_a(worldIn, pos) ? 0 : 1;
    }

    public PushReaction func_149656_h(BlockState state) {
        return this.mobilityFlag;
    }

    public boolean func_200123_i(BlockState p_200123_1_, IBlockReader p_200123_2_, BlockPos p_200123_3_) {
        return this.notNormalBlock || super.func_200123_i(p_200123_1_, p_200123_2_, p_200123_3_);
    }

    public boolean func_220060_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return !this.notNormalBlock;
    }

    public boolean func_220081_d(BlockState state, IBlockReader world, BlockPos pos) {
        return !this.notNormalBlock;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(tempProperties);
    }

    protected <V extends Comparable<V>> BlockState applyProperty(BlockState in, IProperty<V> prop, Object val) {
        return (BlockState)in.func_206870_a(prop, (Comparable)val);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((IItemProvider)this, 1));
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int eventID, int eventParam) {
        if (worldIn.field_72995_K && eventID == 255) {
            worldIn.func_184138_a(pos, state, state, 3);
            return true;
        }
        return false;
    }
}

